/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.config.ShardingConfig;
import org.apache.commons.collections4.ListUtils;

public class VoucherSaveHelper {
    private static Log logger = LogFactory.getLog(VoucherSaveHelper.class);

    public static void saveGLVoucherEntries(long orgID, long periodID, List<DynamicObject> entries) {
        List pts = ListUtils.partition(entries, (int)10000);
        for (List el : pts) {
            HintCondition hintOrg = new HintCondition("forgid", "=", (Object)orgID);
            HintCondition hintPeroid = new HintCondition("fperiodid", "=", (Object)periodID);
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();
            Throwable throwable = null;
            try {
                SaveServiceHelper.save((DynamicObject[])el.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
    }

    public static void saveBizVoucherEntries(long orgID, long periodID, List<DynamicObject> entries) {
        List pts = ListUtils.partition(entries, (int)10000);
        for (List el : pts) {
            HintCondition hintOrg = new HintCondition("forgid", "=", (Object)orgID);
            HintCondition hintPeroid = new HintCondition("fperiodid", "=", (Object)periodID);
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ai_bizvoucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();
            Throwable throwable = null;
            try {
                SaveServiceHelper.save((DynamicObject[])el.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
    }

    public static Object[] saveGLVouchers(long orgID, long periodID, List<DynamicObject> vouchers) {
        ShardingConfig hintConfig = XDBConfig.getShardingConfigProvider().getConfig("t_gl_voucher");
        if (hintConfig != null) {
            HintCondition hintOrg = new HintCondition("forgid", "=", (Object)orgID);
            HintCondition hintPeroid = new HintCondition("fperiodid", "=", (Object)periodID);
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();){
                logger.info("SaveVoucerByHint,OrgID={},PeriodID={},VoucherSize={}", new Object[]{orgID, periodID, vouchers.size()});
                Object[] objectArray = SaveServiceHelper.save((DynamicObject[])vouchers.toArray(new DynamicObject[0]));
                return objectArray;
            }
        }
        return SaveServiceHelper.save((DynamicObject[])vouchers.toArray(new DynamicObject[0]));
    }
}

