/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.cacheservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bd.cache.cacheservice.AbstractDataCacheService;
import kd.fi.bd.cache.cacheservice.IDataCacheEntry;
import kd.fi.bd.cache.cacheservice.IDataCacheService;
import kd.fi.bd.cache.cacheservice.IDataDistributeCache;
import kd.fi.v2.fah.cache.cacheservice.DataModelCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.EventRuleModelCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.MappingRowCountCacheService;
import kd.fi.v2.fah.cache.cacheservice.MappingStructureCacheService;

public class FAHDataCacheMgr {
    public static final FAHDataCacheMgr instance = new FAHDataCacheMgr();
    protected IDataCacheEntry distributeCahce = new CacheEntry("fah");
    private static final int Default_Cache_Experied_Time = 120;
    protected int experiedTime = 120;
    protected Map<Class, IDataCacheService> cacheServiceInstanceMap = new HashMap<Class, IDataCacheService>(1);

    private void initCacheMgr() {
        this.registerCacheService(DataModelCfgCacheService.class);
        this.registerCacheService(MappingStructureCacheService.class);
        this.registerCacheService(MappingRowCountCacheService.class);
        this.registerCacheService(EventRuleModelCfgCacheService.class);
    }

    public FAHDataCacheMgr() {
        this.initCacheMgr();
    }

    protected void registerCacheService(IDataCacheService cacheServiceInstance) {
        if (cacheServiceInstance == null) {
            return;
        }
        this.cacheServiceInstanceMap.put(cacheServiceInstance.getClass(), cacheServiceInstance);
    }

    protected void registerCacheService(Class<? extends AbstractDataCacheService> cacheServiceInstanceClassType) {
        if (cacheServiceInstanceClassType == null) {
            return;
        }
        try {
            this.cacheServiceInstanceMap.put(cacheServiceInstanceClassType, (IDataCacheService)cacheServiceInstanceClassType.getConstructor(IDataCacheEntry.class, Integer.TYPE).newInstance(this.distributeCahce, this.experiedTime));
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
    }

    public <T extends IDataCacheService> T getDataCacheService(Class<T> classType) {
        return (T)this.cacheServiceInstanceMap.get(classType);
    }

    public DataModelCfgCacheService getDataModelCfgCacheService() {
        return this.getDataCacheService(DataModelCfgCacheService.class);
    }

    public MappingStructureCacheService getMappingStructureCacheService() {
        return this.getDataCacheService(MappingStructureCacheService.class);
    }

    public MappingRowCountCacheService getMappingRowCountCacheService() {
        return this.getDataCacheService(MappingRowCountCacheService.class);
    }

    public EventRuleModelCfgCacheService getEventRuleModelCfgCacheService() {
        return this.getDataCacheService(EventRuleModelCfgCacheService.class);
    }

    static class CacheEntry
    extends IDataDistributeCache {
        public CacheEntry(String name) {
            super(AppCache.get((String)name));
        }
    }
}

