/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.cache.cacheservice.AbstractDataCacheService;
import kd.fi.bd.cache.cacheservice.IDataCacheEntry;
import kd.fi.bd.util.exception.KDExceptionBuilder;
import kd.fi.v2.fah.constant.enums.cache.FahRegisteredCacheTypeEnum;
import kd.fi.v2.fah.storage.IDataItemKey;
import org.apache.commons.lang3.StringUtils;

public abstract class FahAbstractDataCacheService<MODEL, PARAM>
extends AbstractDataCacheService<MODEL, PARAM>
implements IDataItemKey<String> {
    private static final Log logger = LogFactory.getLog(FahAbstractDataCacheService.class);
    protected FahRegisteredCacheTypeEnum cacheType;
    protected String cacheServiceKey;
    protected int refreshInterval;
    protected int maxCacheItemCnt;
    protected int storageIndex;
    protected transient ReentrantLock cacheServiceLock = new ReentrantLock();

    protected FahAbstractDataCacheService(IDataCacheEntry cacheEntry, int experiedTime) {
        super(cacheEntry, experiedTime);
    }

    public FahAbstractDataCacheService(IDataCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public MODEL tryLoadFromCacheOnly(PARAM cacheKey, Object ... keyParams) {
        String cacheTypeKey = this.buildCacheTypeKey(cacheKey, keyParams);
        logger.info("{}: cacheServiceKey={}, cacheTypeKey={}, param={}, keyParams={}", new Object[]{this.getClass().getSimpleName(), this.cacheServiceKey, cacheTypeKey, cacheKey, keyParams});
        return this.tryLoadFromCacheOnly(cacheTypeKey);
    }

    protected MODEL tryLoadFromCacheOnly(String cacheTypeKey) {
        Object resultData = null;
        try {
            String jsonString = (String)this.cacheEntry.get(cacheTypeKey, String.class);
            logger.debug("jsonString={}", (Object)jsonString);
            if (StringUtils.isNotEmpty((CharSequence)jsonString) && (resultData = this.deSerializeToModel(jsonString)) != null) {
                logger.debug("resultData={}", resultData);
                if (this.validateDataModel(resultData)) {
                    return (MODEL)resultData;
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public MODEL loadFromCache(boolean forceReloadFromResource, PARAM cacheKey, Object ... keyParams) {
        String cacheTypeKey = this.buildCacheTypeKey(cacheKey, keyParams);
        logger.info("{}: cacheServiceKey={}, cacheTypeKey={}, param={}, keyParams={}", new Object[]{this.getClass().getSimpleName(), this.cacheServiceKey, cacheTypeKey, cacheKey, keyParams});
        Object resultData = null;
        boolean reloadFromDB = true;
        if (!forceReloadFromResource) {
            MODEL MODEL = this.tryLoadFromCacheOnly(cacheTypeKey);
            resultData = MODEL;
            boolean bl = reloadFromDB = MODEL != null;
        }
        if (reloadFromDB && !this.isSupportReloadFromResource()) {
            throw new RuntimeException(String.format("Not Support Reload From Resource : [%s, %s]", cacheTypeKey, Arrays.deepToString(keyParams)));
        }
        if (reloadFromDB) {
            try {
                resultData = this.reloadFromResource(cacheKey, keyParams);
            }
            catch (Exception ex) {
                String msg = String.format("Reload [%s, %s] From Resource Error: %s", cacheTypeKey, Arrays.deepToString(keyParams), ex.getMessage());
                logger.error(msg, (Throwable)ex);
                throw KDExceptionBuilder.buildKDBizException((String)msg, (Throwable)ex, (Object[])new Object[0]);
            }
            if (resultData != null) {
                this.forcePutCache(cacheTypeKey, resultData, this.experiedTime);
            }
        }
        return (MODEL)resultData;
    }

    public void forcePutCache(String cacheTypeKey, MODEL cacheData, Integer expiredTime) {
        if (expiredTime != null) {
            this.cacheEntry.put(cacheTypeKey, (Object)this.serializeToString(cacheData), expiredTime.intValue());
        } else {
            this.cacheEntry.put(cacheTypeKey, (Object)this.serializeToString(cacheData));
        }
    }

    public void forcePutCache(String cacheTypeKey, MODEL cacheData) {
        this.forcePutCache(cacheTypeKey, cacheData, this.experiedTime);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getItemKey() {
        return this.cacheServiceKey;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public ReentrantLock getCacheServiceLock() {
        return this.cacheServiceLock;
    }

    public void lock() {
        this.cacheServiceLock.lock();
    }

    public void unlock() {
        this.cacheServiceLock.unlock();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean tryLock() {
        return this.cacheServiceLock.tryLock();
    }

    public FahRegisteredCacheTypeEnum getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(FahRegisteredCacheTypeEnum cacheType) {
        this.cacheType = cacheType;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getMaxCacheItemCnt() {
        return this.maxCacheItemCnt;
    }

    public void setMaxCacheItemCnt(int maxCacheItemCnt) {
        this.maxCacheItemCnt = maxCacheItemCnt;
    }

    public int getStorageIndex() {
        return this.storageIndex;
    }

    public void setStorageIndex(int storageIndex) {
        this.storageIndex = storageIndex;
    }

    public String getCacheServiceKey() {
        return this.cacheServiceKey;
    }

    public void setCacheServiceKey(String cacheServiceKey) {
        this.cacheServiceKey = cacheServiceKey;
    }
}

