/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common.config;

import java.io.Serializable;
import java.util.Objects;

public class TaskProcessDataCacheConfig
implements Serializable {
    private boolean allowExternalCacheService;
    private boolean blockOnExcess;
    private long blockWaitTimeOut;
    private int maxInternalCacheCnt;
    private int maxExternalCacheCnt;

    public TaskProcessDataCacheConfig() {
        this.allowExternalCacheService = true;
        this.blockOnExcess = true;
        this.blockWaitTimeOut = 300000L;
        this.maxInternalCacheCnt = 20;
        this.maxExternalCacheCnt = 2000;
    }

    public TaskProcessDataCacheConfig(boolean allowExternalCacheService, int maxInternalCacheCnt, int maxExternalCacheCnt) {
        this.allowExternalCacheService = allowExternalCacheService;
        this.maxInternalCacheCnt = maxInternalCacheCnt;
        this.maxExternalCacheCnt = maxExternalCacheCnt;
    }

    public TaskProcessDataCacheConfig(boolean allowExternalCacheService, boolean blockOnExcess, long blockWaitTimeOut, int maxInternalCacheCnt, int maxExternalCacheCnt) {
        this.allowExternalCacheService = allowExternalCacheService;
        this.blockOnExcess = blockOnExcess;
        this.blockWaitTimeOut = blockWaitTimeOut;
        this.maxInternalCacheCnt = maxInternalCacheCnt;
        this.maxExternalCacheCnt = maxExternalCacheCnt;
    }

    public String toString() {
        return "TaskProcessDataCacheConfig{allowExternalCacheService=" + this.allowExternalCacheService + ", blockOnExcess=" + this.blockOnExcess + ", blockWaitTimeOut=" + this.blockWaitTimeOut + ", maxInternalCacheCnt=" + this.maxInternalCacheCnt + ", maxExternalCacheCnt=" + this.maxExternalCacheCnt + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskProcessDataCacheConfig)) {
            return false;
        }
        TaskProcessDataCacheConfig that = (TaskProcessDataCacheConfig)o;
        return this.allowExternalCacheService == that.allowExternalCacheService && this.blockOnExcess == that.blockOnExcess && this.blockWaitTimeOut == that.blockWaitTimeOut && this.maxInternalCacheCnt == that.maxInternalCacheCnt && this.maxExternalCacheCnt == that.maxExternalCacheCnt;
    }

    public int hashCode() {
        return Objects.hash(this.allowExternalCacheService, this.blockOnExcess, this.blockWaitTimeOut, this.maxInternalCacheCnt, this.maxExternalCacheCnt);
    }

    public boolean canPutInternalCache(int currentSize) {
        return this.maxInternalCacheCnt == -1 || this.maxInternalCacheCnt > currentSize;
    }

    public TaskProcessDataCacheConfig copy() {
        return new TaskProcessDataCacheConfig(this.allowExternalCacheService, this.blockOnExcess, this.blockWaitTimeOut, this.maxInternalCacheCnt, this.maxExternalCacheCnt);
    }

    public boolean isAllowExternalCacheService() {
        return this.allowExternalCacheService;
    }

    public void setAllowExternalCacheService(boolean allowExternalCacheService) {
        this.allowExternalCacheService = allowExternalCacheService;
    }

    public boolean isBlockOnExcess() {
        return this.blockOnExcess;
    }

    public void setBlockOnExcess(boolean blockOnExcess) {
        this.blockOnExcess = blockOnExcess;
    }

    public long getBlockWaitTimeOut() {
        return this.blockWaitTimeOut;
    }

    public void setBlockWaitTimeOut(long blockWaitTimeOut) {
        this.blockWaitTimeOut = blockWaitTimeOut;
    }

    public int getMaxInternalCacheCnt() {
        return this.maxInternalCacheCnt;
    }

    public int setMaxInternalCacheCnt(int maxInternalCacheCnt) {
        this.maxInternalCacheCnt = maxInternalCacheCnt;
        return this.maxInternalCacheCnt;
    }

    public int getMaxExternalCacheCnt() {
        return this.maxExternalCacheCnt;
    }

    public void setMaxExternalCacheCnt(int maxExternalCacheCnt) {
        this.maxExternalCacheCnt = maxExternalCacheCnt;
    }
}

