/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dlock.DLock;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.common.CacheGCStrategyInfo;
import kd.fi.v2.fah.cache.common.FahAbstractDataCacheService;
import kd.fi.v2.fah.cache.common.IFahRefDataCachePoolMgr;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.cache.common.impl.FahLRUCacheStorageImpl;

public class FahJVMRefDataCachePoolMgrImpl
implements IFahRefDataCachePoolMgr {
    public static final IFahRefDataCachePoolMgr instance = new FahJVMRefDataCachePoolMgrImpl();
    private static final SimpleDataDistributeCacheService _DistCacheEntry = SimpleDataDistributeCacheService.getInstance();
    protected final Map<String, PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl>> registeredCache = new HashMap(8);
    protected final TreeMap<Long, CacheGCStrategyInfo> cacheRefreshInfoMap = new TreeMap();
    protected long nextGCCheckTime = System.currentTimeMillis() + 6000L;

    protected FahJVMRefDataCachePoolMgrImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerCacheService(FahAbstractDataCacheService<?, ?> registerCacheService) {
        if (registerCacheService == null) {
            return false;
        }
        Map<String, PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl>> map = this.registeredCache;
        synchronized (map) {
            this.registeredCache.put(registerCacheService.getCacheServiceKey(), new PairTuple(registerCacheService, (Object)new FahLRUCacheStorageImpl(registerCacheService.getCacheType().getDefaultMaxCacheItemCnt())));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl> removeCacheService(String cacheServiceKey) {
        Map<String, PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl>> map = this.registeredCache;
        synchronized (map) {
            return this.registeredCache.remove(cacheServiceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl> getDistributedCacheInfo(String cacheServiceKey) {
        Map<String, PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl>> map = this.registeredCache;
        synchronized (map) {
            return this.registeredCache.get(cacheServiceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FahLRUCacheStorageImpl getCacheStorageRef(String cacheServiceKey) {
        Map<String, PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl>> map = this.registeredCache;
        synchronized (map) {
            PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl> pair = this.registeredCache.get(cacheServiceKey);
            return pair != null ? (FahLRUCacheStorageImpl)pair.getValue() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCachedRefData(String cacheServiceKey, Serializable cacheDataKey) {
        Object cacheData;
        PairTuple<FahAbstractDataCacheService<?, ?>, FahLRUCacheStorageImpl> pair = this.getDistributedCacheInfo(cacheServiceKey);
        if (pair == null) {
            return null;
        }
        FahAbstractDataCacheService cacheService = (FahAbstractDataCacheService)pair.getKey();
        FahLRUCacheStorageImpl storage = (FahLRUCacheStorageImpl)pair.getValue();
        ReentrantLock jvmLock = cacheService.getCacheServiceLock();
        try {
            jvmLock.lock();
            cacheData = storage.get(cacheDataKey);
            if (cacheData != null) {
                Object v = cacheData;
                return (T)v;
            }
            cacheData = cacheService.tryLoadFromCacheOnly(cacheDataKey, new Object[0]);
            if (cacheData != null) {
                storage.put(cacheDataKey, cacheData);
            } else {
                String distributeLockKey = cacheService.buildCacheTypeKey(cacheDataKey, new Object[0]);
                cacheData = cacheService.reloadFromResource(distributeLockKey, new Object[0]);
                if (cacheData == null) {
                    T t = null;
                    return t;
                }
                try (DLock distributeLock = DLock.create((String)distributeLockKey);){
                    if (distributeLock.tryLock()) {
                        _DistCacheEntry.putEx(distributeLockKey, cacheData, cacheService.getRefreshInterval());
                    }
                }
            }
            storage.put(cacheDataKey, cacheData);
        }
        finally {
            jvmLock.unlock();
        }
        long refreshTime = System.currentTimeMillis() + (long)cacheService.getRefreshInterval();
        CacheGCStrategyInfo strategyInfo = new CacheGCStrategyInfo(cacheServiceKey, cacheDataKey, true, refreshTime);
        TreeMap<Long, CacheGCStrategyInfo> treeMap = this.cacheRefreshInfoMap;
        synchronized (treeMap) {
            this.cacheRefreshInfoMap.put(refreshTime, strategyInfo);
        }
        return (T)cacheData;
    }

    @Override
    public void doCacheGC() {
    }
}

