/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common.impl;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.fi.v2.fah.cache.common.FahCacheUtilHelper;
import kd.fi.v2.fah.cache.common.IFahTaskProcessDataCacheStorage;
import kd.fi.v2.fah.cache.common.ITaskResultCacheManager;
import kd.fi.v2.fah.cache.common.config.TaskProcessDataCacheConfig;
import kd.fi.v2.fah.constant.enums.cache.CacheDataStoredLocationEnum;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.task.common.IDataChangeListener;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.utils.StringUtils;

public class FahTaskProcessDataCacheStorage<CACHE_DATA extends Serializable>
implements IDataItemKey<String>,
Iterator<CACHE_DATA>,
IFahTaskProcessDataCacheStorage<CACHE_DATA> {
    protected FahTaskGrpTypeEnum taskGrpType;
    private ITaskResultCacheManager distributedCacheEntry;
    protected final long requestId;
    protected final TaskProcessDataCacheConfig cacheConfig;
    protected final Queue<CACHE_DATA> localCacheQueue;
    protected final BitSet batchStoreLocationFlags;
    protected final AtomicInteger maxRegisterBatchNo;
    protected final AtomicInteger maxUsedBatchNo;
    protected final Class<CACHE_DATA> _cacheDataClassType;
    protected final transient String _cachePreKey;
    protected transient IDataChangeListener dataChangeListener;

    protected FahTaskProcessDataCacheStorage(long requestId, String cacheTypeKey, Class<CACHE_DATA> cacheDataClass, TaskProcessDataCacheConfig cacheConfig, ITaskResultCacheManager distributedCacheEntry) {
        if (StringUtils.isEmpty((String)cacheTypeKey)) {
            throw new IllegalArgumentException("Task Batch Data Cache Type Key cannot be null!");
        }
        this._cacheDataClassType = cacheDataClass;
        if (this._cacheDataClassType == null) {
            throw new IllegalArgumentException("Task Batch Data Class Type cannot be null!");
        }
        this.cacheConfig = cacheConfig;
        if (this.cacheConfig == null) {
            throw new IllegalArgumentException("TaskProcessDataCacheConfig cannot be null!");
        }
        Object[] objectArray = new Object[1];
        this.requestId = requestId;
        objectArray[0] = this.requestId;
        this._cachePreKey = FahCacheUtilHelper.buildCacheTypeKey(cacheTypeKey, objectArray);
        this.localCacheQueue = new ConcurrentLinkedQueue<CACHE_DATA>();
        this.distributedCacheEntry = distributedCacheEntry;
        this.maxRegisterBatchNo = new AtomicInteger(0);
        this.maxUsedBatchNo = new AtomicInteger(0);
        this.batchStoreLocationFlags = new BitSet(0);
    }

    public FahTaskProcessDataCacheStorage(long requestId, Class<CACHE_DATA> cacheDataClass, TaskProcessDataCacheConfig cacheConfig, ITaskResultCacheManager distributedCacheEntry) {
        this(requestId, cacheDataClass == null ? null : cacheDataClass.getSimpleName(), cacheDataClass, cacheConfig, distributedCacheEntry);
    }

    @Override
    public CacheDataStoredLocationEnum put(CACHE_DATA cacheData) {
        if (cacheData == null) {
            return null;
        }
        int batchSeqNo = this.maxRegisterBatchNo.get();
        if (this.cacheConfig.canPutInternalCache(this.localCacheQueue.size())) {
            int dataSeqNo = this.maxRegisterBatchNo.incrementAndGet();
            this.localCacheQueue.add(cacheData);
            if (this.dataChangeListener != null) {
                this.dataChangeListener.onDataChange(IDataChangeListener.DataChangeModeEnum.Add, this._cachePreKey, dataSeqNo, cacheData);
            }
            return CacheDataStoredLocationEnum.Task_Context;
        }
        if (this.distributedCacheEntry != null && this.cacheConfig.isAllowExternalCacheService() && this.distributedCacheEntry.put(this._cachePreKey, batchSeqNo, cacheData, 3600)) {
            int dataSeqNo = this.maxRegisterBatchNo.incrementAndGet();
            this.batchStoreLocationFlags.set(batchSeqNo);
            if (this.dataChangeListener != null) {
                this.dataChangeListener.onDataChange(IDataChangeListener.DataChangeModeEnum.Add, this._cachePreKey, dataSeqNo, cacheData);
            }
            return CacheDataStoredLocationEnum.Distributed;
        }
        return this.putLocalCacheQueue(cacheData, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheDataStoredLocationEnum putLocalCacheQueue(CACHE_DATA cacheData, long waitTimeOut) {
        int maxCnt = this.cacheConfig.getMaxInternalCacheCnt();
        Queue<CACHE_DATA> queue = this.localCacheQueue;
        synchronized (queue) {
            while (maxCnt <= this.localCacheQueue.size()) {
                try {
                    if (waitTimeOut >= 0L) {
                        this.localCacheQueue.wait(waitTimeOut);
                        continue;
                    }
                    this.localCacheQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        int dataSeqNo = this.maxRegisterBatchNo.incrementAndGet();
        this.localCacheQueue.add(cacheData);
        if (this.dataChangeListener != null) {
            this.dataChangeListener.onDataChange(IDataChangeListener.DataChangeModeEnum.Add, this._cachePreKey, dataSeqNo, cacheData);
        }
        return CacheDataStoredLocationEnum.Task_Context;
    }

    @Override
    public boolean hasNext() {
        return !this.localCacheQueue.isEmpty() || this.maxRegisterBatchNo.get() > this.maxUsedBatchNo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CACHE_DATA next() {
        Serializable result = null;
        if (this.hasNext()) {
            int dataSeqNo;
            int currentPos = this.maxUsedBatchNo.get();
            if (this.batchStoreLocationFlags.get(currentPos)) {
                dataSeqNo = this.maxUsedBatchNo.incrementAndGet();
                result = (Serializable)this.distributedCacheEntry.getAndRemove(this._cachePreKey, currentPos, this._cacheDataClassType);
            } else {
                result = (Serializable)this.localCacheQueue.poll();
                dataSeqNo = this.maxUsedBatchNo.incrementAndGet();
                Queue<CACHE_DATA> queue = this.localCacheQueue;
                synchronized (queue) {
                    this.localCacheQueue.notifyAll();
                }
            }
            if (this.dataChangeListener != null) {
                this.dataChangeListener.onDataChange(IDataChangeListener.DataChangeModeEnum.Delete, this._cachePreKey, dataSeqNo, result);
            }
        }
        return (CACHE_DATA)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.localCacheQueue.clear();
        Queue<CACHE_DATA> queue = this.localCacheQueue;
        synchronized (queue) {
            this.localCacheQueue.notifyAll();
        }
        int startSeq = this.maxUsedBatchNo.get();
        int endSeq = this.maxRegisterBatchNo.get();
        this.maxRegisterBatchNo.set(0);
        this.maxUsedBatchNo.set(0);
        this.batchStoreLocationFlags.clear();
        for (int i = startSeq; i < endSeq; ++i) {
            this.distributedCacheEntry.remove(this._cachePreKey, i);
        }
        if (this.dataChangeListener != null) {
            this.dataChangeListener.onDataChange(IDataChangeListener.DataChangeModeEnum.Clear_All, this._cachePreKey, 0, null);
        }
    }

    @Override
    public String getItemKey() {
        return this._cachePreKey;
    }

    @Override
    public void setDistributedCacheEntry(ITaskResultCacheManager distributedCacheEntry) {
        this.distributedCacheEntry = distributedCacheEntry;
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public TaskProcessDataCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public int getMaxRegisterBatchNo() {
        return this.maxRegisterBatchNo.get();
    }

    @Override
    public int getMaxUsedBatchNo() {
        return this.maxUsedBatchNo.get();
    }

    @Override
    public Class<CACHE_DATA> get_cacheDataClassType() {
        return this._cacheDataClassType;
    }

    @Override
    public String get_cachePreKey() {
        return this._cachePreKey;
    }

    public IDataChangeListener getDataChangeListener() {
        return this.dataChangeListener;
    }

    public void setDataChangeListener(IDataChangeListener dataChangeListener) {
        this.dataChangeListener = dataChangeListener;
    }

    public FahTaskGrpTypeEnum getTaskGrpType() {
        return this.taskGrpType;
    }

    public void setTaskGrpType(FahTaskGrpTypeEnum taskGrpType) {
        this.taskGrpType = taskGrpType;
    }
}

