/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.cacheservice.DataModelCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.converters.basedata.IDConverterHelper;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.ExtDataSdoHelper;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.AbValidatorChain;
import kd.fi.v2.fah.validator.MsgInfo;
import kd.fi.v2.fah.validator.ValidatorFactory;

public class ExtDataSaveCtx {
    public static final int DEFAULT_CAPACITY = 8;
    private static final String DEFAULT_ERROR_MSG_MAX_COUNT = "10";
    private Map<String, Map<Long, Ctx>> ctxMap = new HashMap<String, Map<Long, Ctx>>(8);
    private Map<String, String> modelMetaMap = new HashMap<String, String>(8);
    private Map<String, String> metaModelMap = new HashMap<String, String>(8);
    private List<String> headErrorList = new LinkedList<String>();
    private Set<Object> lockIds = new HashSet<Object>(8);
    private Set<Object> errorLockIds = new HashSet<Object>(8);
    private List<MsgInfo> allMsgInfo = new LinkedList<MsgInfo>();
    private List<MsgInfo> allMsgInfoNeedSave = new LinkedList<MsgInfo>();
    private List<ExtendedDataEntity> allSuccessExtData = new LinkedList<ExtendedDataEntity>();
    private List<ExtendedDataEntity> allFailedExtData = new LinkedList<ExtendedDataEntity>();
    private Map<String, List<SimpleDynamicObject>> allSuccessExtDatasdoMap = new HashMap<String, List<SimpleDynamicObject>>(8);
    private Map<String, List<SimpleDynamicObject>> allFailedExtDatasdoMap = new HashMap<String, List<SimpleDynamicObject>>(8);
    private ModelCfgAndValidators modelCfgAndValidators = new ModelCfgAndValidators();
    private DataModelCfgCacheService dataModelCfgCacheService = FAHDataCacheMgr.instance.getDataModelCfgCacheService();
    private Map<Object, Set<String>> hasVoucherEvts;
    private int errorMsgMaxCount = Integer.parseInt(SysParamConfig.get("fi.fah.extdata.error.msg.max.count", "10"));
    private ExtDataSdoHelper extDataSdoHelper = new ExtDataSdoHelper(this);
    private Ctx currentCtx;

    public void setHasVoucher(Map<Object, Set<String>> hasVoucherEvts) {
        this.hasVoucherEvts = hasVoucherEvts;
    }

    public Map<Object, Set<String>> getHasVoucherEvts() {
        return this.hasVoucherEvts;
    }

    public void initCtx(String modelNum, Long orgId) {
        this.currentCtx = new Ctx(modelNum, orgId);
        this.currentCtx.setParent(this);
        this.ctxMap.computeIfAbsent(modelNum, k -> new HashMap()).computeIfAbsent(orgId, k -> this.currentCtx);
        this.prepareFieldCfgAndValidatorsMap(modelNum);
    }

    private void prepareFieldCfgAndValidatorsMap(String modelNum) {
        if (this.modelCfgAndValidators.contains(modelNum)) {
            return;
        }
        DataModelCfg modelCfg = (DataModelCfg)this.dataModelCfgCacheService.loadFromCache(modelNum, new Object[0]);
        String metaEntityNum = modelCfg.getMainTableName();
        this.modelMetaMap.put(modelNum, metaEntityNum);
        this.metaModelMap.put(metaEntityNum, modelNum);
        this.modelCfgAndValidators.add(new ModelCfgAndValidator(modelCfg));
    }

    public Map<String, PairTuple<DataModelFieldCfg, AbValidatorChain>> getFieldCfgAndValidatorsMap() {
        return this.modelCfgAndValidators.getFieldCfgAndValidatorsMap(this.currentCtx.modelNum);
    }

    public Map<String, String> getFieldNumMap() {
        return this.modelCfgAndValidators.getFieldNumMap(this.currentCtx.modelNum);
    }

    public DataModelFieldCfg getFieldCfg(String fieldNum) {
        ModelCfgAndValidator modelCfgAndValidator = (ModelCfgAndValidator)this.modelCfgAndValidators.modelMap.get(this.currentCtx.modelNum);
        return (DataModelFieldCfg)modelCfgAndValidator.fieldCfgMap.get(fieldNum);
    }

    public IDConverterHelper getConverterHelper() {
        return this.currentCtx.converterHelper;
    }

    public void addRequiredConditionField(String fieldNum) {
        this.currentCtx.addRequiredConditionField(fieldNum);
    }

    public void addErrorMsg(String msg, DataModelFieldCfg fieldCfg, SimpleDynamicObject sdo, Object fieldValue) {
        Long modelId = fieldCfg.getParent().getParent().getMasterId();
        String extDataNum = ExtDataSaveCtx.getExtDataNum(sdo);
        this.addErrorLockId(modelId + extDataNum);
        this.currentCtx.addErrorMsg(msg, fieldCfg, sdo, fieldValue);
    }

    public void addHeadError(String modelIdAndDataNum) {
        this.headErrorList.add(modelIdAndDataNum);
    }

    public List<String> getHeadErrorList() {
        return this.headErrorList;
    }

    public void addErrorLockId(String modelIdAndDataNum) {
        this.errorLockIds.add(modelIdAndDataNum);
    }

    public Set<Object> getErrorLockIds() {
        return this.errorLockIds;
    }

    public void addExtData(String extDataNum, ExtendedDataEntity extData) {
        this.currentCtx.dataNumMap.put(extDataNum, extData);
    }

    public Map<String, ExtendedDataEntity> getExtDataMap() {
        return this.currentCtx.dataNumMap;
    }

    public String getCurrentModelNum() {
        return this.currentCtx.modelNum;
    }

    public ExtDataSdoHelper getExtDataSdoHelper() {
        return this.extDataSdoHelper;
    }

    public Map<String, DataModelFieldCfg> getFieldCfgMap() {
        return ((ModelCfgAndValidator)this.modelCfgAndValidators.modelMap.get(this.currentCtx.modelNum)).fieldCfgMap;
    }

    public Map<String, DataModelFieldCfg> getFieldCfgMap(String metaEntityNum) {
        return ((ModelCfgAndValidator)this.modelCfgAndValidators.modelMap.get(this.transToModelNum(metaEntityNum))).fieldCfgMap;
    }

    public String transToModelNum(String metaEntityNum) {
        return this.metaModelMap.get(metaEntityNum);
    }

    public String transToMetaNum(String modelNum) {
        return this.modelMetaMap.get(modelNum);
    }

    public void addSuccessOrFailedExtDataSdo(SimpleDynamicObject extDataSdo, boolean saveDefault) {
        String extDataNum = extDataSdo.getString("number");
        if (this.currentCtx.errorExtDataSet.contains(extDataNum)) {
            if (saveDefault) {
                ExtendedDataEntity errorData = (ExtendedDataEntity)this.currentCtx.dataNumMap.get(extDataNum);
                errorData.setValue("status", (Object)"3");
                this.allFailedExtData.add(errorData);
                extDataSdo.set("billstatus", (Object)"F");
                this.allFailedExtDatasdoMap.computeIfAbsent(this.currentCtx.modelNum, k -> new LinkedList()).add(extDataSdo);
            }
        } else {
            this.getAllSuccessExtData().add((ExtendedDataEntity)this.currentCtx.dataNumMap.get(extDataNum));
            this.allSuccessExtDatasdoMap.computeIfAbsent(this.currentCtx.modelNum, k -> new LinkedList()).add(extDataSdo);
        }
    }

    public List<MsgInfo> getAllErrorMsgInfo() {
        return this.allMsgInfo;
    }

    public ExtendedDataEntity getExtDataEntity(String modelNum, Long orgId, String extDataNum) {
        return (ExtendedDataEntity)this.ctxMap.get(modelNum).get(orgId).dataNumMap.get(extDataNum);
    }

    public Set<String> getRequiredFields() {
        return this.currentCtx.requiredCheckConditionFields;
    }

    public void setLockIds(Set<Object> lockIds) {
        this.lockIds = lockIds;
    }

    public Set<Object> getLockIds() {
        return this.lockIds;
    }

    public List<MsgInfo> getAllErrorMsgInfoNeedSave() {
        for (Map<Long, Ctx> orgGroup : this.ctxMap.values()) {
            for (Ctx ctx : orgGroup.values()) {
                for (Ctx.MsgInfoGroup msgInfoGroup : ctx.msgInfoGroupMap.values()) {
                    for (List msgInfoList : msgInfoGroup.msgInfoGroupMap.values()) {
                        for (MsgInfo msgInfo : msgInfoList) {
                            if (!msgInfo.getSaveFlag()) continue;
                            this.allMsgInfoNeedSave.add(msgInfo);
                        }
                    }
                }
            }
        }
        return this.allMsgInfoNeedSave;
    }

    public List<ExtendedDataEntity> getAllSuccessExtData() {
        return this.allSuccessExtData;
    }

    public List<ExtendedDataEntity> getAllFailedExtData() {
        return this.allFailedExtData;
    }

    public Map<String, List<SimpleDynamicObject>> getAllFailedExtDataSdoMap() {
        return this.allFailedExtDatasdoMap;
    }

    public Map<String, List<SimpleDynamicObject>> getAllSuccessExtDataSdoMap() {
        return this.allSuccessExtDatasdoMap;
    }

    public Map<String, String> getModelTables() {
        return this.modelMetaMap;
    }

    public DataModelCfg getModelCfg() {
        String modelNum = this.currentCtx.modelNum;
        return ((ModelCfgAndValidator)this.modelCfgAndValidators.modelMap.get(modelNum)).modelCfg;
    }

    private static AbValidatorChain chooseValidator(DataModelFieldCfg fieldCfg) {
        AbValidatorChain abValidatorChain = new AbValidatorChain();
        switch (fieldCfg.getDataType()) {
            case BaseProp: 
            case AssistProp: 
            case String: {
                abValidatorChain.addValidator(ValidatorFactory.getStringInstance());
                DataModelFieldPropCfg lengthCfg = (DataModelFieldPropCfg)fieldCfg.getProps().get(FieldPropEnum.MAXLENGTH.getNumber());
                abValidatorChain.addValidator(ValidatorFactory.createTextLengthValidator(Integer.parseInt(lengthCfg.getPropValue().toString())));
                break;
            }
            case Decimal: 
            case Amount: {
                abValidatorChain.addValidator(ValidatorFactory.getNumberInstance());
                DataModelFieldPropCfg precisionCfg = (DataModelFieldPropCfg)fieldCfg.getProps().get(FieldPropEnum.SCALE.getNumber());
                abValidatorChain.addValidator(ValidatorFactory.createPrecisionValidator(Integer.parseInt(precisionCfg.getPropValue().toString())));
                break;
            }
            case Int: {
                abValidatorChain.addValidator(ValidatorFactory.getIntInstance());
                break;
            }
            case Date: {
                abValidatorChain.addValidator(ValidatorFactory.getStringInstance());
                DataModelFieldPropCfg dateFormatCfg = (DataModelFieldPropCfg)fieldCfg.getProps().get(FieldPropEnum.DATEFORMAT.getNumber());
                abValidatorChain.addValidator(ValidatorFactory.createDateValidator(dateFormatCfg.getPropValue().toString()));
                break;
            }
            case Bool: {
                abValidatorChain.addValidator(ValidatorFactory.getBoolInstance());
                break;
            }
        }
        return abValidatorChain;
    }

    private static String getExtDataNum(SimpleDynamicObject sdo) {
        return sdo.getRoot().getString("number");
    }

    private static class Ctx {
        private String modelNum;
        private Long orgId;
        private Set<String> errorExtDataSet = new HashSet<String>(8);
        private Map<String, ExtendedDataEntity> dataNumMap = new HashMap<String, ExtendedDataEntity>(8);
        private IDConverterHelper converterHelper;
        private Set<String> requiredCheckConditionFields = new HashSet<String>(8);
        private Map<String, MsgInfoGroup> msgInfoGroupMap = new HashMap<String, MsgInfoGroup>(8);
        private ExtDataSaveCtx parent;

        public Ctx(String modelNum, Long orgId) {
            this.modelNum = modelNum;
            this.orgId = orgId;
            this.converterHelper = new IDConverterHelper(this.orgId);
        }

        public void setParent(ExtDataSaveCtx parent) {
            this.parent = parent;
        }

        public void addRequiredConditionField(String fieldNum) {
            this.requiredCheckConditionFields.add(fieldNum);
        }

        public void addErrorMsg(String msg, DataModelFieldCfg fieldCfg, SimpleDynamicObject sdo, Object fieldValue) {
            String extDataNum = ExtDataSaveCtx.getExtDataNum(sdo);
            this.errorExtDataSet.add(extDataNum);
            this.msgInfoGroupMap.computeIfAbsent(extDataNum, k -> new MsgInfoGroup(this)).addErrorMsg(msg, fieldCfg, sdo, fieldValue);
        }

        private static class MsgInfoGroup {
            private Ctx parent;
            private Map<String, List<MsgInfo>> msgInfoGroupMap;

            public MsgInfoGroup(Ctx parent) {
                this.parent = parent;
                this.msgInfoGroupMap = new HashMap<String, List<MsgInfo>>(8);
            }

            public void addErrorMsg(String msg, DataModelFieldCfg fieldCfg, SimpleDynamicObject sdo, Object fieldValue) {
                String groupKey = fieldCfg.getParent().getNumber();
                List msgInfoList = this.msgInfoGroupMap.computeIfAbsent(groupKey, k -> new LinkedList());
                int errorMsgCount = msgInfoList.size();
                if (errorMsgCount >= this.parent.parent.errorMsgMaxCount) {
                    return;
                }
                MsgInfo msgInfo = new MsgInfo(msg, fieldCfg, sdo, fieldValue);
                msgInfoList.add(msgInfo);
                this.parent.parent.allMsgInfo.add(msgInfo);
            }
        }
    }

    private static class ModelCfgAndValidator {
        protected String modelNumber;
        private DataModelCfg modelCfg;
        private Map<String, DataModelFieldCfg> fieldCfgMap;
        private Map<String, String> fieldNumMap;
        private Map<String, PairTuple<DataModelFieldCfg, AbValidatorChain>> fieldCfgAndValidatorsMap;

        public ModelCfgAndValidator(DataModelCfg modelCfg) {
            this.modelNumber = modelCfg.getNumber();
            this.modelCfg = modelCfg;
            this.fieldCfgMap = modelCfg.allFieldCfgMap();
            this.fieldNumMap = new HashMap<String, String>(8);
            this.fieldCfgAndValidatorsMap = new HashMap<String, PairTuple<DataModelFieldCfg, AbValidatorChain>>(this.fieldCfgMap.size());
            for (DataModelFieldCfg fieldCfg : this.fieldCfgMap.values()) {
                if (StringUtils.isEmpty((String)fieldCfg.getApifield()) || !fieldCfg.getEnable().booleanValue()) continue;
                this.fieldCfgAndValidatorsMap.put(fieldCfg.getItemKey(), (PairTuple<DataModelFieldCfg, AbValidatorChain>)new PairTuple((Object)fieldCfg, (Object)ExtDataSaveCtx.chooseValidator(fieldCfg)));
                this.fieldNumMap.put(fieldCfg.getApifield(), fieldCfg.getNumber());
            }
            for (DataModelFieldCollection fieldCollection : (BaseMutableArrayMapStorage)modelCfg.getCollections()) {
                if (fieldCollection.getGroupType() != DefaultDataFieldGroupEnum.ENTRY || fieldCollection.getGroupLevel() == 0) continue;
                String[] splits = fieldCollection.getNumber().split("\\|");
                String shortNum = splits[splits.length - 1];
                this.fieldNumMap.put(shortNum, shortNum);
            }
        }
    }

    private static class ModelCfgAndValidators {
        private Map<String, ModelCfgAndValidator> modelMap = new HashMap<String, ModelCfgAndValidator>(8);

        public void add(ModelCfgAndValidator modelCfgAndValidator) {
            this.modelMap.put(modelCfgAndValidator.modelNumber, modelCfgAndValidator);
        }

        public boolean contains(String modelNum) {
            return this.modelMap.containsKey(modelNum);
        }

        public Map<String, PairTuple<DataModelFieldCfg, AbValidatorChain>> getFieldCfgAndValidatorsMap(String modelNum) {
            ModelCfgAndValidator modelCfgAndValidator = this.modelMap.get(modelNum);
            return modelCfgAndValidator.fieldCfgAndValidatorsMap;
        }

        public Map<String, String> getFieldNumMap(String modelNum) {
            ModelCfgAndValidator modelCfgAndValidator = this.modelMap.get(modelNum);
            return modelCfgAndValidator.fieldNumMap;
        }
    }
}

