/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.converters.basedata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;

public class IDConvertNumberHelper {
    public static Map<Long, String> queryBaseDataNumberAndName(String entityNumber, Set<Long> ids, Long orgId) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData(entityNumber, orgId, "id,number,name", filter);
        HashMap<Long, String> result = new HashMap<Long, String>(ids.size());
        for (DynamicObject obj : dynamicObjects) {
            result.put(obj.getLong("id"), obj.getString("number") + "," + obj.getString("name"));
        }
        return result;
    }

    public static Map<Long, String> queryAssistantInfo(Long groupId, Set<Long> ids, Long orgId) {
        HashMap<Long, String> result = new HashMap<Long, String>(ids.size());
        QFilter groupFilter = new QFilter("group.id", "=", (Object)groupId);
        QFilter numberFilter = new QFilter("id", "in", ids);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData("bos_assistantdata_detail", orgId, "id,number,name", groupFilter, numberFilter, statusFilter);
        for (DynamicObject obj : dynamicObjects) {
            result.put(obj.getLong("id"), obj.getString("number") + "," + obj.getString("name"));
        }
        return result;
    }

    public static Map<Long, String> queryBaseDataNumbers(String entityNumber, Set<Long> ids, Long orgId) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData(entityNumber, orgId, "id,number", filter);
        HashMap<Long, String> idAndNumberMap = new HashMap<Long, String>(ids.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            idAndNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return idAndNumberMap;
    }

    public static Map<Long, String> queryAssistantIds(Long groupId, Set<Long> ids) {
        HashMap<Long, String> idAndNumberMap = new HashMap<Long, String>(ids.size());
        QFilter groupFilter = new QFilter("group.id", "=", (Object)groupId);
        QFilter numberFilter = new QFilter("id", "in", ids);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData("bos_assistantdata_detail", null, "id,number", groupFilter, numberFilter, statusFilter);
        for (DynamicObject dynamicObject : dynamicObjects) {
            idAndNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return idAndNumberMap;
    }

    public static Map<Long, String> getAsstDimTypeByEntryId(Long assistantId, Set<Long> ids, Long orgId) {
        String sql = "valuetype,valuesource.number,assistanttype.id";
        DynamicObject dynamic = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)sql, (QFilter[])new QFilter("id", "=", (Object)assistantId).toArray());
        if (null != dynamic) {
            String valueType = dynamic.getString("valuetype");
            if ("1".equals(valueType)) {
                String type = dynamic.getString("valuesource.number");
                return IDConvertNumberHelper.queryBaseDataNumbers(type, ids, orgId);
            }
            if ("2".equals(valueType)) {
                Long assistantTypeId = dynamic.getLong("assistanttype.id");
                return IDConvertNumberHelper.queryAssistantIds(assistantTypeId, ids);
            }
        }
        return Collections.emptyMap();
    }
}

