/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.converters.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;
import kd.fi.v2.fah.converters.common.Converter;

public class ObjectConverterFactory {
    public static Converter<?> getConverter(Class<?> clazzType) {
        return clazzType == null ? CommonDataTypeEnums.ObjectType.getConverter() : ObjectConverterFactory.parseClassDataType(clazzType.getName()).getConverter();
    }

    public static CommonDataTypeEnums parseClassDataType(String className) {
        switch (className) {
            case "java.lang.Byte": {
                return CommonDataTypeEnums.Byte;
            }
            case "short": 
            case "java.lang.Short": {
                return CommonDataTypeEnums.Short;
            }
            case "int": 
            case "java.lang.Integer": {
                return CommonDataTypeEnums.Integer;
            }
            case "long": 
            case "java.lang.Long": {
                return CommonDataTypeEnums.Long;
            }
            case "double": 
            case "java.lang.Double": {
                return CommonDataTypeEnums.Double;
            }
            case "float": 
            case "java.lang.Float": {
                return CommonDataTypeEnums.Float;
            }
            case "java.math.BigInteger": {
                return CommonDataTypeEnums.BigInteger;
            }
            case "java.math.BigDecimal": {
                return CommonDataTypeEnums.BigDecimal;
            }
            case "java.lang.Character": {
                return CommonDataTypeEnums.Character;
            }
            case "java.lang.String": {
                return CommonDataTypeEnums.String;
            }
            case "java.lang.Boolean": {
                return CommonDataTypeEnums.Boolean;
            }
            case "java.sql.Date": 
            case "java.util.Date": {
                return CommonDataTypeEnums.Date;
            }
            case "java.sql.Timestamp": {
                return CommonDataTypeEnums.Timestamp;
            }
        }
        return CommonDataTypeEnums.ObjectType;
    }

    public static <T> T convert(Object source, Class<T> clazz, T defaultValue) {
        if (source == null || clazz == Void.TYPE) {
            return defaultValue;
        }
        if (clazz == null || clazz == Object.class || source != null && clazz.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        if (clazz.isEnum()) {
            if (source instanceof Enum) {
                return (T)source;
            }
            String targetName = String.valueOf(source);
            for (T v : clazz.getEnumConstants()) {
                if (!((Enum)v).name().equals(targetName)) continue;
                return v;
            }
            return null;
        }
        return (T)ObjectConverterFactory.getConverter(clazz).convert(source, defaultValue);
    }

    public static <T> T convert(Object source, Class<T> clazz) {
        return ObjectConverterFactory.convert(source, clazz, null);
    }

    private static <T> T parseFromString(Object source, Function<String, T> parseFunc, T defaultValue) {
        String src = !(source instanceof String) ? source.toString() : (String)source;
        if (!"".equals(src = src.trim()) && !"null".equalsIgnoreCase(src)) {
            try {
                return parseFunc.apply(src);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Boolean getBoolean(Object source, Boolean defaultValue) {
        return ObjectConverterFactory.convert(source, Boolean.class, defaultValue);
    }

    public static Boolean getBoolean(Object source) {
        return ObjectConverterFactory.convert(source, Boolean.class, null);
    }

    public static Date getDate(Object source, Date defaultValue) {
        return ObjectConverterFactory.convert(source, Date.class, defaultValue);
    }

    public static Date getDate(Object source) {
        return ObjectConverterFactory.convert(source, Date.class, null);
    }

    public static String getString(Object source, String defaultValue) {
        return ObjectConverterFactory.convert(source, String.class, defaultValue);
    }

    public static String getString(Object source) {
        return ObjectConverterFactory.convert(source, String.class, null);
    }

    public static Character getCharacter(Object source, Character defaultValue) {
        return ObjectConverterFactory.convert(source, Character.class, defaultValue);
    }

    public static Character getCharacter(Object source) {
        return ObjectConverterFactory.convert(source, Character.class, null);
    }

    public static BigInteger getBigInteger(Object source, BigInteger defaultValue) {
        return ObjectConverterFactory.convert(source, BigInteger.class, defaultValue);
    }

    public static BigInteger getBigInteger(Object source) {
        return ObjectConverterFactory.convert(source, BigInteger.class, null);
    }

    public static BigDecimal getBigDecimal(Object source, BigDecimal defaultValue) {
        return ObjectConverterFactory.convert(source, BigDecimal.class, defaultValue);
    }

    public static BigDecimal getBigDecimal(Object source) {
        return ObjectConverterFactory.convert(source, BigDecimal.class, null);
    }

    public static Long getLong(Object source, Long defaultValue) {
        return ObjectConverterFactory.convert(source, Long.class, defaultValue);
    }

    public static Long getLong(Object source) {
        return ObjectConverterFactory.convert(source, Long.class, null);
    }

    public static Integer getInteger(Object source, Integer defaultValue) {
        return ObjectConverterFactory.convert(source, Integer.class, defaultValue);
    }

    public static Integer getInteger(Object source) {
        return ObjectConverterFactory.convert(source, Integer.class, null);
    }

    public static Short getShort(Object source, Short defaultValue) {
        return ObjectConverterFactory.convert(source, Short.class, defaultValue);
    }

    public static Short getShort(Object source) {
        return ObjectConverterFactory.convert(source, Short.class, null);
    }

    public static Byte getByte(Object source, Byte defaultValue) {
        return ObjectConverterFactory.convert(source, Byte.class, defaultValue);
    }

    public static Byte getByte(Object source) {
        return ObjectConverterFactory.convert(source, Byte.class, null);
    }

    public static Double getDouble(Object source, Double defaultValue) {
        return ObjectConverterFactory.convert(source, Double.class, defaultValue);
    }

    public static Double getDouble(Object source) {
        return ObjectConverterFactory.convert(source, Double.class, null);
    }

    public static Float getFloat(Object source, Float defaultValue) {
        return ObjectConverterFactory.convert(source, Float.class, defaultValue);
    }

    public static Float getFloat(Object source) {
        return ObjectConverterFactory.convert(source, Float.class, null);
    }

    public static class DateConverter
    implements Converter<Date> {
        private static final SimpleDateFormat Short_Year = new SimpleDateFormat("yyyy");
        private static final SimpleDateFormat Year_Month = new SimpleDateFormat("yyyy.MM");
        private static final SimpleDateFormat Month_Year = new SimpleDateFormat("MM.yyyy");
        private static final SimpleDateFormat Full_Date = new SimpleDateFormat("yyyy.MM.dd");
        private static final SimpleDateFormat Euro_Full_Date = new SimpleDateFormat("MM.dd.yyyy");
        private static final SimpleDateFormat Full_Date_Time = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        private static final SimpleDateFormat Euro_Full_Date_Time = new SimpleDateFormat("MM.dd.yyyy HH:mm:ss");

        protected DateConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Date convert(Object source, Date defaultValue) {
            SimpleDateFormat formatter;
            if (source == null) {
                return defaultValue;
            }
            String buf = String.valueOf(source.toString()).trim().replace("-", ".").replace("$", ".").replace("_", ".").replace("/", ".").replace("\\", ".");
            int length = buf.length();
            if (length == 4) {
                formatter = Short_Year;
            } else {
                boolean yearFirstFormat = buf.charAt(2) != '.';
                boolean hasTime = buf.charAt(buf.length() - 3) != ':';
                switch (length) {
                    case 7: {
                        formatter = yearFirstFormat ? Year_Month : Month_Year;
                        break;
                    }
                    case 10: {
                        formatter = yearFirstFormat ? Full_Date : Euro_Full_Date;
                        break;
                    }
                    case 19: {
                        formatter = yearFirstFormat ? Full_Date_Time : Euro_Full_Date_Time;
                        break;
                    }
                    default: {
                        try {
                            return new Date(Long.parseLong(buf));
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException("Not Support Date Format:" + buf, ex);
                        }
                    }
                }
            }
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                try {
                    return formatter.parse(buf);
                }
                catch (ParseException e) {
                    return defaultValue;
                }
            }
        }
    }

    public static class BigDecimalConverter
    implements Converter<BigDecimal> {
        @Override
        public BigDecimal convert(Object source, BigDecimal defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            CommonDataTypeEnums dataType = ObjectConverterFactory.parseClassDataType(source.getClass().getName());
            switch (dataType) {
                case Byte: {
                    return new BigDecimal(((Byte)source).byteValue());
                }
                case Short: {
                    return new BigDecimal(((Short)source).shortValue());
                }
                case Integer: {
                    return new BigDecimal((Integer)source);
                }
                case Long: {
                    return new BigDecimal((Long)source);
                }
                case Double: {
                    return BigDecimal.valueOf((Double)source);
                }
                case Float: {
                    return BigDecimal.valueOf(((Float)source).floatValue());
                }
                case BigInteger: {
                    return new BigDecimal((BigInteger)source);
                }
                case BigDecimal: {
                    return (BigDecimal)source;
                }
                case Character: {
                    return new BigDecimal(((Character)source).charValue());
                }
                case Boolean: {
                    return (Boolean)source != false ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                case String: 
                case ObjectType: {
                    return (BigDecimal)ObjectConverterFactory.parseFromString(source, src -> new BigDecimal((String)src), defaultValue);
                }
            }
            throw new IllegalStateException("Unsupported Data Type: " + (Object)((Object)dataType) + ", Value=" + source);
        }
    }

    public static class BigIntegerConverter
    implements Converter<BigInteger> {
        @Override
        public BigInteger convert(Object source, BigInteger defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            CommonDataTypeEnums dataType = ObjectConverterFactory.parseClassDataType(source.getClass().getName());
            switch (dataType) {
                case Byte: 
                case Short: 
                case Integer: 
                case Long: 
                case Double: 
                case Float: {
                    return BigInteger.valueOf(((Number)source).longValue());
                }
                case BigInteger: {
                    return (BigInteger)source;
                }
                case BigDecimal: {
                    return ((BigDecimal)source).toBigInteger();
                }
                case Boolean: {
                    return (Boolean)source != false ? BigInteger.ONE : BigInteger.ZERO;
                }
                case Character: 
                case String: 
                case ObjectType: {
                    return (BigInteger)ObjectConverterFactory.parseFromString(source, src -> new BigInteger((String)src), defaultValue);
                }
            }
            throw new IllegalStateException("Unsupported Data Type: " + (Object)((Object)dataType) + ", Value=" + source);
        }
    }

    public static class ByteConverter
    implements Converter<Byte> {
        @Override
        public Byte convert(Object source, Byte defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return ((Number)source).byteValue();
            }
            return (Byte)ObjectConverterFactory.parseFromString(source, src -> Byte.parseByte(src), defaultValue);
        }
    }

    public static class CharConverter
    implements Converter<Character> {
        @Override
        public Character convert(Object source, Character defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Character) {
                return (Character)source;
            }
            try {
                return Character.valueOf(String.valueOf(source).charAt(0));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
    }

    public static class BooleanConverter
    implements Converter<Boolean> {
        @Override
        public Boolean convert(Object source, Boolean defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Boolean) {
                return (Boolean)source;
            }
            switch (String.valueOf(source).trim().toLowerCase(Locale.ENGLISH)) {
                case "ok": 
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": {
                    return Boolean.TRUE;
                }
            }
            return false;
        }
    }

    public static class ShortConverter
    implements Converter<Short> {
        @Override
        public Short convert(Object source, Short defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return ((Number)source).shortValue();
            }
            return (Short)ObjectConverterFactory.parseFromString(source, src -> Short.parseShort(src), defaultValue);
        }
    }

    public static class DoubleConverter
    implements Converter<Double> {
        @Override
        public Double convert(Object source, Double defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return ((Number)source).doubleValue();
            }
            return (Double)ObjectConverterFactory.parseFromString(source, src -> Double.parseDouble(src), defaultValue);
        }
    }

    public static class FloatConverter
    implements Converter<Float> {
        @Override
        public Float convert(Object source, Float defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return Float.valueOf(((Number)source).floatValue());
            }
            return (Float)ObjectConverterFactory.parseFromString(source, src -> Float.valueOf(Float.parseFloat(src)), defaultValue);
        }
    }

    public static class IntegerConverter
    implements Converter<Integer> {
        @Override
        public Integer convert(Object source, Integer defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return ((Number)source).intValue();
            }
            return (Integer)ObjectConverterFactory.parseFromString(source, src -> Integer.parseInt(src), defaultValue);
        }
    }

    public static class LongConverter
    implements Converter<Long> {
        @Override
        public Long convert(Object source, Long defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source instanceof Number) {
                return ((Number)source).longValue();
            }
            return (Long)ObjectConverterFactory.parseFromString(source, src -> Long.parseLong(src), defaultValue);
        }
    }

    public static class StringConverter
    implements Converter<String> {
        @Override
        public String convert(Object source, String defaultValue) {
            return source == null ? defaultValue : String.valueOf(source);
        }

        @Override
        public boolean test(Object source) {
            return source != null;
        }
    }

    public static enum CommonDataTypeEnums {
        Byte(0, Byte.class, new ByteConverter()),
        Short(1, Short.class, new ShortConverter()),
        Integer(2, Integer.class, new IntegerConverter()),
        Long(3, Long.class, new LongConverter()),
        Double(4, Double.class, new DoubleConverter()),
        Float(5, Float.class, new FloatConverter()),
        BigInteger(6, BigInteger.class, new BigIntegerConverter()),
        BigDecimal(7, BigDecimal.class, new BigDecimalConverter()),
        Character(8, Character.class, new CharConverter()),
        String(9, String.class, new StringConverter()),
        Boolean(10, Boolean.class, new BooleanConverter()),
        Date(11, Date.class, new DateConverter()),
        Timestamp(12, Timestamp.class, new DateConverter()),
        ObjectType(99, Object.class, (source, defaultValue) -> source);

        int code;
        Class<?> clazzType;
        Converter<?> converter;

        private CommonDataTypeEnums(int code, Class<?> clazzType, Converter<?> converter) {
            this.code = code;
            this.clazzType = clazzType;
            this.converter = converter;
        }

        public int getCode() {
            return this.code;
        }

        public Converter<?> getConverter() {
            return this.converter;
        }

        public Class getClassType() {
            return this.clazzType;
        }

        public Object getResultSetValue(ResultSet resultSet, int colIndex) throws SQLException {
            switch (this) {
                case Byte: {
                    return resultSet.getByte(colIndex);
                }
                case Short: {
                    return resultSet.getShort(colIndex);
                }
                case Integer: {
                    return resultSet.getInt(colIndex);
                }
                case Long: {
                    return resultSet.getLong(colIndex);
                }
                case Character: 
                case String: {
                    return resultSet.getString(colIndex);
                }
                case Timestamp: {
                    return resultSet.getTimestamp(colIndex);
                }
                case Date: {
                    return resultSet.getDate(colIndex);
                }
                case Boolean: {
                    return resultSet.getBoolean(colIndex);
                }
                case BigInteger: 
                case BigDecimal: {
                    return resultSet.getBigDecimal(colIndex);
                }
            }
            return resultSet.getObject(colIndex);
        }
    }
}

