/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.biz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class ExtDataQueryHelper {
    public static Map<String, List<Long>> groupByBillType(Collection<Long> ids) {
        HashMap<String, List<Long>> billTypeGroup = new HashMap<String, List<Long>>(8);
        DynamicObjectCollection events = QueryServiceHelper.query((String)"ai_event", (String)"id, eventclass.number eventclassnum, eventclass.appversion appversion", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject event : events) {
            long id = event.getLong("id");
            String appVersion = event.getString("appversion");
            String billType = DataModelDaoImpl.getMetaEntityNumber(event.getString("eventclassnum"));
            if (!String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(appVersion)) {
                billType = "ai_event";
            }
            billTypeGroup.computeIfAbsent(billType, k -> new ArrayList(8)).add(id);
        }
        return billTypeGroup;
    }

    public static Set<Long> getRepeatEventDataIds(Set<Object> currentEventIds, Map<Object, Set<String>> evtMap) {
        HashSet<Long> eventIds = new HashSet<Long>(8);
        for (Map.Entry<Object, Set<String>> entry : evtMap.entrySet()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
            QFilter statusFilter = new QFilter("status", "!=", (Object)"2");
            QFilter modelFilter = new QFilter("eventclass.masterid", "=", entry.getKey());
            QFilter numFilter = new QFilter("number", "in", entry.getValue());
            qFilters.add(statusFilter);
            qFilters.add(modelFilter);
            qFilters.add(numFilter);
            List eventSubIds = QueryServiceHelper.queryPrimaryKeys((String)"ai_event", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
            if (CollectionUtils.isEmpty((Collection)eventSubIds)) continue;
            eventIds.addAll(eventSubIds.stream().map(e -> (Long)e).collect(Collectors.toSet()));
        }
        eventIds.removeAll(currentEventIds);
        return eventIds;
    }
}

