/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.biz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.dao.biz.ExtDataQueryHelper;
import kd.fi.v2.fah.dao.biz.SDOSaveHelper;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.validator.MsgInfo;

public class ExtDataSaveHelper {
    private static final String SAVE_ERROR_SQL = "insert into t_fah_ext_data_err (fid, fdataid, fseq, ffieldid, fvalue, fmsg, fcreatetime, fstatus) values (?,?,?,?,?,?,?,?)";
    private static final String UPDATE_SQL = "update %1$s set fbillstatus = ? where fnumber = ? and fbillstatus != ? ";
    private static final String UPDATE_EVENT_EXPIRED_SQL = "update t_ai_event set fstatus = '2' where fstatus != '2' and ";

    public static void saveExtData(SimpleDynamicObject sdo) {
        SDOSaveHelper.save(sdo);
    }

    public static void saveFalseData(List<ExtendedDataEntity> falseDataEntities) {
        if (CollectionUtils.isEmpty(falseDataEntities)) {
            return;
        }
        Object[] datas = (DynamicObject[])falseDataEntities.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        DynamicObjectType dynamicObjectType = datas[0].getDynamicObjectType();
        BusinessDataWriter.save((IDataEntityType)dynamicObjectType, (Object[])datas);
    }

    public static void saveErrorMsg(List<MsgInfo> msgInfoList) {
        if (CollectionUtils.isEmpty(msgInfoList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(msgInfoList.size());
        Long[] ids = SDOSaveHelper.getIds("t_fah_ext_data_err", "fi", msgInfoList.size());
        int i = 0;
        Date date = new Date();
        for (MsgInfo msgInfo : msgInfoList) {
            Object[] params = new Object[]{ids[i], msgInfo.getDataId(), i++, msgInfo.getFieldId(), msgInfo.getOriValue(), msgInfo.getMsg(), date, "0"};
            paramsList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)SAVE_ERROR_SQL, paramsList);
    }

    public static void saveExtDataBatch(List<SimpleDynamicObject> sdoList) {
        if (CollectionUtils.isEmpty(sdoList)) {
            return;
        }
        SDOSaveHelper.saveBatch(sdoList.get(0).getDynamicObjectType(), sdoList);
    }

    public static void updateToExpired(String tableName, List<String> extDataNumList) {
        if (CollectionUtils.isEmpty(extDataNumList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(extDataNumList.size());
        for (String extDataNum : extDataNumList) {
            Object[] params = new Object[]{"E", extDataNum, "E"};
            paramsList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)String.format(UPDATE_SQL, tableName), paramsList);
    }

    public static void updateToExpired(Set<Long> repeatEventDataIds) {
        if (CollectionUtils.isEmpty(repeatEventDataIds)) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(UPDATE_EVENT_EXPIRED_SQL, new Object[0]).appendIn("fid", new ArrayList<Long>(repeatEventDataIds));
        DB.execute((DBRoute)new DBRoute("fi"), (SqlBuilder)sql);
    }

    public static void updateRepeatEventData(DynamicObject[] entities) {
        HashMap<Object, Set<String>> evtMap = new HashMap<Object, Set<String>>();
        HashSet<Object> ids = new HashSet<Object>(entities.length);
        for (DynamicObject entity : entities) {
            Long modelMasterId = entity.getDynamicObject("eventclass").getLong("masterid");
            ids.add(entity.get("id"));
            entity.set("createtime", (Object)new Date());
            evtMap.computeIfAbsent(modelMasterId, key -> new HashSet(8)).add(entity.getString("number"));
        }
        Set<Long> repeatEventDataIds = ExtDataQueryHelper.getRepeatEventDataIds(ids, evtMap);
        ExtDataSaveHelper.updateToExpired(repeatEventDataIds);
    }

    public static void updateToActive(Set<Object> successIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_ai_event set fstatus = '1'", new Object[0]);
        sql.append(" ,fmodifytime = ?", new Object[]{new Date()});
        sql.appendIn(" where fid", successIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static void checkRepeatDataAndUpdateToExpired(Map<String, List<SimpleDynamicObject>> allSuccessExtDataSdoMap, Map<String, String> modelTables) {
        for (Map.Entry<String, List<SimpleDynamicObject>> modelAndData : allSuccessExtDataSdoMap.entrySet()) {
            String modelNum = modelAndData.getKey();
            List<SimpleDynamicObject> extDataList = modelAndData.getValue();
            List<String> extDataNumList = extDataList.stream().map(e -> e.getString("number")).collect(Collectors.toList());
            ExtDataSaveHelper.updateToExpired(modelTables.get(modelNum), extDataNumList);
        }
    }

    public static void updateErrorDataToExpired(Set<Object> ids) {
        if (!ids.isEmpty()) {
            SqlBuilder sql = new SqlBuilder();
            sql.appendIn("update t_fah_ext_data_err set fstatus = '9' where fdataid", ids.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        }
    }

    public static void appendEntries(SimpleDynamicObject sdo) {
        if (null == sdo) {
            return;
        }
        boolean appendEntries = true;
        SDOSaveHelper.save(sdo, appendEntries);
    }

    public static void deleteBlock(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        SqlBuilder deleteSql = new SqlBuilder();
        deleteSql.append("delete from t_ai_eventblock", new Object[0]);
        deleteSql.appendIn("where fid", ids.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql);
    }

    public static void deleteUnfinishedEntryData(Collection<Long> ids, String modelNum, boolean isNewExtDataModel) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LinkedList<Long> unFinishedIds = new LinkedList<Long>();
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append("select fid from t_ai_event ", new Object[0]);
        selectSql.appendIn(" where fpaging = 'F' and fid ", ids.toArray());
        try (DataSet dataset = DB.queryDataSet((String)"deleteUnfinishedEntryData", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)selectSql);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                unFinishedIds.add(row.getLong("fid"));
            }
        }
        if (CollectionUtils.isEmpty(unFinishedIds)) {
            return;
        }
        SqlBuilder deleteSql = new SqlBuilder();
        deleteSql.append("delete from t_ai_event_en ", new Object[0]);
        deleteSql.appendIn(" where feventid", unFinishedIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql);
        if (!isNewExtDataModel) {
            return;
        }
        DataModelCfg dataModelCfg = (DataModelCfg)FAHDataCacheMgr.instance.getDataModelCfgCacheService().loadFromCache(modelNum, new Object[0]);
        LinkedList<EntryTable> entryTables = new LinkedList<EntryTable>();
        for (DataModelFieldCollection fieldCollection : (BaseMutableArrayMapStorage)dataModelCfg.getCollections()) {
            if (fieldCollection.getGroupType() != DefaultDataFieldGroupEnum.ENTRY || fieldCollection.getGroupLevel() <= 0) continue;
            EntryTable entryTable = new EntryTable();
            entryTable.entryLevel = fieldCollection.getGroupLevel();
            entryTable.entryTableName = fieldCollection.getTableName();
            DataModelFieldCollection parentGroup = fieldCollection.getParentGroup();
            if (parentGroup != null && parentGroup.getGroupLevel() > 0 && parentGroup.getGroupType() == DefaultDataFieldGroupEnum.ENTRY) {
                entryTable.parentEntryTableName = parentGroup.getTableName();
            }
            entryTables.add(entryTable);
        }
        entryTables.sort(Comparator.comparing(EntryTable::getEntryLevel).reversed());
        for (EntryTable entryTable : entryTables) {
            entryTable.deleteRows(unFinishedIds);
        }
        SqlBuilder deleteSql2 = new SqlBuilder();
        deleteSql2.append("delete from t_fah_ext_data_err ", new Object[0]);
        deleteSql2.appendIn(" where fdataid", unFinishedIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql2);
    }

    private static class EntryTable {
        private String entryTableName;
        private String parentEntryTableName;
        private Integer entryLevel;

        private EntryTable() {
        }

        public Integer getEntryLevel() {
            return this.entryLevel;
        }

        public void deleteRows(List<Long> unFinishedIds) {
            if (this.parentEntryTableName == null) {
                SqlBuilder deleteSql = new SqlBuilder();
                deleteSql.append("delete from ", new Object[0]).append(this.entryTableName, new Object[0]);
                deleteSql.appendIn(" where fid", unFinishedIds.toArray());
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql);
            } else {
                SqlBuilder deleteSql = new SqlBuilder();
                deleteSql.append("delete from ", new Object[0]).append(this.entryTableName, new Object[0]);
                deleteSql.append(" where fentryid in (", new Object[0]);
                deleteSql.append("select fentryid from ", new Object[0]).append(this.parentEntryTableName, new Object[0]);
                deleteSql.appendIn("where fid", unFinishedIds.toArray());
                deleteSql.append(")", new Object[0]);
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql);
            }
        }
    }
}

