/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.biz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.models.dynamic.SdoDBInsertParams;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicCollectionProperty;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObjectType;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicProperty;
import kd.fi.v2.fah.models.dynamic.SimpleEntityPropertyCollection;
import kd.fi.v2.fah.utils.StringUtils;

public class SDOSaveHelper {
    public static void save(SimpleDynamicObject sdo) {
        SDOSaveHelper.save(sdo, false);
    }

    public static void save(SimpleDynamicObject sdo, boolean appendEntries) {
        if (null == sdo) {
            return;
        }
        SDOSaveHelper.setPks(sdo);
        Map<String, SdoDBInsertParams> sdoDBInsertParamsMap = SDOSaveHelper.transInsertParams(sdo);
        ArrayList<SdoDBInsertParams> dbInsertParamsList = new ArrayList<SdoDBInsertParams>(sdoDBInsertParamsMap.values());
        dbInsertParamsList.sort(Comparator.comparing(SdoDBInsertParams::getLevel));
        for (SdoDBInsertParams sdoDBInsertParams : dbInsertParamsList) {
            if (appendEntries && sdoDBInsertParams.getRoot().booleanValue()) continue;
            String dbRoute = sdoDBInsertParams.getDbRoute();
            String sql = sdoDBInsertParams.getSql();
            List<Object[]> paramsList = sdoDBInsertParams.getParamsList();
            SDOSaveHelper.executeBatch(dbRoute, sql, paramsList);
        }
    }

    private static void executeBatch(String dbRoute, String sql, List<Object[]> paramsList) {
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DB.executeBatch((DBRoute)new DBRoute(dbRoute), (String)sql, paramsList);
    }

    public static void saveBatch(SimpleDynamicObjectType dt, List<SimpleDynamicObject> sdoList) {
        SDOSaveHelper.setPks(dt, sdoList.toArray(new SimpleDynamicObject[0]));
        Map<String, SdoDBInsertParams> sdoDBInsertParamsMap = SDOSaveHelper.transInsertParams(dt, sdoList);
        ArrayList<SdoDBInsertParams> dbInsertParamsList = new ArrayList<SdoDBInsertParams>(sdoDBInsertParamsMap.values());
        dbInsertParamsList.sort(Comparator.comparing(SdoDBInsertParams::getLevel).thenComparing(SdoDBInsertParams::getTableName));
        for (SdoDBInsertParams sdoDBInsertParams : dbInsertParamsList) {
            String dbRoute = sdoDBInsertParams.getDbRoute();
            String sql = sdoDBInsertParams.getSql();
            List<Object[]> paramsList = sdoDBInsertParams.getParamsList();
            if (CollectionUtils.isEmpty(paramsList)) continue;
            SDOSaveHelper.executeBatch(dbRoute, sql, paramsList);
        }
    }

    private static void setPks(SimpleDynamicObject sdo) {
        if (null == sdo) {
            return;
        }
        SDOSaveHelper.setPks(sdo.getDynamicObjectType(), sdo);
    }

    private static void setPks(SimpleDynamicObjectType dt, SimpleDynamicObject ... sdos) {
        if (null == sdos) {
            return;
        }
        if (StringUtils.isEmpty((String)dt.getTableName())) {
            return;
        }
        Long[] ids = SDOSaveHelper.getIds(dt.getTableName(), dt.getDbRouteKey(), sdos.length);
        int i = 0;
        for (SimpleDynamicObject sdo : sdos) {
            SimpleDynamicProperty pk = dt.getPK();
            if (null == pk.getValueFast(sdo)) {
                pk.setValueFast(sdo, ids[i++]);
            }
            SimpleEntityPropertyCollection props = dt.getProps();
            List<SimpleDynamicCollectionProperty> collectionPropertyList = props.getCollectionProperties();
            for (SimpleDynamicCollectionProperty collectionProperty : collectionPropertyList) {
                SimpleDynamicObject[] entries = sdo.getEntries(collectionProperty);
                SDOSaveHelper.setPks(collectionProperty.getCollectionItemPropertyType(), entries);
            }
        }
    }

    public static Long[] getIds(String tableName, String routeKey, int count) {
        SequenceReader sReader = new SequenceReader(new DBRoute(routeKey));
        return (Long[])sReader.getSequences((Object[])new Long[count], tableName, count);
    }

    private static Map<String, SdoDBInsertParams> transInsertParams(SimpleDynamicObject sdo) {
        return SDOSaveHelper.transInsertParams(sdo.getDynamicObjectType(), Collections.singletonList(sdo));
    }

    private static Map<String, SdoDBInsertParams> transInsertParams(SimpleDynamicObjectType dt, List<SimpleDynamicObject> sdoList) {
        TreeMap<String, SdoDBInsertParams> sdoDBInsertParamsMap = new TreeMap<String, SdoDBInsertParams>();
        SDOSaveHelper.addInsertParamsMap(sdoDBInsertParamsMap, dt, sdoList);
        return sdoDBInsertParamsMap;
    }

    private static void addInsertParamsMap(Map<String, SdoDBInsertParams> sdoDBInsertParamsMap, SimpleDynamicObjectType dynamicObjectType, List<SimpleDynamicObject> simpleDynamicObjectList) {
        String tableName = dynamicObjectType.getTableName();
        String dbRouteKey = dynamicObjectType.getDBRouteKey();
        SdoDBInsertParams sdoDBInsertParams = sdoDBInsertParamsMap.computeIfAbsent(tableName, k -> new SdoDBInsertParams());
        sdoDBInsertParams.setDbRoute(dbRouteKey);
        sdoDBInsertParams.setTableName(tableName);
        sdoDBInsertParams.setParentDT(dynamicObjectType.getParent());
        sdoDBInsertParams.setColnums(dynamicObjectType.getProps().getSimpleProperties().stream().filter(p -> !p.isDbIgnore()).collect(Collectors.toList()));
        SDOSaveHelper.getParamsList(sdoDBInsertParams, simpleDynamicObjectList);
        List<SimpleDynamicCollectionProperty> collectionProperties = dynamicObjectType.getProps().getCollectionProperties();
        if (null == collectionProperties || collectionProperties.isEmpty()) {
            return;
        }
        for (SimpleDynamicCollectionProperty collectionProperty : collectionProperties) {
            SimpleDynamicObjectType entryType = collectionProperty.getCollectionItemPropertyType();
            if (StringUtils.isEmpty((String)entryType.getTableName())) continue;
            SdoDBInsertParams entrySdoDBInsertParams = sdoDBInsertParamsMap.computeIfAbsent(entryType.getTableName(), k -> new SdoDBInsertParams());
            entrySdoDBInsertParams.setDbRoute(dbRouteKey);
            entrySdoDBInsertParams.setTableName(entryType.getTableName());
            entrySdoDBInsertParams.setParentDT(entryType.getParent());
            entrySdoDBInsertParams.setColnums(entryType.getProps().getSimpleProperties().stream().filter(p -> !p.isDbIgnore()).collect(Collectors.toList()));
            List<SimpleDynamicObject> allEntries = SDOSaveHelper.getAllEntries(collectionProperty, simpleDynamicObjectList);
            SDOSaveHelper.addInsertParamsMap(sdoDBInsertParamsMap, entryType, allEntries);
        }
    }

    private static List<SimpleDynamicObject> getAllEntries(SimpleDynamicCollectionProperty collectionProperty, List<SimpleDynamicObject> parentList) {
        if (CollectionUtils.isEmpty(parentList)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleDynamicObject> allEntries = new ArrayList<SimpleDynamicObject>(16);
        for (SimpleDynamicObject parent : parentList) {
            SimpleDynamicObject[] entries = parent.getEntries(collectionProperty);
            allEntries.addAll(Arrays.asList(entries));
        }
        return allEntries;
    }

    private static void getParamsList(SdoDBInsertParams sdoDBInsertParams, List<SimpleDynamicObject> simpleDynamicObjects) {
        int dataIndex;
        List<SimpleDynamicProperty> colnums = sdoDBInsertParams.getColnums();
        int colnumSize = sdoDBInsertParams.getRoot() != false ? colnums.size() : colnums.size() + 1;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(simpleDynamicObjects.size());
        for (dataIndex = 0; dataIndex < simpleDynamicObjects.size(); ++dataIndex) {
            paramsList.add(new Object[colnumSize]);
        }
        for (int colnumIndex = 0; colnumIndex < colnums.size(); ++colnumIndex) {
            SimpleDynamicProperty prop = colnums.get(colnumIndex);
            for (int dataIndex2 = 0; dataIndex2 < simpleDynamicObjects.size(); ++dataIndex2) {
                Object value = prop.getValueFast(simpleDynamicObjects.get(dataIndex2));
                ((Object[])paramsList.get((int)dataIndex2))[colnumIndex] = SDOSaveHelper.getDBDefaultValue(value, prop.getPropertyType(), prop.getDefaultValue());
            }
        }
        if (!sdoDBInsertParams.getRoot().booleanValue()) {
            for (dataIndex = 0; dataIndex < simpleDynamicObjects.size(); ++dataIndex) {
                ((Object[])paramsList.get((int)dataIndex))[colnumSize - 1] = simpleDynamicObjects.get(dataIndex).getParent().getPkValue();
            }
        }
        sdoDBInsertParams.getParamsList().addAll(paramsList);
    }

    private static Object getDBDefaultValue(Object value, Class<?> propertyType, Object defaultValue) {
        if (null != value) {
            return value;
        }
        if (String.class.equals(propertyType) || ILocaleString.class.equals(propertyType)) {
            return " ";
        }
        if (propertyType == Boolean.TYPE || propertyType.isPrimitive() && propertyType == Boolean.TYPE) {
            return false;
        }
        return defaultValue;
    }
}

