/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.ai.util.ContextUtil;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;

public class FahEventRuleCfgDAO {
    private static final String algoKey = "kd.fi.v2.fah.dao.event.FahEventRuleDao";

    public static DynamicObject loadEventRuleDyn(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"fah_evt_gen_rule");
    }

    public static boolean isExistsSameDynExtFldCfg(Long id, Object sourcepage, String number) {
        QFBuilder qb = new QFBuilder("sourcepage", "=", sourcepage);
        qb.add("number", "=", (Object)number);
        if (id != null && id != 0L) {
            qb.add("id", "!=", (Object)id);
        }
        return QueryServiceHelper.exists((String)"fah_dyn_extfld", (QFilter[])qb.toArray());
    }

    public static void deleteDynExtFldCfg(String sourcepage, String number) {
        QFBuilder qb = new QFBuilder("sourcepage", "=", (Object)sourcepage);
        qb.add("number", "=", (Object)number);
        DeleteServiceHelper.delete((String)"fah_dyn_extfld", (QFilter[])qb.toArray());
    }

    public static DynamicObject queryDynExtFieldCfg(String sourcePage, String number) {
        QFilter sourcePageF = new QFilter("sourcepage", "=", (Object)sourcePage);
        QFilter numberF = new QFilter("number", "=", (Object)number);
        QFilter enableF = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)"fah_dyn_extfld", (QFilter[])new QFilter[]{sourcePageF, numberF, enableF});
    }

    public static String checkReferenceFieldIsReferenced(Set<String> ids) {
        QFilter filter = new QFilter("getvaluetype", "=", (Object)String.valueOf(ExtractTypeEnum.REFERENCE_FIELD.getCode()));
        filter.and(new QFilter("textvalue", "in", ids)).and("dynextfldid.sourcepage", "!=", (Object)"fah_evt_gen_rule");
        filter.or(new QFilter("entryentity.mgetvaluetype", "=", (Object)String.valueOf(ExtractTypeEnum.REFERENCE_FIELD.getCode())).and(new QFilter("entryentity.mtextvalue", "in", ids)));
        HashSet<Long> ruleIds = new HashSet<Long>(2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO", (String)"fah_dyn_extfld_val", (String)"ruleid", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                ruleIds.add(row.getLong("ruleid"));
            }
        }
        if (!ruleIds.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            DynamicObjectCollection rules = QueryServiceHelper.query((String)"fah_acctrule", (String)"number,name", (QFilter[])new QFilter("id", "in", ruleIds).toArray());
            for (DynamicObject rule : rules) {
                if (builder.length() > 0) {
                    builder.append(";");
                }
                builder.append(rule.getString("number"));
            }
            return builder.toString();
        }
        return null;
    }

    public static Map<Object, DynamicObject> queryDynExtFieldValueSet(Long branchId) {
        QFilter filter = new QFilter("branchid", "=", (Object)branchId);
        return BusinessDataServiceHelper.loadFromCache((String)"fah_dyn_extfld_val", (QFilter[])filter.toArray());
    }

    public static void deleteDynExtFieldValueSet(Long ruleId) {
        QFilter filter = new QFilter("ruleId", "=", (Object)ruleId);
        DeleteServiceHelper.delete((String)"fah_dyn_extfld_val", (QFilter[])filter.toArray());
    }

    public static void switchEnable(List<Object> ids, String enable) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_fah_evt_gen_rule set fenable = ? ", new Object[]{enable});
        if ("0".equals(enable)) {
            sb.append(", fdisabledbyid = ? ", new Object[]{ContextUtil.getUserId()});
            sb.append(", fdisabledtime = ? ", new Object[]{new Date()});
        } else if ("1".equals(enable)) {
            sb.append(", fenabledbyid = ? ", new Object[]{ContextUtil.getUserId()});
            sb.append(", fenabledtime = ? ", new Object[]{new Date()});
        }
        sb.appendIn("where fid ", ids);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public static List<Object> getUpdateablePKs(List<Object> ids, String enable) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)enable), new QFilter("id", "in", ids)});
        return query.stream().map(o -> o.get("id")).collect(Collectors.toList());
    }

    public static void deleteRuleByIds(List<Object> ids) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fah_evt_gen_rule"), (Object[])ids.toArray());
    }

    public static List<String> getModelNumberById(List<Object> ids) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return query.stream().map(o -> o.getString("number")).collect(Collectors.toList());
    }

    public static List<Object> getReferredPKs(List<Object> ids) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fah_acctrule", (String)"eventrule", (QFilter[])new QFilter[]{new QFilter("eventrule", "in", ids)});
        return query.stream().map(o -> o.getLong("eventrule")).collect(Collectors.toList());
    }

    public static Long getBizGimId(Long evtLineTypeId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_fah_dimgrp_type_evtlnk where fbaseDataId=?", new Object[]{evtLineTypeId});
        try (DataSet dataSet = DB.queryDataSet((String)"FahEventRuleCfgDAO.getBizGimId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            if (dataSet.hasNext()) {
                Long l = dataSet.next().getLong("fid");
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static DynamicObject[] getDimGrpEntry(Long bizGimId) {
        return BusinessDataServiceHelper.load((String)"fah_biz_dimgrp_en", (String)"fid,fseq,fbizdimtypeid,fisenabled,fisrequired,fissysreserved,fDimInnerId", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)bizGimId).and(new QFilter("fCustGrpID", "=", (Object)0))}, (String)"fseq asc");
    }

    public static DataSet getAllDimGrp(Set<Long> dimGrpIds) {
        if (dimGrpIds == null || dimGrpIds.isEmpty()) {
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT dimgrp.fid headid,dimgrp.fnumber headnumber,dimgrp.fnumber headname,dimgrpen.fBizDimTypeNum BizDimTypeNum,asstacttype.fname BizDimTypeName,dimgrpen.fDimInnerId DimInnerId FROM t_fah_dimgrp_type dimgrp", new Object[0]);
        sql.append("INNER JOIN t_fah_dimgrp_type_en dimgrpen ON dimgrp.fid = dimgrpen.fid \n", new Object[0]);
        sql.append("INNER JOIN t_ai_asstacttype asstacttype ON asstacttype.fid = dimgrpen.fBizDimTypeid \n", new Object[0]);
        sql.appendIn("where dimgrp.fid ", dimGrpIds.toArray());
        sql.append("and dimgrpen.fCustGrpID  =?", new Object[]{0});
        sql.append("order by dimgrpen.fseq asc", new Object[0]);
        return DB.queryDataSet((String)"FahEventRuleCfgDAO.getAllDimGrp", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getAllEvtLineDimGrp(Set<Long> evtLineIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fdiminnerid diminnerid FROM t_fah_evtline_dimgrp_cfg  ", new Object[0]);
        sql.appendIn("WHERE fEntryId ", evtLineIds.toArray());
        return DB.queryDataSet((String)"FahEventRuleCfgDAO.getAllEvtLineDimGrp", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DataSet getAllDimGrpForCheck(Set<Long> evtLineIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT eventline.fentryid  id,eventline.fseq lineseq,dimgrp_en.fseq dimgrpseq FROM t_fah_evtline_dimgrp_cfg dimgrpcfg", new Object[0]);
        sql.append("INNER JOIN t_fah_evtline_gen_rule eventline ON eventline.fentryid = dimgrpcfg.fentryid ", new Object[0]);
        sql.append("INNER JOIN t_fah_dimgrp_type_en dimgrp_en ON dimgrp_en.fid = eventline.fDimGrpTypeId AND dimgrp_en.fseq=dimgrpcfg.fseq", new Object[0]);
        sql.appendIn("WHERE eventline.fentryid ", evtLineIds.toArray());
        sql.append("AND dimgrp_en.fIsEnabled='1' AND dimgrpcfg.fCustomCfgId=0 AND dimgrpcfg.fSysPresetCfgId=0", new Object[0]);
        return DB.queryDataSet((String)"FahEventRuleCfgDAO.getAllDimGrpForCheck", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static Set<String> queryExistBySrcBill(Collection<String> srcBillTypes) {
        HashSet<String> hasSchemeSet = new HashSet<String>();
        QFilter qFilter = new QFilter("group", "in", srcBillTypes);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fah_evt_gen_rule", (String)"group", (QFilter[])qFilter.toArray(), null);){
            rows.distinct().forEach(row -> hasSchemeSet.add(row.getString("group")));
        }
        return hasSchemeSet;
    }
}

