/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.flex;

import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;

public class MappingFlexFieldSearchDao {
    public static MappingStructureMeta queryValueMapStructure(Long pk, Boolean isTypeId) {
        Long mapStructId;
        Long orgId = null;
        if (isTypeId.booleanValue()) {
            DynamicObject typeObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"fah_valmap_typenew");
            mapStructId = typeObj.getLong("struc_id");
            orgId = typeObj.getLong("org_id");
        } else {
            mapStructId = pk;
        }
        DynamicObject strucObj = BusinessDataServiceHelper.loadSingle((Object)mapStructId, (String)"fah_valmap_struc");
        MappingStructureMeta mappingStructureMeta = new MappingStructureMeta(strucObj.getLong("id"), strucObj.getString("number"), strucObj.getString("name"));
        FlexFieldGrpCfg outputParamMeta = new FlexFieldGrpCfg(strucObj.getLong("id"), strucObj.getString("number"), strucObj.getString("name"));
        mappingStructureMeta.setDescription(strucObj.getString("description"));
        outputParamMeta.setDescription(strucObj.getString("description"));
        mappingStructureMeta.setEnabled(strucObj.getBoolean("enable"));
        outputParamMeta.setEnabled(strucObj.getBoolean("enable"));
        mappingStructureMeta.setId(mapStructId);
        outputParamMeta.setId(mapStructId);
        if (isTypeId.booleanValue()) {
            mappingStructureMeta.setTypeId(pk);
            outputParamMeta.setTypeId(pk);
            mappingStructureMeta.setOrgId(orgId);
            List<Long> enabledOrgIdList = MappingFlexFieldSearchDao.queryEnabledOrgIdList(pk);
            mappingStructureMeta.setEnabledOrgIdList(enabledOrgIdList);
        }
        String sql = "select fentryid,fseq,fattnum,fattname,fflexfieldnum,fattdatatype,fownernum,ffieldusagetype,frefentity,freftypeid,freffieldnum,fdescription from t_fah_flex_struc where fid = ? order by fseq";
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.flex.MappingFlexFieldSearchDao.queryValueMapStructure", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])new Object[]{mapStructId});){
            for (Row row : dataSet) {
                if (row.getInteger("ffieldusagetype") == 1) {
                    FlexFieldCfg inputCfg = new FlexFieldCfg(row.getLong("fentryid"), row.getString("fattnum"), row.getString("fattname"));
                    inputCfg.setSeq(row.getInteger("fseq"));
                    inputCfg.setDbFieldNum(row.getString("fflexfieldnum"));
                    inputCfg.setDataType(DataValueTypeEnum.getEnum(row.getString("fattdatatype")));
                    inputCfg.setRefBaseProp(row.getString("frefentity"));
                    inputCfg.setRefTypeId(row.getLong("freftypeid"));
                    inputCfg.setRefFieldNum(row.getString("freffieldnum"));
                    inputCfg.setFieldUsageType(1);
                    mappingStructureMeta.cache(inputCfg);
                    continue;
                }
                if (row.getInteger("ffieldusagetype") != 0) continue;
                FlexFieldCfg outputCfg = new FlexFieldCfg(row.getLong("fentryid"), row.getString("fattnum"), row.getString("fattname"));
                outputCfg.setSeq(row.getInteger("fseq"));
                outputCfg.setDbFieldNum(row.getString("fflexfieldnum"));
                outputCfg.setDataType(DataValueTypeEnum.getEnum(row.getString("fattdatatype")));
                outputCfg.setRefBaseProp(row.getString("frefentity"));
                outputCfg.setRefTypeId(row.getLong("freftypeid"));
                outputCfg.setRefFieldNum(row.getString("freffieldnum"));
                outputCfg.setFieldUsageType(0);
                outputParamMeta.cache(outputCfg);
            }
            mappingStructureMeta.flush();
            outputParamMeta.flush();
            mappingStructureMeta.setOutputParamMeta(outputParamMeta);
            MappingStructureMeta mappingStructureMeta2 = mappingStructureMeta;
            return mappingStructureMeta2;
        }
    }

    private static List<Long> queryEnabledOrgIdList(Long mapTypeId) {
        SqlBuilder sqlBuilder = new SqlBuilder().append("select fownorgid from t_fah_valmap_type_org where fmaptypeid = ? ", new Object[]{mapTypeId});
        return (List)DB.query((DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder, resultSet -> {
            LinkedList<Long> orgList = new LinkedList<Long>();
            while (resultSet.next()) {
                orgList.add(resultSet.getLong("fownorgid"));
            }
            return orgList;
        });
    }
}

