/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.flex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.MappingMultiValueType;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.dao.flex.MappingValueDao;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.utils.StringUtils;

public class MappingValueDaoImpl
implements MappingValueDao {
    private static final String algoKey = "MappingFlexFieldSearchDaoImpl.queryMappingMultiValues";
    private static final String singleValueSelectPrefix = "select fid,fserialnumber,fgroupid,fownorgid,fstatus,fhashcode,feffectdate,fexpiredate";
    private static final String multiValueSelectPrefix = "select a.fid fid,fserialnumber,fgroupid,fownorgid,fstatus,feffectdate,fexpiredate,b.fcolindex fcolindex";
    private static final String mixValueSelectPrefix = "select a.fid fid,fserialnumber,fgroupid,fownorgid,fstatus,fhasmulvalue,feffectdate,fexpiredate,b.fcolindex fcolindex";
    private static final String mixValueSelectPrefixWithLimit = "select top #limit# a.fid fid,fserialnumber,fstatus,fhasmulvalue,feffectdate,fexpiredate,b.fcolindex fcolindex";
    private static final String limitRegex = "#limit#";
    private static final String singleValueFromTable = "from t_fah_flex_mapval a where 1=1";
    private static final String multiValueFromTable = "from t_fah_flex_mapval a, t_fah_flex_mapval_en b where a.fid=b.fid";
    private static final String mixValueFromTable = "from t_fah_flex_mapval a left join t_fah_flex_mapval_en b on a.fid=b.fid where 1=1";
    private static final String orderBy = "order by fserialnumber";
    private static final String mapTypeSelect = "select fid,fenable from t_fah_valmap_type";

    @Override
    public DataSet queryMappingMultiValues(Long mappingType, IValueSetMeta inputParamMeta, Map<Integer, Set<Object>> multiValueMap, String status) {
        if (null == multiValueMap || multiValueMap.size() == 0) {
            return null;
        }
        HashSet<String> entryDbFieldSet = new HashSet<String>(2);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            String fieldValueColumnName = inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
            entryDbFieldSet.add(fieldValueColumnName);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(multiValueSelectPrefix, new Object[0]);
        for (String dbField : entryDbFieldSet) {
            sqlBuilder.append(",", new Object[0]).append("b." + dbField, new Object[0]).append(dbField, new Object[0]);
        }
        sqlBuilder.append(multiValueFromTable, new Object[0]);
        this.appendMultiValueConditions(sqlBuilder, mappingType, status);
        this.appendMultiValueEntryConditions(sqlBuilder, inputParamMeta, multiValueMap);
        sqlBuilder.append(orderBy, new Object[0]);
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    @Override
    public DataSet queryAllMappingMultiValues(Long mappingType, IValueSetMeta inputParamMeta, String status) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(multiValueSelectPrefix, new Object[0]);
        HashSet<String> entryDbFieldSet = new HashSet<String>(2);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            String fieldValueColumnName = inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
            entryDbFieldSet.add(fieldValueColumnName);
        }
        for (String dbField : entryDbFieldSet) {
            sqlBuilder.append(",", new Object[0]).append("b." + dbField, new Object[0]).append(dbField, new Object[0]);
        }
        sqlBuilder.append(multiValueFromTable, new Object[0]);
        this.appendMultiValueConditions(sqlBuilder, mappingType, status);
        sqlBuilder.append(orderBy, new Object[0]);
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    @Override
    public DataSet queryAllMappingSingleValues(Long mappingType, IValueSetMeta inputParamMeta, String status) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(singleValueSelectPrefix, new Object[0]);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            sqlBuilder.append(",", new Object[0]).append(inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum(), new Object[0]);
        }
        sqlBuilder.append(singleValueFromTable, new Object[0]);
        this.appendMappingConditions(sqlBuilder, mappingType, status);
        sqlBuilder.append(orderBy, new Object[0]);
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    @Override
    public DataSet queryMappingSingleValues(Long mappingType, IValueSetMeta inputParamMeta, String status, Long hashCode) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(singleValueSelectPrefix, new Object[0]);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            sqlBuilder.append(",", new Object[0]).append(inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum(), new Object[0]);
        }
        sqlBuilder.append(singleValueFromTable, new Object[0]);
        this.appendMappingConditions(sqlBuilder, mappingType, status);
        sqlBuilder.append("and a.fhashcode = ?", new Object[]{hashCode});
        sqlBuilder.append(orderBy, new Object[0]);
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    @Override
    public DataSet queryMappingValues(IValueSetMeta inputParamMeta, String status, String enable, int startSN, int batchSize, Map<Integer, Set<Object>> multiValueMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (batchSize > 0) {
            sqlBuilder.append(mixValueSelectPrefixWithLimit.replaceFirst(limitRegex, String.valueOf(batchSize)), new Object[0]);
        } else {
            sqlBuilder.append(mixValueSelectPrefix, new Object[0]);
        }
        HashSet<String> entryDbFieldSet = new HashSet<String>(2);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            sqlBuilder.append(",", new Object[0]).append(inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum(), new Object[0]);
            String fieldValueColumnName = inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
            entryDbFieldSet.add(fieldValueColumnName);
        }
        for (String dbField : entryDbFieldSet) {
            sqlBuilder.append(",", new Object[0]).append("b." + dbField, new Object[0]).append(dbField, new Object[0]);
        }
        sqlBuilder.append(mixValueFromTable, new Object[0]);
        sqlBuilder.append("and fserialnumber > ?", new Object[]{startSN});
        this.appendMixMappingConditions(sqlBuilder, inputParamMeta.getTypeId(), status, enable);
        this.appendMultiValueEntryConditions(sqlBuilder, inputParamMeta, multiValueMap);
        sqlBuilder.append(orderBy, new Object[0]);
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    private void appendMixMappingConditions(SqlBuilder sqlBuilder, Long mappingType, String status, String enable) {
        sqlBuilder.append("and a.fmaptypeid = ?", new Object[]{mappingType});
        if (null != enable) {
            sqlBuilder.append("and a.fenable = ?", new Object[]{enable});
        }
        sqlBuilder.append("and a.fmapvaluetype = ?", new Object[]{MappingValueType.INPUT.getValue()});
        if (null != status) {
            sqlBuilder.append("and a.fstatus = ?", new Object[]{status});
        }
    }

    private void appendHashcodeAndGroupdiCondition(SqlBuilder sql, Set<PairTuple<Long, Long>> params) {
        sql.append(" and (", new Object[0]);
        int index = 1;
        for (PairTuple<Long, Long> param : params) {
            sql.append("(fhashcode = ? and ", new Object[]{param.getKey()});
            sql.append("fgroupid = ?)", new Object[]{param.getValue()});
            if (index < params.size()) {
                sql.append(" or ", new Object[0]);
            }
            ++index;
        }
        sql.append(")", new Object[0]);
    }

    @Override
    public DataSet queryMapType(Long mappingType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(mapTypeSelect, new Object[0]);
        sqlBuilder.append("where fid = ?", new Object[]{mappingType});
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);
    }

    @Override
    public void saveValMapOrg(List<MappingValueTypeOrg> orgList, Long typeId, String baseProp) {
        DeleteServiceHelper.delete((String)"fah_valmap_type_org", (QFilter[])new QFilter[]{new QFilter("maptype", "=", (Object)typeId)});
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(orgList.size());
        for (MappingValueTypeOrg org : orgList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_valmap_type_org");
            obj.set("maptype", (Object)typeId);
            obj.set("ownorg", org.getId());
            obj.set("orgtype", (Object)org.getOrgtype());
            obj.set("description", (Object)org.getDescription());
            obj.set("iscustom", (Object)org.isCustom());
            if (StringUtils.isNotEmpty((String)baseProp)) {
                obj.set("targetbaseprop", (Object)baseProp);
            }
            saveList.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
    }

    @Override
    public DynamicObjectCollection queryDuplicateRecord(List<MappingValueTypeOrg> orgList, Long groupId, Long pkid) {
        DynamicObjectCollection types = QueryServiceHelper.query((String)"fah_valmap_typenew", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)});
        List typeids = types.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        typeids.remove(pkid);
        List orgids = orgList.stream().map(o -> (Long)o.getId()).collect(Collectors.toList());
        return QueryServiceHelper.query((String)"fah_valmap_type_org", (String)"maptype, ownorg.name, ownorg.number", (QFilter[])new QFilter[]{new QFilter("maptype", "in", typeids), new QFilter("ownorg", "in", orgids)});
    }

    @Override
    public List<MappingValueTypeOrg> queryOrgRecordsByTypeId(Long typeID) {
        DynamicObjectCollection orgRecords = QueryServiceHelper.query((String)"fah_valmap_type_org", (String)"maptype,ownorg,ownorg.number,orgtype,iscustom,description", (QFilter[])new QFilter[]{new QFilter("maptype", "=", (Object)typeID)}, (String)"ownorg.number");
        ArrayList<MappingValueTypeOrg> result = new ArrayList<MappingValueTypeOrg>(orgRecords.size());
        if (!orgRecords.isEmpty()) {
            HashMap idNumberNameMap = new HashMap(orgRecords.size());
            List orgIdList = orgRecords.stream().map(o -> o.getLong("ownorg")).collect(Collectors.toList());
            DynamicObjectCollection orgObjs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdList)});
            orgObjs.forEach(o -> idNumberNameMap.put(o.getLong("id"), new PairTuple((Object)o.getString("number"), (Object)o.getString("name"))));
            for (DynamicObject row : orgRecords) {
                long orgId = row.getLong("ownorg");
                MappingValueTypeOrg org = new MappingValueTypeOrg(orgId, (String)((PairTuple)idNumberNameMap.get(orgId)).getKey(), (String)((PairTuple)idNumberNameMap.get(orgId)).getValue(), row.getString("description"), row.getString("orgtype"), row.getBoolean("iscustom"));
                result.add(org);
            }
        }
        return result;
    }

    @Override
    public boolean isExistDataByOrgId(Long pkId, Long orgId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select count(1) as cnt from t_fah_flex_mapval where fmaptypeid = ?", new Object[]{pkId});
        sql.append(" and fgroupid = ?", new Object[]{orgId});
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql);){
            int count;
            if (dataSet.hasNext() && (count = dataSet.next().getInteger("cnt").intValue()) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        SqlBuilder sql2 = new SqlBuilder();
        sql2.append("select count(1) as cnt from t_fah_flex_mapval_tmp where fmaptypeid = ?", new Object[]{pkId});
        sql2.append(" and fgroupid = ?", new Object[]{orgId});
        try (DataSet dataSet2 = DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql2);){
            int count;
            if (dataSet2.hasNext() && (count = dataSet2.next().getInteger("cnt").intValue()) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public Map<Long, PairTuple<String, String>> queryOrgNameNumberMap(Set<Long> orgs) {
        QFilter qf = new QFilter("id", "in", orgs);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{qf});
        HashMap<Long, PairTuple<String, String>> result = new HashMap<Long, PairTuple<String, String>>();
        org.stream().forEach(o -> result.put(o.getLong("id"), new PairTuple((Object)o.getString("number"), (Object)o.getString("name"))));
        return result;
    }

    @Override
    public Map<Long, Set<Integer>> queryTimeIllegalTempData(Long pkId, String pageId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgroupid, fserialnumber from t_fah_flex_mapval_tmp where fmaptypeid = ? ", new Object[]{pkId});
        sql.append("and fchangetype != 'D' ", new Object[0]);
        sql.append("and fmapvaluetype != '1' ", new Object[0]);
        sql.append("and feffectdate is not null and fexpiredate is not null ", new Object[0]);
        sql.append("and feffectdate > fexpiredate and fpageId = ?", new Object[]{pageId});
        HashMap<Long, Set<Integer>> result = new HashMap<Long, Set<Integer>>();
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.computeIfAbsent(row.getLong("fgroupid"), k -> new HashSet()).add(row.getInteger("fserialnumber"));
            }
        }
        return result;
    }

    @Override
    public Map<Long, Set<Integer>> queryNullIllegalTempData(Long pkId, List<String> outputDBFields, String pageId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgroupid, fserialnumber from t_fah_flex_mapval_tmp where fmaptypeid = ? ", new Object[]{pkId});
        sql.append("and fchangetype != 'D' ", new Object[0]);
        sql.append("and fmapvaluetype = '0' and fpageId = ?", new Object[]{pageId});
        for (String outputDBField : outputDBFields) {
            if (outputDBField.contains("txt")) {
                sql.append(" and ", new Object[0]).append(outputDBField, new Object[0]).append(" = ' '", new Object[0]);
                continue;
            }
            sql.append(" and ", new Object[0]).append(outputDBField, new Object[0]).append(" = ?", new Object[]{0L});
        }
        HashMap<Long, Set<Integer>> result = new HashMap<Long, Set<Integer>>();
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.computeIfAbsent(row.getLong("fgroupid"), k -> new HashSet()).add(row.getInteger("fserialnumber"));
            }
        }
        return result;
    }

    @Override
    public void updateValMapTypeStatus(Long pkId, String checkstatus) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"fah_valmap_typenew");
        obj.set("checkstatus", (Object)checkstatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    @Override
    public void updateValMapValueStatusByTypeId(Long typeId, List<Long> ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_fah_flex_mapval set fstatus = 'C' where fmaptypeid = ? and fstatus = 'A' ", new Object[]{typeId});
        if (ids != null) {
            sql.appendIn("and fid ", ids.toArray());
        }
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    @Override
    public void updateValMapValueStatus(Long pkid, Long orgId, Set<Integer> set, List<Long> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_fah_flex_mapval set fstatus = 'C' where fstatus = 'A' and fmaptypeid = ?", new Object[]{pkid});
        sqlBuilder.appendIn(" and fserialnumber not ", set.toArray());
        if (ids != null) {
            sqlBuilder.appendIn(" and fid ", ids.toArray());
        }
        sqlBuilder.append(" and fgroupid = ?", new Object[]{orgId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("update t_fah_flex_mapval set fstatus = 'A' where fstatus = 'C' and fmaptypeid = ?", new Object[]{pkid});
        sqlBuilder2.appendIn(" and fserialnumber ", set.toArray());
        if (ids != null) {
            sqlBuilder2.appendIn(" and fid ", ids.toArray());
        }
        sqlBuilder2.append(" and fgroupid = ?", new Object[]{orgId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder2);
    }

    @Override
    public void updateValMapValueStatusByOrgId(Long pkid, Set<Long> passOrgs) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_fah_flex_mapval set fstatus = 'C' where fstatus = 'A' and fmaptypeid = ?", new Object[]{pkid});
        sqlBuilder.appendIn(" and fgroupid ", passOrgs.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    private void appendMappingConditions(SqlBuilder sqlBuilder, Long mappingType, String status) {
        sqlBuilder.append("and a.fmaptypeid = ?", new Object[]{mappingType});
        sqlBuilder.append("and a.fenable = ?", new Object[]{"1"});
        sqlBuilder.append("and a.fmapvaluetype = ?", new Object[]{MappingValueType.INPUT.getValue()});
        sqlBuilder.append("and a.fhasmulvalue = ?", new Object[]{MappingMultiValueType.SINGLE.getValue()});
        if (null != status) {
            sqlBuilder.append("and a.fstatus = ?", new Object[]{status});
        }
    }

    private void appendMultiValueConditions(SqlBuilder sqlBuilder, Long mappingType, String status) {
        sqlBuilder.append("and a.fmaptypeid = ?", new Object[]{mappingType});
        sqlBuilder.append("and b.fmaptypeid = ?", new Object[]{mappingType});
        sqlBuilder.append("and a.fenable = ?", new Object[]{"1"});
        sqlBuilder.append("and a.fmapvaluetype = ?", new Object[]{MappingValueType.INPUT.getValue()});
        sqlBuilder.append("and a.fhasmulvalue = ?", new Object[]{MappingMultiValueType.MULTI.getValue()});
        sqlBuilder.append("and a.fstatus = ?", new Object[]{status});
    }

    private void appendMultiValueEntryConditions(SqlBuilder sqlBuilder, IValueSetMeta inputParamMeta, Map<Integer, Set<Object>> multiValueMap) {
        if (null == multiValueMap || multiValueMap.size() == 0) {
            return;
        }
        SqlBuilder multiValueConditionSqlBuilder = new SqlBuilder();
        boolean first = true;
        for (Map.Entry<Integer, Set<Object>> entry : multiValueMap.entrySet()) {
            String fieldValueColumnName;
            String string = fieldValueColumnName = inputParamMeta.getColumnBySeq(entry.getKey()).getDbFieldNum().startsWith("fidattr") ? "fidattr" : "ftxtattr";
            if (first) {
                first = false;
            } else {
                multiValueConditionSqlBuilder.append("or", new Object[0]);
            }
            multiValueConditionSqlBuilder.append("b.fcolindex = ? ", new Object[]{entry.getKey()});
            multiValueConditionSqlBuilder.appendIn("and b." + fieldValueColumnName, entry.getValue().toArray());
        }
        sqlBuilder.append("and (", new Object[0]);
        sqlBuilder.appendSqlBuilder(multiValueConditionSqlBuilder);
        sqlBuilder.append(")", new Object[0]);
    }

    @Override
    public int getCount(Long mapTypeId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) cnt from t_fah_flex_mapval ", new Object[0]);
        sqlBuilder.append("where fmapvaluetype = ? ", new Object[]{MappingValueType.INPUT.getValue()});
        sqlBuilder.append("and fmaptypeid = ? ", new Object[]{mapTypeId});
        return (Integer)DB.query((DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("cnt");
            }
            return 0;
        });
    }

    @Override
    public DataSet queryRepeatedRecordsByHashcodeAndGroupId(Long mapTypeId, IValueSetMeta inputParamMeta) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t2.fid,t2.fgroupid, t2.fhashcode, t2.fserialnumber, t2.feffectdate, t2.fexpiredate", new Object[0]);
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            sql.append(", ", new Object[0]).append("t2.", new Object[0]).append(inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum(), new Object[0]);
        }
        sql.append("from t_fah_flex_mapval t2 inner join    (select t1.fhashcode, t1.fgroupid        from t_fah_flex_mapval t1        where t1.fmaptypeid = ? and t1.fmapvaluetype = '1' ", new Object[]{mapTypeId}).append("and t1.fhashcode in (select th.fhashcode from t_fah_flex_mapval th where th.fstatus = 'A' and th.fmapvaluetype = '1' and th.fmaptypeid = ?) ", new Object[]{mapTypeId}).append("group by t1.fhashcode, t1.fgroupid having count(1) > 1 ) tp on t2.fgroupid = tp.fgroupid and t2.fhashcode = tp.fhashcode where t2.fmaptypeid = ? and t2.fmapvaluetype = '1' order by t2.fgroupid, t2.fhashcode", new Object[]{mapTypeId});
        return DB.queryDataSet((String)"MappingFlexFieldSearchDao.queryRepeatedHashcodeAndGroupId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }
}

