/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.instance.Instance;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.migration.enums.MigrationProcessStageEnum;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.task.status.ResultCountTypeEnum;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class BgTaskLogDao {
    private static final String INSERT_DETAIL = "insert into t_fah_bgtask_log_detail (fid,fentryid,fseq,floglevel,ftaskstepstatus,fmsg,fmsg_tag) VALUES (?,?,?,?,?,?,?)";
    private static final String UPDATE_TASK = "update t_fah_bgtask_log set ftaskstatus = ?, fcomptime = ?, fmodifytime = ? where fid = ?";

    public static void saveTaskLog(BackgroundTaskTypeEnum taskType, TaskStatusEnum taskStatus, List<Object[]> detailInfoList) {
        BgTaskLogDao.saveTaskLog(taskType, taskStatus, detailInfoList, null);
    }

    public static void saveTaskLog(BackgroundTaskTypeEnum taskType, TaskStatusEnum taskStatus, List<Object[]> detailInfoList, BaseBackgroundTaskContext<Object> taskContext) {
        DynamicObject taskLog = BusinessDataServiceHelper.newDynamicObject((String)"fah_bgtask_log");
        if (null != taskContext) {
            taskLog.set("id", taskContext.getTaskId());
        }
        taskLog.set("tasktype", (Object)taskType.getStringValue());
        taskLog.set("taskname", BgTaskLogDao.getFahRequestTaskNo(taskType, taskContext));
        String instanceId = Instance.getInstanceId();
        if (null != instanceId) {
            taskLog.set("instanceid", (Object)(instanceId.length() > 50 ? instanceId.substring(0, 47) + "..." : instanceId));
        }
        taskLog.set("creatorid", (Object)RequestContext.get().getCurrUserId());
        if (null != taskContext) {
            taskLog.set("cmpworkpoint", (Object)taskContext.getTaskPoints(ResultCountTypeEnum.Success_Cnt));
            taskLog.set("totalworkpoint", (Object)taskContext.getTaskPoints(ResultCountTypeEnum.Total_Expect_Cnt));
        }
        Date current = new Date();
        taskLog.set("createtime", (Object)current);
        taskLog.set("taskstatus", (Object)taskStatus.getStringValue());
        if (taskStatus.getCode() > 2) {
            taskLog.set("taskstatus", (Object)taskStatus.getStringValue());
            taskLog.set("comptime", (Object)current);
        }
        if (null != detailInfoList && !detailInfoList.isEmpty()) {
            DynamicObjectCollection entryEntity = taskLog.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < detailInfoList.size(); ++i) {
                DynamicObject row = entryEntity.addNew();
                Object[] detailInfo = detailInfoList.get(0);
                row.set("seq", (Object)i);
                row.set("loglevel", (Object)((LogLevelEnum)((Object)detailInfo[0])).getStringValue());
                row.set("taskstepstatus", (Object)((TaskStatusEnum)((Object)detailInfo[1])).getStringValue());
                String msg = (String)detailInfo[2];
                if (null == msg) continue;
                row.set("msg", (Object)(msg.length() > 255 ? msg.substring(0, 255) : msg));
                row.set("msg_tag", (Object)msg);
            }
        }
        try (TXHandle h = TX.notSupported();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskLog});
        }
    }

    private static Object getFahRequestTaskNo(BackgroundTaskTypeEnum taskType, BaseBackgroundTaskContext<Object> taskContext) {
        if (null == taskContext || taskType != BackgroundTaskTypeEnum.Common_Create_Event) {
            return taskType.getName();
        }
        String taskNo = BgTaskLogDao.queryRequestTaskNo(taskContext.getTaskId());
        return String.format("%s[%s]", taskType.getName(), taskNo);
    }

    private static String queryRequestTaskNo(Object taskId) {
        try (DataSet dataset = DB.queryDataSet((String)"queryRequestTaskNo", (DBRoute)FAHCommonConstant.AI, (String)"select ftaskno from t_fah_request_task where fid = ?", (Object[])new Object[]{taskId});){
            if (dataset.hasNext()) {
                String string = dataset.next().getString("ftaskno");
                return string;
            }
        }
        return "";
    }

    public static boolean saveInfoLog(LogLevelEnum logLevel, MigrationProcessStageEnum migrationProcessStageEnum, Object srcModel, BaseBackgroundTaskContext<Object> taskContext) {
        DynamicObject taskLog;
        if (null != taskContext && null != (taskLog = BusinessDataServiceHelper.loadSingle((Object)taskContext.getTaskId(), (String)"fah_bgtask_log"))) {
            DynamicObjectCollection entryEntity = taskLog.getDynamicObjectCollection("entryentity");
            taskLog.set("cmpworkpoint", (Object)taskContext.getTaskPoints(ResultCountTypeEnum.Success_Cnt));
            if (null != taskContext.getTaskStatus()) {
                taskLog.set("taskstatus", (Object)taskContext.getTaskStatus().getStringValue());
            }
            taskLog.set("comptime", (Object)new Date());
            if (null != srcModel) {
                DynamicObject newRow = entryEntity.addNew();
                newRow.set("seq", (Object)entryEntity.size());
                newRow.set("loglevel", (Object)logLevel.getStringValue());
                newRow.set("taskstepstatus", (Object)TaskStatusEnum.COMPLETED.getStringValue());
                String msg = String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u8fc1\u5165\u6210\u529f\u3002", (String)"BgTaskLogDao_0", (String)"fi-ai-common", (Object[])new Object[0]), ((DataModelCfg)srcModel).getNumber());
                if (null != msg) {
                    newRow.set("msg", (Object)(msg.length() > 255 ? msg.substring(0, 255) : msg));
                    newRow.set("msg_tag", (Object)msg);
                }
            }
            try (TXHandle h = TX.notSupported();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskLog});
            }
            return true;
        }
        return false;
    }

    public static boolean saveErrorLog(LogLevelEnum logLevel, MigrationProcessStageEnum migrationProcessStageEnum, Object srcModel, Collection<String> errorMsg, Throwable throwable, BaseBackgroundTaskContext<Object> taskContext) {
        if (null != taskContext) {
            DynamicObject taskLog = BusinessDataServiceHelper.loadSingle((Object)taskContext.getTaskId(), (String)"fah_bgtask_log");
            if (null != taskLog) {
                DynamicObjectCollection entryEntity = taskLog.getDynamicObjectCollection("entryentity");
                if (null != taskContext.getTaskStatus()) {
                    taskLog.set("taskstatus", (Object)taskContext.getTaskStatus().getStringValue());
                } else {
                    taskLog.set("taskstatus", (Object)TaskStatusEnum.FAILURE.getStringValue());
                }
                taskLog.set("comptime", (Object)new Date());
                if (null != errorMsg) {
                    String msg;
                    DynamicObject newRow = entryEntity.addNew();
                    newRow.set("seq", (Object)entryEntity.size());
                    newRow.set("loglevel", (Object)logLevel.getStringValue());
                    if (logLevel == LogLevelEnum.Warning) {
                        newRow.set("taskstepstatus", (Object)TaskStatusEnum.WAIN.getStringValue());
                        msg = ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u8fc1\u5165\u6210\u529f\uff0c\u53d1\u5e03\u5931\u8d25\uff1a\u201c%2$s\u201d\u3002", (String)"BgTaskLogDao_1", (String)"fi-ai-common", (Object[])new Object[0]);
                    } else {
                        newRow.set("taskstepstatus", (Object)TaskStatusEnum.FAILURE.getStringValue());
                        msg = ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u8fc1\u5165\u5931\u8d25\uff1a\u201c%2$s\u201d\u3002", (String)"BgTaskLogDao_2", (String)"fi-ai-common", (Object[])new Object[0]);
                    }
                    String msgInfo = String.format(msg, null != srcModel ? ((DataModelCfg)srcModel).getNumber() : "", StringUtils.join((Object[])errorMsg.toArray(), (String)","));
                    if (null != msgInfo) {
                        newRow.set("msg", (Object)(msgInfo.length() > 255 ? msgInfo.substring(0, 255) : msgInfo));
                        newRow.set("msg_tag", (Object)msgInfo);
                    }
                }
                try (TXHandle h = TX.notSupported();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskLog});
                }
            }
            return true;
        }
        return false;
    }

    public static void appendDetails(long taskId, Collection<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        Long[] entryIds = BgTaskLogDao.__genEntryIds(params.size());
        int i = 0;
        for (Object[] param : params) {
            param[0] = taskId;
            param[1] = entryIds[i++];
            if (param[6] == null) {
                param[5] = " ";
                param[6] = " ";
                continue;
            }
            param[5] = param[6].toString().length() > 255 ? param[6].toString().substring(0, 255) : param[6];
        }
        try (TXHandle h = TX.notSupported();){
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)INSERT_DETAIL, new ArrayList<Object[]>(params));
        }
        params.clear();
    }

    public static Long[] __genEntryIds(int cnt) {
        SequenceReader sReader = new SequenceReader(FAHCommonConstant.AI);
        return (Long[])sReader.getSequences((Object[])new Long[1], "t_fah_bgtask_log_detail", cnt);
    }

    public static void updateTaskToEnd(long taskId, TaskStatusEnum taskStatusEnum) {
        try (TXHandle h = TX.notSupported();){
            Date now = new Date();
            DB.execute((DBRoute)FAHCommonConstant.AI, (String)UPDATE_TASK, (Object[])new Object[]{taskStatusEnum.getStringValue(), now, now, taskId});
        }
    }
}

