/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.sys;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class BaseDaoImpl {
    private static final String Algo_Query_Prefix = "BaseDaoImpl|";

    public int queryDataSetWithPk(String entityName, String selector, Collection<Object> pkIds, BiFunction<Integer, Object[], Boolean> procFunc, boolean reuseRowCache, String orderBy, int top) {
        QFilter pkFilter = FahEntityMetaHelper.buildPKFilter(entityName, pkIds);
        return pkFilter != null ? this.queryDataSetEx(entityName, selector, pkFilter.toArray(), procFunc, reuseRowCache, orderBy, top) : 0;
    }

    public int queryDataSetWithPk(String entityName, String selector, Collection<Object> pkIds, BiFunction<Integer, Row, Boolean> procFunc, String orderBy, int top) {
        QFilter pkFilter = FahEntityMetaHelper.buildPKFilter(entityName, pkIds);
        return pkFilter != null ? this.queryDataSetEx(entityName, selector, pkFilter.toArray(), procFunc, orderBy, top) : 0;
    }

    public int queryDataSetEx(String entityName, String selectProperties, QFilter[] filters, BiFunction<Integer, Object[], Boolean> procFunc, boolean reuseRowCache, String orderBy, int top) {
        if (entityName == null || selectProperties == null || procFunc == null) {
            return 0;
        }
        int totalFetchRowCnt = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(Algo_Query_Prefix + entityName), (String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy, (int)top);){
            if (ds == null) {
                int n = 0;
                return n;
            }
            int length = ds.getRowMeta().getFieldCount();
            DataType[] fieldDataType = new DataType[length];
            Field[] fields = ds.getRowMeta().getFields();
            for (int i = 0; i < length; ++i) {
                fieldDataType[i] = fields[i].getDataType();
            }
            Object[] rowBuf = new Object[length];
            int rowIndex = 0;
            while (ds.hasNext()) {
                Row row = ds.next();
                ++totalFetchRowCnt;
                if (reuseRowCache) {
                    rowBuf = new Object[length];
                }
                for (int i = 0; i < length; ++i) {
                    rowBuf[i] = fieldDataType[i].convertValue(row.get(i));
                }
                if (procFunc.apply(rowIndex++, rowBuf).booleanValue()) continue;
                break;
            }
        }
        return totalFetchRowCnt;
    }

    public int queryDataSetEx(String entityName, String selectProperties, QFilter[] filters, BiFunction<Integer, Object[], Boolean> procFunc, boolean reuseRowCache) {
        return this.queryDataSetEx(entityName, selectProperties, filters, procFunc, reuseRowCache, null, -1);
    }

    public int queryDataSetEx(String entityName, String selectProperties, QFilter[] filters, BiFunction<Integer, Object[], Boolean> procFunc) {
        return this.queryDataSetEx(entityName, selectProperties, filters, procFunc, true, null, -1);
    }

    public int queryDataSetEx(String entityName, String selectProperties, QFilter[] filters, BiFunction<Integer, Row, Boolean> procFunc, String orderBy, int top) {
        if (entityName == null || selectProperties == null || procFunc == null) {
            return 0;
        }
        int totalFetchRowCnt = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(Algo_Query_Prefix + entityName), (String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy, (int)top);){
            if (ds == null) {
                int n = 0;
                return n;
            }
            int rowIndex = 0;
            while (ds.hasNext()) {
                Row row = ds.next();
                ++totalFetchRowCnt;
                if (procFunc.apply(rowIndex++, row).booleanValue()) continue;
                break;
            }
        }
        return totalFetchRowCnt;
    }

    public Object[] querySingle(String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        Object[][] result = new Object[1][];
        this.queryDataSetEx(entityName, selectProperties, filters, (index, row) -> {
            result[0] = row;
            return false;
        }, false, orderBy, 1);
        return result[0];
    }

    public Object[] querySingle(String entityName, String selectProperties, QFilter[] filters) {
        return this.querySingle(entityName, selectProperties, filters, null);
    }

    public Object querySingleValue(String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        Object[] result = new Object[1];
        this.queryDataSetEx(entityName, selectProperties, filters, (index, row) -> {
            result[0] = row[0];
            return false;
        }, false, orderBy, 1);
        return result[0];
    }

    public Object querySingleValue(String entityName, String selectProperties, QFilter[] filters) {
        return this.querySingleValue(entityName, selectProperties, filters, null);
    }

    public int queryEntryDataFromSelector(String mainEntityName, Collection<Long> pkIds, String entryEntity, Collection<Long> entryIds, String selectProperties, BiFunction<Integer, Object[], Boolean> procFunc, boolean reuseRowCache, String orderBy, int top) {
        List<QFilter> filters = FahEntityMetaHelper.buildEntryPKQueryFilter(mainEntityName, pkIds, entryEntity, entryIds);
        if (filters.isEmpty()) {
            return 0;
        }
        return this.queryDataSetEx(mainEntityName, selectProperties, filters.toArray(new QFilter[0]), procFunc, reuseRowCache, orderBy, top);
    }

    public int queryEntryDataFromSelector(String mainEntityName, Collection<Long> pkIds, String entryEntity, Collection<Long> entryIds, String selectProperties, BiFunction<Integer, Row, Boolean> procFunc, String orderBy, int top) {
        List<QFilter> filters = FahEntityMetaHelper.buildEntryPKQueryFilter(mainEntityName, pkIds, entryEntity, entryIds);
        if (filters.isEmpty()) {
            return 0;
        }
        return this.queryDataSetEx(mainEntityName, selectProperties, filters.toArray(new QFilter[0]), procFunc, orderBy, top);
    }

    public int queryEntryDataFromSelector(String mainEntityName, Collection<Long> pkIds, String entryEntity, Collection<Long> entryIds, String selectProperties, BiFunction<Integer, Object[], Boolean> procFunc) {
        return this.queryEntryDataFromSelector(mainEntityName, pkIds, entryEntity, entryIds, selectProperties, procFunc, true, null, -1);
    }
}

