/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.fi.v2.fah.meta.SimpleBaseDTOMeta;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;

public abstract class AbstractBaseDTOCollection {
    protected BaseInsertSqlBuilder<Long> __sqlBuilder;
    protected transient ISqlParamBuffer sqlParamBuffer;
    protected transient SimpleBaseDTOMeta dtoMeta;

    protected AbstractBaseDTOCollection() {
        this(8);
    }

    protected AbstractBaseDTOCollection(int initialSize) {
        if (initialSize <= 0) {
            initialSize = 8;
        }
        this.__sqlBuilder = new BaseInsertSqlBuilder<Object>(null, null);
        this.setDtoMeta(this.getDtoMeta());
        this.__sqlBuilder.setSqlParams(new ArrayList<Object[]>(initialSize));
        this.sqlParamBuffer = this.__sqlBuilder.getSqlParamBuffer();
    }

    protected abstract SimpleBaseDTOMeta getDtoMeta();

    public abstract String getEntityName();

    public abstract String getTableName();

    protected int getColumnWritePos(String columnNum) {
        return this.dtoMeta.accessFiledMeta(columnNum, field -> field.getWritePos());
    }

    protected void setDtoMeta(SimpleBaseDTOMeta dtoMeta) {
        this.dtoMeta = dtoMeta;
        if (this.dtoMeta == null || dtoMeta.isEmpty()) {
            throw new IllegalArgumentException("DTO Meta cannot be null!");
        }
        this.__sqlBuilder.cleanColumns(new IAddSqlColumn.ColumnGrpType[0]);
        if (this.sqlParamBuffer != null) {
            this.sqlParamBuffer.clear();
        }
        this.__sqlBuilder.setTableName(dtoMeta.getNumber());
        int idx = 0;
        for (SimpleTableFieldMeta fieldMeta : (SimpleTableFieldMeta[])dtoMeta.getValues()) {
            if (dtoMeta.getPkColumnIndex() == idx) {
                this.__sqlBuilder.addPKColumn(fieldMeta.getDbFieldNum(), new Object[0]);
            } else if (dtoMeta.getSeqColumnIndex() == idx) {
                this.__sqlBuilder.addSequenceColumn(fieldMeta.getDbFieldNum(), new Object[0]);
            } else {
                this.__sqlBuilder.addSingleColumn(IAddSqlColumn.ColumnGrpType.DataColumn, fieldMeta.getDbFieldNum(), IAddSqlColumn.ColumnUsageType.NormalData, new Object[0]);
            }
            ++idx;
        }
    }

    public String buildSqlStatement() {
        return this.__sqlBuilder.buildSqlStatement(new Object[0]).toString();
    }

    public List<Object[]> getSqlParams() {
        return this.__sqlBuilder.getSqlParams();
    }

    public Iterator<List<Object[]>> getSqlParams(int batchSize) {
        return this.__sqlBuilder.getSqlParams(batchSize);
    }

    protected Object[] getRowByIndex(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.__sqlBuilder.getSqlParamRowCnt()) {
            throw new IllegalArgumentException(String.format("Invalid Row Index:%d, actual size=%d", rowIdx, this.__sqlBuilder.getSqlParamRowCnt()));
        }
        return this.__sqlBuilder.getSqlParams().get(rowIdx);
    }

    protected <T> T getRowColumnByIndex(int rowIdx, int columnIdx) {
        if (rowIdx < 0 || rowIdx >= this.__sqlBuilder.getSqlParamRowCnt()) {
            throw new IllegalArgumentException(String.format("Invalid Row Index:%d, actual size=%d", rowIdx, this.__sqlBuilder.getSqlParamRowCnt()));
        }
        return (T)this.__sqlBuilder.getSqlParams().get(rowIdx)[columnIdx];
    }

    protected <T> T _getParamBufferColumnValue(int columnIndex) {
        return (T)(this.sqlParamBuffer != null ? this.sqlParamBuffer.directGetValue(columnIndex) : null);
    }

    protected <T> T _setParamBufferColumnValue(int columnIndex, T value) {
        if (this.sqlParamBuffer != null) {
            this.sqlParamBuffer.directSetValue(columnIndex, value);
            return value;
        }
        return null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int moveToNextParamRow() {
        return this.sqlParamBuffer.moveToNextParamRow();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getCurrentRowIndex() {
        return this.sqlParamBuffer.getCurrentRowIndex();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasUnchangedCacheRow() {
        return this.sqlParamBuffer.hasUnchangedCacheRow();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        this.sqlParamBuffer.clear();
        this.__sqlBuilder.clearSqlParamData();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void resetRowData() {
        this.sqlParamBuffer.resetRowData();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void clearDataChangeFlag() {
        this.sqlParamBuffer.clearDataChangeFlag();
    }

    public boolean isColumnBufferHashData(int columnIndex) {
        return this.sqlParamBuffer.isColumnBufferHashData(columnIndex);
    }
}

