/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.fi.v2.fah.constant.enums.FahValMapFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.utils.StringUtils;

public class EntryElement
extends Element {
    private static final long serialVersionUID = 22L;
    private List<Element> items = new ArrayList<Element>();
    boolean isShowSeq = false;
    boolean isSplitPage = false;
    private EntryAp ap;
    private EntryAp finishAp;
    private transient IFormView view;

    public EntryAp getAp() {
        return this.ap;
    }

    public void setAp(EntryAp ap) {
        this.ap = ap;
    }

    public EntryElement(String name) {
        super(name);
    }

    public EntryElement(String name, boolean isShowSeq) {
        super(name);
        this.isShowSeq = isShowSeq;
    }

    public EntryElement(String name, boolean isShowSeq, boolean isEnable) {
        super(name);
        this.isShowSeq = isShowSeq;
        this.isEnable = isEnable;
    }

    public boolean isSplitPage() {
        return this.isSplitPage;
    }

    public void setSplitPage(boolean splitPage) {
        this.isSplitPage = splitPage;
    }

    private EntryAp getEntryAp() {
        EntryAp entryAp;
        if (this.finishAp != null) {
            return this.finishAp;
        }
        if (this.getAp() == null) {
            entryAp = new EntryAp();
            entryAp.setKey("entryap");
        } else {
            entryAp = this.getAp();
        }
        List<Element> items = this.getItems();
        EntryFieldGroupAp sourceGroupAp = null;
        EntryFieldGroupAp targetGroupAp = null;
        EntryFieldGroupAp schemeConditionAp = null;
        for (Element item : items) {
            FieldAp entryFieldAp = item.getFieldAp();
            if (StringUtils.isEmpty((String)entryFieldAp.getLock())) {
                entryFieldAp.setLock(this.isEnable ? "" : "new,edit,view,submit,audit");
            }
            if (MappingValueType.INPUT.getValue().equals(item.getFlexFieldType())) {
                if (null == sourceGroupAp) {
                    sourceGroupAp = EntryElement.createGroupAp(FahValMapFieldGroupEnum.MAPPING_SOURCE);
                    entryAp.getItems().add(sourceGroupAp);
                }
                sourceGroupAp.getItems().add(entryFieldAp);
                continue;
            }
            if (MappingValueType.OUTPUT.getValue().equals(item.getFlexFieldType())) {
                if (null == targetGroupAp) {
                    targetGroupAp = EntryElement.createGroupAp(FahValMapFieldGroupEnum.MAPPING_TARGET);
                    entryAp.getItems().add(targetGroupAp);
                }
                targetGroupAp.getItems().add(entryFieldAp);
                continue;
            }
            if ("2".equals(item.getFlexFieldType())) {
                if (null == schemeConditionAp) {
                    schemeConditionAp = EntryElement.createGroupAp(FahValMapFieldGroupEnum.SCHEME_CONDITION);
                    entryAp.getItems().add(schemeConditionAp);
                }
                schemeConditionAp.getItems().add(entryFieldAp);
                continue;
            }
            entryAp.getItems().add(entryFieldAp);
        }
        entryAp.setShowSeq(this.isShowSeq);
        entryAp.setSplitPage(this.isSplitPage);
        this.finishAp = entryAp;
        return entryAp;
    }

    private static EntryFieldGroupAp createGroupAp(FahValMapFieldGroupEnum groupEnum) {
        EntryFieldGroupAp groupAp = new EntryFieldGroupAp();
        groupAp.setId(groupEnum.getId());
        groupAp.setKey(groupEnum.getKey());
        groupAp.setName(new LocaleString(groupEnum.getName()));
        return groupAp;
    }

    public void setItems(List<Element> items) {
        this.items = items;
        for (Element item : items) {
            item.parentName = this.name;
        }
    }

    public List<Element> getItems() {
        return this.items;
    }

    public void build(IFormView view) {
        this.view = view;
        this.regPropAndEdit();
        this.regField();
    }

    @Override
    public void registerEntryProp(EntryType entryType) {
        List<Element> items = this.getItems();
        for (Element item : items) {
            if (entryType.getProperty(item.getName()) != null) continue;
            item.registerEntryProp(entryType);
        }
    }

    public EntryGrid getControl(IFormView view) {
        EntryGrid gg = (EntryGrid)this.getEntryAp().buildRuntimeControl();
        gg.setKey(this.name);
        gg.setEntryKey(this.name);
        gg.setView(view);
        gg.setModel(view.getModel());
        gg.setSplitPage(this.isSplitPage);
        List items = gg.getItems();
        for (Element element : this.getItems()) {
            element.getControl(view);
        }
        int i = 0;
        for (Control item : items) {
            if (view.getControl(item.getKey()) != null) {
                item = view.getControl(item.getKey());
                items.set(i, item);
                item.setView(view);
            }
            if (item instanceof Container) {
                List controls = ((Container)item).getItems();
                if (null != controls) {
                    for (Control control : controls) {
                        control.setView(view);
                    }
                }
            } else {
                ((FieldEdit)item).getProperty();
            }
            ++i;
        }
        return gg;
    }

    private void regPropAndEdit() {
        MainEntityType mainEntityType = this.view.getModel().getDataEntityType();
        EntryType entryType = this.getAp() != null ? (EntryType)mainEntityType.getAllEntities().get(this.name) : new EntryType();
        this.registerEntryProp(entryType);
        mainEntityType.getAllEntities().put(this.name, entryType);
        this.registerEntryEdit((EntryGrid)this.view.getControl(this.name), this.view);
    }

    private void registerEntryEdit(EntryGrid entryGrid, IFormView view) {
        EntryAp entryAp = this.getEntryAp();
        List items = ((Container)entryAp.buildRuntimeControl()).getItems();
        int i = 0;
        for (Control item : items) {
            if (view.getControl(item.getKey()) != null) {
                item = view.getControl(item.getKey());
                items.set(i, item);
                item.setView(view);
            }
            item.setView(view);
            entryGrid.getItems().add(item);
            ++i;
        }
    }

    private void regField() {
        EntryAp ap = this.getEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", this.name);
        mapEntry.put("columns", (String)ap.createControl().get("columns"));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(this.name, "createGridColumns", new Object[]{mapEntry});
        this.view.updateView(this.name);
    }
}

