/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetValueCfgBranchGrp;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableMeta;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableRelationshipMeta;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;
import kd.fi.v2.fah.storage.tables.TableSpaceManager;

public class ProcessorRuntimeCfgBuilderContext {
    protected TableSpaceManager tableSpaceManager = new TableSpaceManager();
    protected Map<Object, Integer> cfgGrpIdx = new HashMap<Object, Integer>(16);
    protected CacheableMutableArrayStorage<Map<Long, DynValFieldGetValueCfgBranchGrp>> filedCfgs = new CacheableMutableArrayStorage();
    protected Map<String, List<String>> presetFieldDependencies;
    protected List<String> preProcessFields;

    public boolean addTableInfo(SimpleTableMeta tableMeta) {
        return this.tableSpaceManager.add(tableMeta);
    }

    public SimpleTableMeta removeTableInfo(String tableNum) {
        return (SimpleTableMeta)this.tableSpaceManager.removeEx(tableNum);
    }

    public boolean addTableRelationship(SimpleTableRelationshipMeta relationship) {
        return this.tableSpaceManager.addTableRelationship(relationship);
    }

    public void removeTableRelationship(SimpleTableRelationshipMeta relationship) {
        this.tableSpaceManager.removeTableRelationship(relationship);
    }

    public boolean addGetValueFieldCfgs(Object cfgGrpKey, Collection<DynValFieldGetValueCfgBranchGrp> fields) {
        LinkedHashMap<Long, DynValFieldGetValueCfgBranchGrp> cfgBranchGrpMap;
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        Integer grpIdx = this.cfgGrpIdx.get(cfgGrpKey);
        if (grpIdx == null) {
            cfgBranchGrpMap = new LinkedHashMap<Long, DynValFieldGetValueCfgBranchGrp>(16);
            this.cfgGrpIdx.put(cfgGrpKey, this.filedCfgs.addEx(cfgBranchGrpMap));
        } else {
            cfgBranchGrpMap = (LinkedHashMap<Long, DynValFieldGetValueCfgBranchGrp>)this.filedCfgs.get(grpIdx);
        }
        for (DynValFieldGetValueCfgBranchGrp f : fields) {
            cfgBranchGrpMap.put(f.getItemKey(), f);
        }
        return true;
    }

    public void build(Object cfgGrpKey) {
        Integer cfgGrpIdx = this.cfgGrpIdx.get(cfgGrpKey);
        if (cfgGrpIdx == null) {
            throw new IllegalArgumentException(String.format("Config Group[%s] Not found!", cfgGrpKey));
        }
    }

    public boolean addPresetFieldDependencies(String fieldNum, Collection<String> dependencies) {
        if (fieldNum == null || dependencies == null || dependencies.isEmpty()) {
            return false;
        }
        this.presetFieldDependencies.computeIfAbsent(fieldNum, v -> new LinkedList()).addAll(dependencies);
        return true;
    }

    public Map<String, List<String>> getPresetFieldDependencies() {
        return this.presetFieldDependencies;
    }

    public void setPresetFieldDependencies(Map<String, List<String>> presetFieldDependencies) {
        this.presetFieldDependencies = presetFieldDependencies;
    }

    public List<String> getPreProcessFields() {
        return this.preProcessFields;
    }

    public void setPreProcessFields(List<String> preProcessFields) {
        this.preProcessFields = preProcessFields;
    }
}

