/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.fi.v2.fah.engine.config.IProcessorConfigContext;
import kd.fi.v2.fah.engine.config.common.ProcessorCfgModelKey;
import kd.fi.v2.fah.models.common.tree.ICustomDumpModel;
import kd.fi.v2.fah.models.modeling.base.AbstractBaseModelCollection;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public abstract class AbstractBaseProcessorCfgModel<ITEM_KEY, V extends IDataItemKey>
extends AbstractBaseModelCollection<ProcessorCfgModelKey, ITEM_KEY, V>
implements IProcessorConfigContext,
IDataItemKey<ProcessorCfgModelKey>,
ICustomDumpModel {
    protected ProcessorCfgModelKey cfgModelKey;
    protected String processorKey;
    protected SimpleTableFieldMeta outputField;

    protected AbstractBaseProcessorCfgModel() {
        this.cfgModelKey = new ProcessorCfgModelKey(-1, -1);
    }

    protected AbstractBaseProcessorCfgModel(int runLevel, int cfgModelSeqKey) {
        this.cfgModelKey = new ProcessorCfgModelKey(runLevel, cfgModelSeqKey);
    }

    protected AbstractBaseProcessorCfgModel(int runLevel, int cfgModelSeqKey, String processorKey, SimpleTableFieldMeta outputField) {
        this(runLevel, cfgModelSeqKey);
        this.processorKey = processorKey;
        this.outputField = outputField;
    }

    @Override
    public String toString() {
        return "AbstractBaseProcessorCfgModel{cfgModelKey=" + this.cfgModelKey + ", processorKey='" + this.processorKey + '\'' + ", outputField='" + this.outputField + '\'' + ", inputFields=" + this.collections + ", id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }

    public int[] getOutputParamPos() {
        int[] nArray;
        if (this.outputField == null) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.outputField.getWritePos();
        }
        return nArray;
    }

    @Override
    public void dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        if (output == null) {
            return;
        }
        output.append(StringUtils.buildPrefix(levelPrefix, level));
        output.append(String.format("[%s:Type=%s, processorKey=%s, cfgModelKey=%s, outputField=%s", new Object[]{this.getClass().getSimpleName(), this.getProcessorClassType(), this.processorKey, this.cfgModelKey, this.outputField}));
        this.__custom_dumpCfgModel(output, levelPrefix, level);
        output.append("]");
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            output.append(", child_cnt=").append(((BaseMutableArrayMapStorage)this.collections).size());
            int i = 0;
            String childPrefix = StringUtils.buildPrefix(levelPrefix, level + 1);
            for (Object field : (BaseMutableArrayMapStorage)this.collections) {
                if (field instanceof ICustomDumpModel) {
                    output.append(String.format("\n%s%d).%s", childPrefix, i++, ((ICustomDumpModel)field).dumpCfgModelToString(levelPrefix, level + 1)));
                    continue;
                }
                output.append(String.format("\n%s%d).%s", childPrefix, i++, field));
            }
        } else {
            output.append(", child_cnt=0");
        }
    }

    protected void __custom_dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
    }

    @Override
    public String getProcessorKey() {
        return this.processorKey;
    }

    public void setProcessorKey(String processorKey) {
        this.processorKey = processorKey;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public ProcessorCfgModelKey getItemKey() {
        return this.cfgModelKey;
    }

    @Override
    public ProcessorCfgModelKey getCfgModelKey() {
        return this.cfgModelKey;
    }

    @Override
    public void setCfgModelKey(ProcessorCfgModelKey cfgModelKey) {
        this.cfgModelKey = cfgModelKey;
    }

    public void setCfgModeKey(int runLevel, int cfgModelSeqKey) {
        this.cfgModelKey.reset(runLevel, cfgModelSeqKey);
    }

    @Override
    public SimpleTableFieldMeta getOutputField() {
        return this.outputField;
    }

    @Override
    public void setOutputField(SimpleTableFieldMeta outputField) {
        this.outputField = outputField;
    }
}

