/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import kd.fi.v2.fah.constant.enums.MappingTypeEnum;
import kd.fi.v2.fah.engine.config.common.AbstractFieldDependedCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class MappingConvertUnitCfgModel
extends AbstractFieldDependedCfgModel {
    protected MappingTypeEnum mappingType;
    protected Long mappingRuleId;

    public MappingConvertUnitCfgModel() {
    }

    public MappingConvertUnitCfgModel(int runLevel, Integer cfgModelSeqKey, MappingTypeEnum mappingType, Long mappingRuleId) {
        this(runLevel, cfgModelSeqKey, mappingType, mappingRuleId, null);
    }

    public MappingConvertUnitCfgModel(int runLevel, Integer cfgModelSeqKey, MappingTypeEnum mappingType, Long mappingRuleId, SimpleTableFieldMeta outputField) {
        super(runLevel, cfgModelSeqKey);
        this.mappingType = mappingType;
        this.mappingRuleId = mappingRuleId;
        this.outputField = outputField;
    }

    @Override
    public String toString() {
        return "MappingConvertUnitCfgModel{mappingType=" + (Object)((Object)this.mappingType) + ", mappingRuleId=" + this.mappingRuleId + ", outputField=" + this.outputField + ", cfgModelKey=" + this.cfgModelKey + ", processorKey='" + this.processorKey + '\'' + ", id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", collections=" + this.collections + '}';
    }

    @Override
    protected void __custom_dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        output.append(String.format(", mappingType=%s, mappingRuleId=%s", new Object[]{this.mappingType, this.mappingRuleId}));
    }

    @Override
    public void dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        if (output == null) {
            return;
        }
        super.dumpCfgModel(output, levelPrefix, level);
        output.append(StringUtils.buildPrefix(levelPrefix, level + 1)).append("[outputField]=").append(this.outputField);
    }

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.Mapping_Convert;
    }

    @Override
    public Collection<String> doValidate() {
        LinkedList<String> error = new LinkedList<String>();
        if (this.mappingType == null) {
            error.add("Mapping Type is null");
        }
        if (this.mappingRuleId == null) {
            error.add("Mapping Target ID is null");
        }
        if (this.collections == null || ((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            error.add("Mapping Input Param is Empty");
        }
        if (this.outputField == null) {
            error.add("Mapping Output Param is Empty");
        }
        return error;
    }

    public MappingTypeEnum getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingTypeEnum mappingType) {
        this.mappingType = mappingType;
    }

    public Long getMappingRuleId() {
        return this.mappingRuleId;
    }

    public void setMappingRuleId(Long mappingRuleId) {
        this.mappingRuleId = mappingRuleId;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public SimpleTableFieldMeta[] getInputFields() {
        return this.collections == null ? null : (SimpleTableFieldMeta[])((BaseMutableArrayMapStorage)this.collections).getValues();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setInputFields(Collection<SimpleTableFieldMeta> inputFields) {
        if (this.collections == null) {
            this.collections = this.__createStorage();
        }
        ((BaseMutableArrayMapStorage)this.collections).batchAdd(inputFields);
    }
}

