/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.fi.v2.fah.constant.enums.MappingTypeEnum;
import kd.fi.v2.fah.engine.config.common.AbstractBaseProcessorCfgModel;
import kd.fi.v2.fah.engine.config.impl.MappingConvertUnitCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.models.valueset.IBaseFieldMeta;
import kd.fi.v2.fah.utils.StringUtils;

public class MappingGrpCfgModel
extends AbstractBaseProcessorCfgModel<Long, MappingConvertUnitCfgModel> {
    protected MappingTypeEnum mappingType;
    protected Long mappingGrpId;
    protected SimpleTableFieldMeta inputField;
    protected Map<Long, Integer> enableOrgIdx;

    @Override
    public Collection<String> doValidate() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Function<MappingConvertUnitCfgModel, Long> getItemKeyParser() {
        return v -> v != null ? v.getMappingRuleId() : null;
    }

    public boolean addMappingEnableOrgIndex(Collection<Long> orgIds, int mappingCfgIndex) {
        if (orgIds == null || orgIds.isEmpty() || mappingCfgIndex < 0) {
            return false;
        }
        if (this.enableOrgIdx == null) {
            this.enableOrgIdx = new HashMap<Long, Integer>(8);
        }
        for (Long orgId : orgIds) {
            this.enableOrgIdx.put(orgId, mappingCfgIndex);
        }
        return true;
    }

    public int getOrgCnt() {
        return this.enableOrgIdx == null ? 0 : this.enableOrgIdx.size();
    }

    public MappingConvertUnitCfgModel getMappingTable(Long orgId) {
        return this.enableOrgIdx == null ? null : (MappingConvertUnitCfgModel)this.get(this.enableOrgIdx.getOrDefault(orgId, -1).intValue());
    }

    @Override
    protected void __custom_dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        output.append(String.format(", mappingType=%s, mappingGrpId=%s", new Object[]{this.mappingType, this.mappingGrpId}));
    }

    @Override
    public void dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        if (output == null) {
            return;
        }
        super.dumpCfgModel(output, levelPrefix, level);
        output.append(StringUtils.buildPrefix(levelPrefix, level + 1)).append("[enableOrgIdx]=").append(this.enableOrgIdx);
    }

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.Mapping_Convert;
    }

    @Override
    public Collection<IBaseFieldMeta> getDependedFields(boolean nest) {
        return null;
    }

    public MappingTypeEnum getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingTypeEnum mappingType) {
        this.mappingType = mappingType;
    }

    public Long getMappingGrpId() {
        return this.mappingGrpId;
    }

    public void setMappingGrpId(Long mappingGrpId) {
        this.mappingGrpId = mappingGrpId;
    }

    public SimpleTableFieldMeta getInputField() {
        return this.inputField;
    }

    public void setInputField(SimpleTableFieldMeta inputField) {
        this.inputField = inputField;
    }

    public Map<Long, Integer> getEnableOrgIdx() {
        return this.enableOrgIdx;
    }

    public void setEnableOrgIdx(Map<Long, Integer> enableOrgIdx) {
        this.enableOrgIdx = enableOrgIdx;
    }
}

