/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.processor.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.ds.query.IQueryResultSet;
import kd.fi.v2.fah.ds.query.impl.algo.AlgoSetQueryResultSet;
import kd.fi.v2.fah.ds.query.impl.dynamicobject.DynamicObjectQueryResultSet;
import kd.fi.v2.fah.engine.config.impl.DataQueryUnitCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.engine.processor.ISQLQueryConfigContext;
import kd.fi.v2.fah.engine.processor.common.AbstractBaseProcessorUnit;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;

public abstract class AbstractBaseDataQueryProcessorUnit<IN_PARAM, SRC_RES, CFG extends DataQueryUnitCfgModel, TAB extends IDataTableStorage>
extends AbstractBaseProcessorUnit<IN_PARAM, Iterator<PairTuple<TAB, Integer>>, CFG>
implements Iterator<PairTuple<TAB, Integer>> {
    protected SRC_RES srcQueryResult;
    protected boolean eof;
    protected PairTuple<TAB, Integer> resultTupleBuffer;
    protected int batchSize;

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.SQL_Query;
    }

    @Override
    public boolean initProcessorUnit() {
        this.batchSize = ((DataQueryUnitCfgModel)this.cfg).getFetchBatchSize();
        return true;
    }

    @Override
    protected Iterator<PairTuple<TAB, Integer>> doProcess(IN_PARAM inputParam, IBackgroundTaskContext<?> taskContext, Object otherParam) {
        this.srcQueryResult = this.getInitialQueryResult(inputParam, (DataQueryUnitCfgModel)this.cfg, otherParam);
        this.eof = this.srcQueryResult == null;
        return this;
    }

    protected abstract SRC_RES getInitialQueryResult(IN_PARAM var1, CFG var2, Object var3);

    protected abstract boolean isSrcQueryResultHasNext(SRC_RES var1);

    @Override
    public boolean hasNext() {
        return !this.eof && this.isSrcQueryResultHasNext(this.srcQueryResult);
    }

    @Override
    public PairTuple<TAB, Integer> next() {
        if (this.hasNext()) {
            TAB dataTable = this.createTableSpace();
            if (dataTable == null) {
                throw new IllegalArgumentException("Failed on Request Memory Table Space!");
            }
            int fetchCnt = this.fetchQueryResult(this.srcQueryResult, dataTable, (DataQueryUnitCfgModel)this.cfg);
            this.eof = !this.isSrcQueryResultHasNext(this.srcQueryResult);
            return this.customDataBatch(dataTable, fetchCnt);
        }
        throw new NoSuchElementException("Source ResultSet EOF!");
    }

    protected PairTuple<TAB, Integer> customDataBatch(TAB srcDataTable, int fetchCnt) {
        return this.resultTupleBuffer.reset(srcDataTable, (Object)fetchCnt);
    }

    protected abstract int fetchQueryResult(SRC_RES var1, TAB var2, CFG var3);

    protected TAB createTableSpace() {
        return (TAB)new SimpleTableColStorage(((DataQueryUnitCfgModel)this.cfg).getTemplateRowColumnCnt(), ((DataQueryUnitCfgModel)this.cfg).getFetchBatchSize());
    }

    protected Object[] getTemplateRow() {
        return ((DataQueryUnitCfgModel)this.cfg).getTemplateRow();
    }

    protected static IQueryResultSet<?, ?> doSQLProcess(QFilter[] inputFilters, ISQLQueryConfigContext configContext) {
        QFilter[] _filters = configContext.combineQFilter(inputFilters);
        if (configContext.isSqlQueryType()) {
            DataSet sourceDataSet = configContext.getPageSize() >= 0 ? QueryServiceHelper.queryDataSet((String)configContext.getAlgoQueryName(), (String)configContext.getQueryTarget(), (String)configContext.getSelectFieldString(), (QFilter[])_filters, (String)configContext.getOrderBy(), (int)configContext.getPageSize()) : QueryServiceHelper.queryDataSet((String)configContext.getAlgoQueryName(), (String)configContext.getQueryTarget(), (String)configContext.getSelectFieldString(), (QFilter[])_filters, (String)configContext.getOrderBy());
            return new AlgoSetQueryResultSet(sourceDataSet);
        }
        DynamicObjectCollection sourceDyns = configContext.getPageSize() >= 0 ? QueryServiceHelper.query((String)configContext.getAlgoQueryName(), (String)configContext.getQueryTarget(), (String)configContext.getSelectFieldString(), (QFilter[])_filters, (String)configContext.getOrderBy(), (int)configContext.getPageSize()) : QueryServiceHelper.query((String)configContext.getAlgoQueryName(), (String)configContext.getQueryTarget(), (String)configContext.getSelectFieldString(), (QFilter[])_filters, (String)configContext.getOrderBy());
        return new DynamicObjectQueryResultSet((Collection<DynamicObject>)sourceDyns);
    }

    protected static int[][] buildTableReadWritePos(SimpleTableFieldMeta[] inputFields) {
        if (inputFields == null || inputFields.length == 0) {
            return new int[0][];
        }
        int[][] readWritePos = new int[inputFields.length][2];
        int i = 0;
        for (SimpleTableFieldMeta field : inputFields) {
            readWritePos[i++] = new int[]{field.getReadPos(), field.getWritePos()};
        }
        return readWritePos;
    }

    protected int[][] getTableReadWritePos() {
        return AbstractBaseDataQueryProcessorUnit.buildTableReadWritePos(((DataQueryUnitCfgModel)this.cfg).getSrcSelectFields());
    }

    protected static int fillTableSpace(IQueryResultSet<?, ?> srcResult, IDataTableStorage output, int maxFetchRowCnt, int[][] readWritePos, Object[] templateRow) {
        int totalFetchColumnCnt = templateRow.length;
        int totalFetchCnt = 0;
        while (totalFetchCnt <= maxFetchRowCnt && srcResult.hasNext()) {
            Object srcDataRow = srcResult.next();
            if (srcDataRow == null) continue;
            Object[] rowValueBuf = new Object[totalFetchColumnCnt];
            System.arraycopy(templateRow, 0, rowValueBuf, 0, totalFetchColumnCnt);
            for (int[] pos : readWritePos) {
                if (pos == null) continue;
                rowValueBuf[pos[1]] = srcDataRow.get(pos[0]);
            }
            output.insertRowData(rowValueBuf, false, true);
            ++totalFetchCnt;
        }
        if (totalFetchColumnCnt > 0) {
            output.flush();
        }
        return totalFetchCnt;
    }
}

