/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.processor.common;

import kd.fi.v2.fah.engine.enums.ResultStatusEnum;
import kd.fi.v2.fah.engine.processor.IProcessorUnit;
import kd.fi.v2.fah.engine.processor.SimpleProcessResultCounts;
import kd.fi.v2.fah.log.ILogHandler;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;

public abstract class AbstractBaseProcessorUnit<IN, R, CFG>
implements IProcessorUnit<IN, R, CFG> {
    protected String processorKey;
    protected CFG cfg;
    protected R processResult;
    protected ILogHandler logHandler;
    protected boolean suppressException;
    protected boolean enabled = true;
    protected SimpleProcessResultCounts resultStatus;

    protected AbstractBaseProcessorUnit() {
        this(null, null, null, false);
    }

    protected AbstractBaseProcessorUnit(String processorKey) {
        this(processorKey, null, null, false);
    }

    protected AbstractBaseProcessorUnit(String processorKey, CFG cfg) {
        this(processorKey, cfg, null, false);
    }

    protected AbstractBaseProcessorUnit(String processorKey, CFG cfg, ILogHandler logHandler) {
        this(processorKey, cfg, logHandler, false);
    }

    protected AbstractBaseProcessorUnit(String processorKey, CFG cfg, ILogHandler logHandler, boolean suppressException) {
        this.processorKey = processorKey;
        this.cfg = cfg;
        this.logHandler = logHandler;
        this.suppressException = suppressException;
        this.resultStatus = new SimpleProcessResultCounts(ResultStatusEnum.SUCCESS);
    }

    @Override
    public SimpleProcessResultCounts process(IN input, IBackgroundTaskContext<?> taskContext, Object params) {
        block5: {
            if (!this.preValidation(input, taskContext, params)) {
                if (this.logHandler != null) {
                    this.logHandler.onError("Error on preValidation", this);
                }
                return this.resultStatus.setResultStatus(ResultStatusEnum.FAILURE);
            }
            try {
                this.processResult = this.doProcess(input, taskContext, params);
            }
            catch (Exception ex) {
                this.resultStatus.setResultStatus(ResultStatusEnum.FAILURE);
                if (this.logHandler != null) {
                    this.logHandler.onError("Error on doProcess", (Object)this, (Throwable)ex);
                }
                if (this.suppressException) break block5;
                throw ex;
            }
        }
        return this.resultStatus;
    }

    protected boolean preValidation(IN input, IBackgroundTaskContext<?> taskContext, Object params) {
        return input != null;
    }

    protected abstract R doProcess(IN var1, IBackgroundTaskContext<?> var2, Object var3);

    @Override
    public void clear() {
        this.cfg = null;
        this.processResult = null;
    }

    public void setProcessorKey(String processorKey) {
        this.processorKey = processorKey;
    }

    @Override
    public String getProcessorKey() {
        return this.processorKey;
    }

    @Override
    public ILogHandler getLogHandler() {
        return this.logHandler;
    }

    @Override
    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    @Override
    public boolean isSuppressException() {
        return this.suppressException;
    }

    @Override
    public void setSuppressException(boolean suppressException) {
        this.suppressException = suppressException;
    }

    @Override
    public CFG getCfg() {
        return this.cfg;
    }

    @Override
    public boolean setCfgContext(CFG cfgContext) {
        this.cfg = cfgContext;
        return true;
    }

    @Override
    public R getProcessResult() {
        return this.processResult;
    }

    public void setProcessResult(R processResult) {
        this.processResult = processResult;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getItemKey() {
        return IProcessorUnit.super.getItemKey();
    }
}

