/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppMetadataCache;
import kd.bos.isv.ISVService;
import kd.fi.v2.fah.formbuilder.containercfg.ContainerApCfg;
import kd.fi.v2.fah.utils.StringUtils;

public class DynamicFormConfig {
    protected String bizAppId;
    protected LocaleString formName;
    protected String formId;
    protected String formNumber;
    protected String tableName;
    protected String DBRoute;
    protected String currentIsv;
    protected String formModelType;
    protected Map<String, ContainerApCfg> containerCfgs;
    protected Map<String, ContainerApCfg> delContainerCfgs;
    protected Map<String, String> tableIndexMap;

    public DynamicFormConfig(String bizAppId, String formModelType) {
        this.DBRoute = AppMetadataCache.getAppInfo((String)bizAppId).getDbRoute();
        this.currentIsv = ISVService.getISVInfo().getId();
        this.bizAppId = bizAppId;
        this.formModelType = formModelType;
    }

    public DynamicFormConfig() {
    }

    public DynamicFormConfig(String bizAppId) {
        this(bizAppId, "BillFormModel");
    }

    public String toString() {
        return "DynamicFormConfig{bizAppId='" + this.bizAppId + '\'' + ", formName=" + this.formName + ", formId='" + this.formId + '\'' + ", formNumber='" + this.formNumber + '\'' + ", tableName='" + this.tableName + '\'' + ", DBRoute='" + this.DBRoute + '\'' + ", currentIsv='" + this.currentIsv + '\'' + ", formModelType='" + this.formModelType + '\'' + ", containerCfgs=" + this.containerCfgs + ", delContainerCfgs=" + this.delContainerCfgs + ", tableIndexMap=" + this.tableIndexMap + '}';
    }

    public boolean validate(boolean throwException) {
        LinkedList<String> errorCheck = new LinkedList<String>();
        if (StringUtils.isEmpty((String)this.formNumber)) {
            errorCheck.add("Form-Number");
        }
        if (StringUtils.isEmpty((String)this.bizAppId)) {
            errorCheck.add("BizAppID");
        }
        if (!errorCheck.isEmpty()) {
            if (throwException) {
                throw new IllegalArgumentException(String.format("%s is Null!", errorCheck));
            }
            return false;
        }
        return true;
    }

    public Collection<ContainerApCfg> getContainers() {
        return this.containerCfgs == null || this.containerCfgs.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<ContainerApCfg>(this.containerCfgs.values());
    }

    public String getBizAppId() {
        return this.bizAppId;
    }

    public void setBizAppId(String bizAppId) {
        this.bizAppId = bizAppId;
    }

    public LocaleString getFormName() {
        return this.formName;
    }

    public void setFormName(LocaleString formName) {
        this.formName = formName;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormNumber() {
        return this.formNumber;
    }

    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

    public String getDBRoute() {
        return this.DBRoute;
    }

    public void setDBRoute(String DBRoute2) {
        this.DBRoute = DBRoute2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, ContainerApCfg> getContainerCfgs() {
        return this.containerCfgs;
    }

    public void setContainerCfgs(Map<String, ContainerApCfg> containerCfgs) {
        this.containerCfgs = containerCfgs;
    }

    public Map<String, ContainerApCfg> getDelContainerCfgs() {
        return this.delContainerCfgs;
    }

    public void setDelContainerCfgs(Map<String, ContainerApCfg> delContainerCfgs) {
        this.delContainerCfgs = delContainerCfgs;
    }

    public String getCurrentIsv() {
        return this.currentIsv;
    }

    public void setCurrentIsv(String currentIsv) {
        this.currentIsv = currentIsv;
    }

    public String getFormModelType() {
        return this.formModelType;
    }

    public void setFormModelType(String formModelType) {
        this.formModelType = formModelType;
    }

    public Map<String, String> getTableIndexMap() {
        return this.tableIndexMap;
    }

    public void setTableIndexMap(Map<String, String> tableIndexMap) {
        this.tableIndexMap = tableIndexMap;
    }
}

