/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.EntryOpParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConSummaryPanelAp;
import kd.bos.metadata.form.container.AdvConToolbarAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormFieldBuilder;
import kd.fi.v2.fah.formbuilder.containercfg.AdvConApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseFieldApCfg;

public class DynamicAdvContBuilder {
    private FormMetadata formMeta;
    private EntityMetadata entityMeta;
    List<ControlAp<?>> ctrlAps;
    List<EntityItem<?>> entityItems;
    private Map<String, ControlAp<?>> ctrlApsMap = new HashMap(16);
    private Map<String, EntityItem<?>> entityItemsMap = new HashMap(16);
    List<Operation> operations;

    public DynamicAdvContBuilder(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.init(formMeta, entityMeta);
    }

    private void init(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.formMeta = formMeta;
        this.entityMeta = entityMeta;
        this.ctrlAps = this.formMeta.getItems();
        this.entityItems = this.entityMeta.getItems();
        for (ControlAp<?> controlAp : this.ctrlAps) {
            this.ctrlApsMap.put(controlAp.getKey(), controlAp);
        }
        for (EntityItem entityItem : this.entityItems) {
            this.entityItemsMap.put(entityItem.getKey(), entityItem);
        }
        this.operations = entityMeta.getRootEntity().getOperations();
    }

    protected void addControlAp(AdvConApCfg cfg) throws InvocationTargetException, IllegalAccessException {
        List<ControlAp<?>> advConAps = this.createAdvConAp(cfg);
        EntryAp entryAp = this.createEntryAp(cfg, advConAps);
        List<BaseFieldApCfg> fieldCfgLi = cfg.getFieldCfgLi();
        List<EntryFieldAp> entryFieldAps = DynamicFormFieldBuilder.createEntryFieldAps(entryAp.getId(), fieldCfgLi);
        EntryEntity entryEntity = this.createEntryEntity(cfg, entryAp);
        List<Field<?>> fields = DynamicFormFieldBuilder.createFields(fieldCfgLi, entryEntity.getId());
        List<Operation> opList = this.createOperations(cfg, entryEntity);
        this.ctrlAps.addAll(advConAps);
        this.ctrlAps.add((ControlAp<?>)entryAp);
        this.ctrlAps.addAll(entryFieldAps);
        this.entityItems.add((EntityItem<?>)entryEntity);
        this.entityItems.addAll(fields);
        this.operations.addAll(opList);
    }

    private List<ControlAp<?>> createAdvConAp(AdvConApCfg cfg) {
        ArrayList controlAps = new ArrayList(6);
        AdvConAp advConAp = new AdvConAp();
        advConAp.setId(cfg.getId());
        advConAp.setKey(cfg.getKey());
        advConAp.setName(cfg.getName());
        advConAp.setIndex(cfg.getIndex());
        if (null != cfg.getParentPanelId()) {
            advConAp.setParentId(cfg.getParentPanelId());
            advConAp.setCollapsible(false);
        } else {
            advConAp.setParentId(cfg.getParentId());
            advConAp.setCollapsible(true);
        }
        advConAp.setGrow(0);
        advConAp.setShrink(0);
        advConAp.setBackColor("#ffffff");
        Margin margin = new Margin();
        margin.setTop("10px");
        Style style = new Style();
        style.setMargin(margin);
        advConAp.setStyle(style);
        advConAp.setHidden(cfg.isHidden());
        controlAps.add((ControlAp<?>)advConAp);
        AdvConSummaryPanelAp summaryPanelAp = new AdvConSummaryPanelAp();
        summaryPanelAp.setId(cfg.getSummaryPanelId());
        summaryPanelAp.setKey(cfg.getSummaryPanelKey());
        summaryPanelAp.setName(cfg.getSummaryPanelName());
        summaryPanelAp.setParentId(advConAp.getId());
        controlAps.add((ControlAp<?>)summaryPanelAp);
        AdvConToolbarAp toolbarAp = new AdvConToolbarAp();
        toolbarAp.setId(cfg.getToolBarId());
        toolbarAp.setKey(cfg.getToolBarKey());
        toolbarAp.setName(cfg.getToolBarName());
        toolbarAp.setParentId(advConAp.getId());
        toolbarAp.setIndex(1);
        controlAps.add((ControlAp<?>)toolbarAp);
        AdvConChildPanelAp childPanelAp = new AdvConChildPanelAp();
        childPanelAp.setId(cfg.getChildPanelId());
        childPanelAp.setKey(cfg.getChildPanelKey());
        childPanelAp.setName(cfg.getChildPanelName());
        childPanelAp.setParentId(advConAp.getId());
        childPanelAp.setIndex(2);
        childPanelAp.setDirection("column");
        childPanelAp.setWrap(false);
        childPanelAp.setAlignItems("stretch");
        controlAps.add((ControlAp<?>)childPanelAp);
        AdvConBarItemAp tbNew = new AdvConBarItemAp();
        tbNew.setId(cfg.getTbNewId());
        tbNew.setKey(cfg.getTbNewKey());
        tbNew.setName(new LocaleString(ResManager.loadKDString((String)"\u589e\u884c", (String)"DynamicAdvContBuilder_0", (String)"fi-ai-common", (Object[])new Object[0])));
        tbNew.setOperationKey(cfg.getAddEntryOpKey());
        tbNew.setParentId(toolbarAp.getId());
        tbNew.setIndex(0);
        controlAps.add((ControlAp<?>)tbNew);
        AdvConBarItemAp tbDel = new AdvConBarItemAp();
        tbDel.setId(cfg.getTbDelId());
        tbDel.setKey(cfg.getTbDelKey());
        tbDel.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u884c", (String)"DynamicAdvContBuilder_1", (String)"fi-ai-common", (Object[])new Object[0])));
        tbDel.setOperationKey(cfg.getDelEntryOpKey());
        tbDel.setParentId(toolbarAp.getId());
        tbDel.setIndex(0);
        controlAps.add((ControlAp<?>)tbDel);
        return controlAps;
    }

    private EntryAp createEntryAp(AdvConApCfg cfg, List<ControlAp<?>> advConAps) {
        EntryAp entryAp = new EntryAp();
        entryAp.setId(cfg.getEntryId());
        entryAp.setKey(cfg.getEntryKey());
        entryAp.setName(cfg.getEntryName());
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setSplitPage(true);
        entryAp.setPageRow(20);
        for (ControlAp<?> controAp : advConAps) {
            if (!(controAp instanceof AdvConChildPanelAp)) continue;
            entryAp.setParentId(controAp.getId());
        }
        return entryAp;
    }

    private EntryEntity createEntryEntity(AdvConApCfg cfg, EntryAp entryAp) {
        String parentEntryId = cfg.getParentEntryId();
        if (StringUtils.isEmpty((CharSequence)parentEntryId)) {
            EntryEntity entryEntity = new EntryEntity();
            this.setEntryEntityInfo(cfg, entryAp, entryEntity);
            entryEntity.setParentId(this.entityMeta.getRootEntity().getId());
            return entryEntity;
        }
        SubEntryEntity subEntryEntity = new SubEntryEntity();
        this.setEntryEntityInfo(cfg, entryAp, (EntryEntity)subEntryEntity);
        subEntryEntity.setParentId(parentEntryId);
        subEntryEntity.setParentEntryId(parentEntryId);
        return subEntryEntity;
    }

    private void setEntryEntityInfo(AdvConApCfg cfg, EntryAp entryAp, EntryEntity entryEntity) {
        entryEntity.setId(entryAp.getId());
        entryAp.setEntryId(entryEntity.getId());
        entryEntity.setKey(entryAp.getKey());
        entryEntity.setName(entryAp.getName());
        entryEntity.setTableName(cfg.getEntryTableName());
    }

    private List<Operation> createOperations(AdvConApCfg cfg, EntryEntity entryEntity) {
        ArrayList<Operation> opList = new ArrayList<Operation>(2);
        Operation newEntry = new Operation();
        newEntry.setId(Uuid16.create().toString());
        newEntry.setKey(cfg.getAddEntryOpKey());
        newEntry.setName(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u5f55", (String)"DynamicAdvContBuilder_2", (String)"fi-ai-common", (Object[])new Object[0])));
        newEntry.setOperationType("newentry");
        EntryOpParameter newOpParam = new EntryOpParameter();
        newOpParam.setEntryId(entryEntity.getId());
        newEntry.setParameter((OperationParameter)newOpParam);
        opList.add(newEntry);
        Operation deleteEntry = new Operation();
        deleteEntry.setId(Uuid16.create().toString());
        deleteEntry.setKey(cfg.getDelEntryOpKey());
        deleteEntry.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664\u5206\u5f55", (String)"DynamicAdvContBuilder_3", (String)"fi-ai-common", (Object[])new Object[0])));
        deleteEntry.setOperationType("deleteentry");
        EntryOpParameter delOpParam = new EntryOpParameter();
        delOpParam.setEntryId(entryEntity.getId());
        deleteEntry.setParameter((OperationParameter)delOpParam);
        opList.add(deleteEntry);
        return opList;
    }

    protected void updateControlAp(AdvConApCfg cfg) throws InvocationTargetException, IllegalAccessException {
        AdvConAp advConAp = (AdvConAp)this.ctrlApsMap.get(cfg.getKey());
        EntryAp entryAp = (EntryAp)this.ctrlApsMap.get(cfg.getEntryKey());
        if (advConAp == null || entryAp == null) {
            EntryAp parent;
            String parentEntry = cfg.getParentEntryKey();
            if (StringUtils.isNotEmpty((CharSequence)parentEntry) && null != (parent = (EntryAp)this.ctrlApsMap.get(parentEntry))) {
                cfg.setParentEntryId(parent.getId());
                cfg.setParentPanelId(parent.getParentId());
            }
            this.addControlAp(cfg);
            return;
        }
        this.updateAdvConAp(cfg, advConAp, entryAp);
        List<BaseFieldApCfg> fieldCfgLi = cfg.getFieldCfgLi();
        List<BaseFieldApCfg> needAddFieldCfgLi = fieldCfgLi.stream().filter(p -> !this.ctrlApsMap.containsKey(p.getKey())).collect(Collectors.toList());
        this.ctrlAps.addAll(DynamicFormFieldBuilder.createEntryFieldAps(entryAp.getId(), needAddFieldCfgLi));
        this.entityItems.addAll(DynamicFormFieldBuilder.createFields(needAddFieldCfgLi, entryAp.getEntryId()));
        fieldCfgLi.removeAll(needAddFieldCfgLi);
        DynamicFormFieldBuilder.updateEntryFieldAps(fieldCfgLi, this.ctrlApsMap);
        DynamicFormFieldBuilder.updateField(fieldCfgLi, this.entityItemsMap);
    }

    private void updateAdvConAp(AdvConApCfg cfg, AdvConAp advConAp, EntryAp entryAp) {
        advConAp.setName(cfg.getName());
        advConAp.setIndex(cfg.getIndex());
        advConAp.setHidden(cfg.isHidden());
        entryAp.setName(cfg.getName());
    }

    protected void deleteControlAp(AdvConApCfg cfg, Set<String> fieldKeys, boolean self) {
        for (String fieldKey : fieldKeys) {
            this.ctrlAps.remove(this.ctrlApsMap.remove(fieldKey));
            this.entityItems.remove(this.entityItemsMap.remove(fieldKey));
        }
        if (self) {
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getSummaryPanelKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getToolBarKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getTbNewKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getTbDelKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getChildPanelKey()));
            this.ctrlAps.remove(this.ctrlApsMap.remove(cfg.getEntryKey()));
            this.entityItems.remove(this.entityItemsMap.remove(cfg.getEntryKey()));
            this.operations.removeIf(p -> p.getKey().equals(cfg.getAddEntryOpKey()) || p.getKey().equals(cfg.getDelEntryOpKey()));
        }
    }
}

