/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.util.bean.IDataBeanUtil;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.constant.enums.formbuilder.FeatureFormFieldsEnum;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseFieldApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.ListContainerFieldApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.prop.CustomFormFieldPropCfg;
import kd.fi.v2.fah.storage.impl.FormFieldFeatureCollection;

public class DynamicFormFieldBuilder {
    private static final Log logger = LogFactory.getLog(DynamicFormFieldBuilder.class);

    public static void createFields(Collection<BaseFieldApCfg> fieldConfigs, BiFunction<BaseFieldApCfg, Field<?>, Boolean> customizedFunction) throws InvocationTargetException, IllegalAccessException {
        if (fieldConfigs == null || customizedFunction == null) {
            return;
        }
        for (BaseFieldApCfg fieldCfg : fieldConfigs) {
            if (fieldCfg == null) continue;
            Field fieldController = (Field)IDataBeanUtil.getClassNewInstance((Class)fieldCfg.getFieldType().getFieldClass(), (Object[])new Object[0]);
            DynamicFormFieldBuilder.setFieldCommonProps(fieldCfg, fieldController, true);
            DynamicFormFieldBuilder.setFieldFeatures(fieldCfg, fieldController);
            if (fieldCfg.isContainerField() && fieldCfg instanceof ListContainerFieldApCfg) {
                DynamicFormFieldBuilder.setContainerFieldFeatures((ListContainerFieldApCfg)fieldCfg, fieldController);
            }
            if (customizedFunction.apply(fieldCfg, fieldController).booleanValue()) continue;
            break;
        }
    }

    public static List<Field<?>> createFields(Collection<BaseFieldApCfg> fieldConfigs, String parentControllerId) throws InvocationTargetException, IllegalAccessException {
        if (fieldConfigs == null) {
            return Collections.emptyList();
        }
        boolean needAddParentId = parentControllerId != null;
        LinkedList fields = new LinkedList();
        DynamicFormFieldBuilder.createFields(fieldConfigs, (BaseFieldApCfg config, Field<?> fieldController) -> {
            if (needAddParentId) {
                fieldController.setParentId(parentControllerId);
            }
            return fields.add((Field<?>)fieldController);
        });
        return fields;
    }

    public static List<Field<?>> createFields(Collection<BaseFieldApCfg> fieldConfigs) throws InvocationTargetException, IllegalAccessException {
        if (fieldConfigs == null) {
            return Collections.emptyList();
        }
        LinkedList fields = new LinkedList();
        DynamicFormFieldBuilder.createFields(fieldConfigs, (BaseFieldApCfg config, Field<?> fieldController) -> fields.add((Field<?>)fieldController));
        return fields;
    }

    public static List<FieldAp> createFieldAps(List<BaseFieldApCfg> fieldCfgLi, String parentId) {
        if (CollectionUtils.isEmpty(fieldCfgLi)) {
            return new ArrayList<FieldAp>(0);
        }
        ArrayList<FieldAp> fieldAps = new ArrayList<FieldAp>(fieldCfgLi.size());
        for (BaseFieldApCfg fieldApCfg : fieldCfgLi) {
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldApCfg.getId());
            fieldAp.setFieldId(fieldApCfg.getId());
            fieldAp.setKey(fieldApCfg.getKey());
            fieldAp.setParentId(parentId);
            DynamicFormFieldBuilder.setFieldApCommonProps(fieldAp, fieldApCfg);
            fieldAps.add(fieldAp);
        }
        return fieldAps;
    }

    public static void updateFieldAps(List<BaseFieldApCfg> fieldCfgLi, Map<String, ControlAp<?>> ctrlApsMap) {
        if (CollectionUtils.isEmpty(fieldCfgLi)) {
            return;
        }
        for (BaseFieldApCfg fieldApCfg : fieldCfgLi) {
            FieldAp fieldAp = (FieldAp)ctrlApsMap.get(fieldApCfg.getKey());
            if (fieldAp == null) continue;
            DynamicFormFieldBuilder.setFieldApCommonProps(fieldAp, fieldApCfg);
        }
    }

    public static boolean setFieldCommonProps(BaseFieldApCfg fieldCfg, Field<?> field, boolean asNewInstance) {
        if (fieldCfg == null || field == null) {
            return false;
        }
        if (asNewInstance) {
            field.setId(fieldCfg.getId());
            field.setKey(fieldCfg.getKey());
            field.setFieldName("f" + fieldCfg.getKey());
        }
        field.setName(fieldCfg.getName());
        return true;
    }

    public static boolean setContainerFieldFeatures(ListContainerFieldApCfg featureFieldApCfg, Field<?> field) throws InvocationTargetException, IllegalAccessException {
        if (featureFieldApCfg == null || field == null) {
            return false;
        }
        IDataBeanUtil.getInstance().setProperty(field, featureFieldApCfg.getContainerPropName(), featureFieldApCfg.getItems());
        return true;
    }

    public static boolean setFieldFeatures(BaseFieldApCfg featureFieldApCfg, Field<?> field) throws InvocationTargetException, IllegalAccessException {
        if (featureFieldApCfg == null || field == null || !featureFieldApCfg.hasFeatures()) {
            return false;
        }
        IDataBeanUtil beanUtil = IDataBeanUtil.getInstance();
        for (CustomFormFieldPropCfg fieldFeatureInfo : featureFieldApCfg.getFeatures()) {
            if (fieldFeatureInfo == null) continue;
            beanUtil.setProperty(field, fieldFeatureInfo.getFeatureName(), fieldFeatureInfo.getFeatureValue());
        }
        return true;
    }

    public static void createEntryFieldAps(String entryApId, Collection<BaseFieldApCfg> fieldApCfgs, BiFunction<BaseFieldApCfg, EntryFieldAp, Boolean> entryFieldProcFunc) {
        if (fieldApCfgs == null || entryFieldProcFunc == null) {
            return;
        }
        for (BaseFieldApCfg fieldApCfg : fieldApCfgs) {
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(fieldApCfg.getId());
            fieldAp.setFieldId(fieldAp.getId());
            fieldAp.setKey(fieldApCfg.getKey());
            fieldAp.setParentId(entryApId);
            DynamicFormFieldBuilder.setFieldApCommonProps((FieldAp)fieldAp, fieldApCfg);
            if (entryFieldProcFunc.apply(fieldApCfg, fieldAp).booleanValue()) continue;
            return;
        }
    }

    public static List<EntryFieldAp> createEntryFieldAps(String entryApId, Collection<BaseFieldApCfg> fieldApCfgs) {
        if (fieldApCfgs == null || fieldApCfgs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntryFieldAp> entryFieldAps = new ArrayList<EntryFieldAp>(fieldApCfgs.size());
        DynamicFormFieldBuilder.createEntryFieldAps(entryApId, fieldApCfgs, (cfg, field) -> entryFieldAps.add((EntryFieldAp)field));
        return entryFieldAps;
    }

    public static void updateField(List<BaseFieldApCfg> fieldCfgLi, Map<String, EntityItem<?>> entityItemsMap) {
        IDataBeanUtil beanUtil = IDataBeanUtil.getInstance();
        for (BaseFieldApCfg fieldCfg : fieldCfgLi) {
            EntityItem<?> field = entityItemsMap.get(fieldCfg.getKey());
            if (null == field) continue;
            for (CustomFormFieldPropCfg feature : fieldCfg.getFeatures()) {
                try {
                    beanUtil.setProperty(field, feature.getFeatureName(), feature.getFeatureValue());
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void updateEntryFieldAps(List<BaseFieldApCfg> fieldCfgs, Map<String, ControlAp<?>> ctrlApsMap) {
        if (CollectionUtils.isEmpty(fieldCfgs)) {
            return;
        }
        for (BaseFieldApCfg fieldApCfg : fieldCfgs) {
            EntryFieldAp fieldAp = (EntryFieldAp)ctrlApsMap.get(fieldApCfg.getKey());
            if (fieldAp == null) continue;
            DynamicFormFieldBuilder.setFieldApCommonProps((FieldAp)fieldAp, fieldApCfg);
        }
    }

    private static void setFieldApCommonProps(FieldAp fieldAp, BaseFieldApCfg fieldApCfg) {
        CustomFormFieldPropCfg fieldPropCfg;
        FormFieldFeatureCollection features;
        fieldAp.setName(fieldApCfg.getName());
        fieldAp.setIndex(fieldApCfg.getIndex());
        fieldAp.setVisible(fieldApCfg.getVisible());
        fieldAp.setLock(fieldApCfg.getLock());
        fieldAp.setHidden(fieldApCfg.isHidden());
        fieldAp.setTextAlign("left");
        if (fieldApCfg.getFieldType() == FeatureFormFieldsEnum.DateTimeFieldApCfg && null != (features = fieldApCfg.getFeatures()) && null != (fieldPropCfg = (CustomFormFieldPropCfg)features.get(FieldPropEnum.DATEFORMAT.getNumber()))) {
            fieldAp.setDisplayFormatString((String)fieldPropCfg.getFeatureValue());
        }
    }
}

