/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormFieldBuilder;
import kd.fi.v2.fah.formbuilder.containercfg.FieldsetPanelApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseControllerApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseFieldApCfg;

public class DynamicFormFieldsetPanelBuilder {
    private FormMetadata formMeta;
    private EntityMetadata entityMeta;
    List<ControlAp<?>> ctrlAps;
    List<EntityItem<?>> entityItems;
    private Map<String, ControlAp<?>> ctrlApsMap = new HashMap(16);
    private Map<String, EntityItem<?>> entityItemsMap = new HashMap(16);

    public DynamicFormFieldsetPanelBuilder(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.init(formMeta, entityMeta);
    }

    private void init(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.formMeta = formMeta;
        this.entityMeta = entityMeta;
        this.ctrlAps = this.formMeta.getItems();
        this.entityItems = this.entityMeta.getItems();
        for (ControlAp<?> controlAp : this.ctrlAps) {
            this.ctrlApsMap.put(controlAp.getKey(), controlAp);
        }
        for (EntityItem entityItem : this.entityItems) {
            this.entityItemsMap.put(entityItem.getKey(), entityItem);
        }
    }

    protected void addControlAp(FieldsetPanelApCfg panelApCfg) throws InvocationTargetException, IllegalAccessException {
        List<BaseFieldApCfg> fieldCfgLi = panelApCfg.getFieldCfgLi();
        if (panelApCfg.isPreset()) {
            ControlAp<?> panelAp = this.ctrlApsMap.get(panelApCfg.getKey());
            this.updateFieldsetPanelAp(panelApCfg, (FieldsetPanelAp)panelAp);
            List<BaseFieldApCfg> presetFieldCfgLi = fieldCfgLi.stream().filter(BaseControllerApCfg::isPreset).collect(Collectors.toList());
            DynamicFormFieldBuilder.updateFieldAps(presetFieldCfgLi, this.ctrlApsMap);
            fieldCfgLi.removeAll(presetFieldCfgLi);
        } else {
            this.ctrlAps.add((ControlAp<?>)this.createFieldsetPanelAp(panelApCfg));
        }
        this.ctrlAps.addAll(DynamicFormFieldBuilder.createFieldAps(fieldCfgLi, panelApCfg.getId()));
        this.entityItems.addAll(DynamicFormFieldBuilder.createFields(fieldCfgLi));
    }

    protected void updateControlAp(FieldsetPanelApCfg panelApCfg) throws InvocationTargetException, IllegalAccessException {
        FieldsetPanelAp panelAp = (FieldsetPanelAp)this.ctrlApsMap.get(panelApCfg.getKey());
        if (panelAp == null) {
            this.addControlAp(panelApCfg);
            return;
        }
        this.updateFieldsetPanelAp(panelApCfg, panelAp);
        List<BaseFieldApCfg> fieldCfgLi = panelApCfg.getFieldCfgLi();
        Set<String> ctrlApKeys = this.ctrlApsMap.keySet();
        List<BaseFieldApCfg> needAddFieldCfgLi = fieldCfgLi.stream().filter(p -> !ctrlApKeys.contains(p.getKey())).collect(Collectors.toList());
        this.ctrlAps.addAll(DynamicFormFieldBuilder.createFieldAps(needAddFieldCfgLi, panelAp.getId()));
        this.entityItems.addAll(DynamicFormFieldBuilder.createFields(needAddFieldCfgLi));
        fieldCfgLi.removeAll(needAddFieldCfgLi);
        DynamicFormFieldBuilder.updateFieldAps(fieldCfgLi, this.ctrlApsMap);
        DynamicFormFieldBuilder.updateField(fieldCfgLi, this.entityItemsMap);
    }

    protected void deleteField(String groupKey, Set<String> fieldKeys, boolean deleteGroup) {
        for (String fieldKey : fieldKeys) {
            this.ctrlAps.remove(this.ctrlApsMap.remove(fieldKey));
            this.entityItems.remove(this.entityItemsMap.remove(fieldKey));
        }
        if (deleteGroup) {
            this.ctrlAps.remove(this.ctrlApsMap.remove(groupKey));
        }
    }

    private FieldsetPanelAp createFieldsetPanelAp(FieldsetPanelApCfg panelApCfg) {
        FieldsetPanelAp panel = new FieldsetPanelAp();
        panel.setId(panelApCfg.getId());
        panel.setKey(panelApCfg.getKey());
        panel.setName(panelApCfg.getName());
        panel.setParentId(panelApCfg.getParentId());
        panel.setIndex(panelApCfg.getIndex());
        panel.setCollapsible(true);
        panel.setBackColor("#ffffff");
        Margin margin = new Margin();
        margin.setTop("10px");
        Style style = new Style();
        style.setMargin(margin);
        panel.setStyle(style);
        panel.setGrow(0);
        panel.setShrink(0);
        panel.setHidden(panelApCfg.isHidden());
        return panel;
    }

    private void updateFieldsetPanelAp(FieldsetPanelApCfg panelApCfg, FieldsetPanelAp panelAp) {
        panelAp.setName(panelApCfg.getName());
        panelAp.setIndex(panelApCfg.getIndex());
        panelAp.setHidden(panelApCfg.isHidden());
    }
}

