/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.AppUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.formbuilder.DynamicFormConfig;
import kd.fi.v2.fah.formbuilder.builder.DynamicAdvContBuilder;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormFieldsetPanelBuilder;
import kd.fi.v2.fah.formbuilder.containercfg.AdvConApCfg;
import kd.fi.v2.fah.formbuilder.containercfg.ContainerApCfg;
import kd.fi.v2.fah.formbuilder.containercfg.FieldsetPanelApCfg;
import kd.fi.v2.fah.models.modeling.base.AbstractBasePropModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelDiff;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;

public class DynamicFormModelBuilder {
    private static final Log log = LogFactory.getLog(DynamicFormModelBuilder.class);
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String FORMID = "formid";
    private static final String FORMNAME = "formname";
    private static final String DUPLICATEENTRY = "Duplicate entry";
    private static final String FI_AI_COMMON = "fi-ai-common";

    public static Map<String, Object> createDynamicForm(DynamicFormConfig formConfig) throws InvocationTargetException, IllegalAccessException {
        Throwable throwable;
        TXHandle tx;
        HashMap<String, Object> message;
        String formName;
        Map<String, Object> metaDataMap;
        block23: {
            HashMap<String, Object> hashMap;
            block24: {
                block25: {
                    if (formConfig == null) {
                        return null;
                    }
                    metaDataMap = DynamicFormModelBuilder.buildDesignFormMetaDataMap(formConfig, "33W3M7KO+8N8");
                    formName = formConfig.getFormName().getLocaleValue_zh_CN();
                    message = new HashMap<String, Object>(8);
                    message.put(SUCCESS, Boolean.TRUE);
                    message.put(FORMNAME, formName);
                    message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f", (String)"DynamicFormModelBuilder_0", (String)FI_AI_COMMON, (Object[])new Object[0]));
                    tx = TX.requiresNew();
                    throwable = null;
                    Map save = new DesignerData().save(metaDataMap);
                    if (save.get(SUCCESS) == null || ((Boolean)save.get(SUCCESS)).booleanValue() || save.get(ERRORS) == null) break block23;
                    message.put(SUCCESS, Boolean.FALSE);
                    ArrayList errorInfos = (ArrayList)save.get(ERRORS);
                    StringBuilder msg = new StringBuilder();
                    if (null != errorInfos) {
                        for (int i = 0; i < errorInfos.size(); ++i) {
                            msg.append(i + 1).append(".").append(((ErrorInfo)errorInfos.get(i)).getError());
                        }
                    }
                    message.put(MESSAGE, msg.toString());
                    hashMap = message;
                    if (tx == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                tx.close();
            }
            return hashMap;
        }
        try {
            try {
                String formId = (String)metaDataMap.get("id");
                message.put(FORMID, formId);
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"DynamicFormModelBuilder_1", (String)FI_AI_COMMON, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u52a8\u6001\u521b\u5efa\u5355\u636e\u201c%s\u201d\u5143\u6a21\u578b", (String)"DynamicFormModelBuilder_2", (String)FI_AI_COMMON, (Object[])new Object[0]), formName));
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
                dObject.set(BIZAPP, (Object)formConfig.getBizAppId());
                dObject.set(BIZUNIT, (Object)FormBuilderConstant.BIZ_UNIT_ID);
                dObject.set("form", (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"DynamicFormModelBuilder_1", (String)FI_AI_COMMON, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"DynamicFormModelBuilder_3", (String)FI_AI_COMMON, (Object[])new Object[0]));
            }
            catch (NullPointerException exception) {
                log.error((Throwable)exception);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5143\u6a21\u578b\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe", (String)"DynamicFormModelBuilder_4", (String)FI_AI_COMMON, (Object[])new Object[0]), formName);
                if (msg.contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u8868\u5355\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a\u201c%2$s\u201d\u3002", (String)"DynamicFormModelBuilder_5", (String)FI_AI_COMMON, (Object[])new Object[0]), formConfig.getFormNumber(), msg);
                }
                message.put(MESSAGE, msg);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = e.getMessage();
                if (e.getMessage().contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u8868\u5355\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a\u201c%2$s\u201d\u3002", (String)"DynamicFormModelBuilder_5", (String)FI_AI_COMMON, (Object[])new Object[0]), formConfig.getFormNumber(), msg);
                }
                message.put(MESSAGE, msg);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return message;
    }

    protected static String getInheritPath(FormMetadata formMeta, String templateFormId) {
        String inheritPath = formMeta.getInheritPath();
        return kd.bos.util.StringUtils.isNotEmpty((String)inheritPath) ? inheritPath + ',' + templateFormId : templateFormId;
    }

    protected static void setInheritFlag(List<? extends AbstractElement> elements) {
        if (elements != null) {
            elements.forEach(e -> e.setInherit(true));
        }
    }

    private static void createControl(FormMetadata formMeta, EntityMetadata entityMetadata, Collection<ContainerApCfg> containerCfgLi) throws InvocationTargetException, IllegalAccessException {
        DynamicFormFieldsetPanelBuilder fieldPanelApBuilder = new DynamicFormFieldsetPanelBuilder(formMeta, entityMetadata);
        DynamicAdvContBuilder dynamicAdvContBuilder = new DynamicAdvContBuilder(formMeta, entityMetadata);
        for (ContainerApCfg cfg : containerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.addControlAp((FieldsetPanelApCfg)cfg);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            dynamicAdvContBuilder.addControlAp((AdvConApCfg)cfg);
        }
    }

    public static FormMetadata loadRuntimeMeta(String templateFormId) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)templateFormId, (MetaCategory)MetaCategory.Form);
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setParentId(templateFormId);
        formMeta.setModelType("BillFormModel");
        formMeta.setDevType("0");
        formMeta.setInheritPath(DynamicFormModelBuilder.getInheritPath(formMeta, templateFormId));
        DynamicFormModelBuilder.setInheritFlag(formMeta.getItems());
        return formMeta;
    }

    @Deprecated
    public static FormMetadata loadRuntimeMeta() {
        return DynamicFormModelBuilder.loadRuntimeMeta("33W3M7KO+8N8");
    }

    public static Map<String, Object> buildDesignFormMetaDataMap(DynamicFormConfig formConfig, String formParentId) throws InvocationTargetException, IllegalAccessException {
        String appId = formConfig.getBizAppId();
        LocaleString formName = formConfig.getFormName();
        String formNumber = formConfig.getFormNumber();
        FormMetadata formMeta = DynamicFormModelBuilder.loadRuntimeMeta(formParentId);
        formMeta.setName(formName);
        formMeta.setKey(formNumber);
        formMeta.setBizappId(appId);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        MainEntity mainEntity = entityMeta.getRootEntity();
        entityMeta.setId(formMeta.getId());
        entityMeta.setParentId(formParentId);
        entityMeta.setModelType("BillFormModel");
        mainEntity.setTemplate(false);
        ((BillEntity)mainEntity).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        entityMeta.setName(formName);
        entityMeta.setKey(formNumber);
        mainEntity.setKey(formNumber);
        mainEntity.setTableName(formConfig.getTableName());
        mainEntity.setdbRoute(formConfig.getDBRoute());
        entityMeta.setBizappId(appId);
        DynamicFormModelBuilder.setInheritFlag(entityMeta.getItems());
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityMeta.getId());
        formMeta.setBuildContext(new MetaBuildContext());
        DynamicFormModelBuilder.createControl(formMeta, entityMeta, formConfig.getContainers());
        String currentIsv = formConfig.getCurrentIsv();
        entityMeta.setIsv(currentIsv);
        formMeta.setIsv(currentIsv);
        return formMeta.buildDesignMeta(RequestContext.get().getLang().name());
    }

    public static Map<String, Object> updateDynamicForm(DynamicFormConfig formConfig, DataModelDiff dataModelDiff) throws InvocationTargetException, IllegalAccessException {
        String formNumber_;
        Map saveMsg = null;
        String formName = formConfig.getFormName().getLocaleValue_zh_CN();
        String formId = formConfig.getFormId();
        if (kd.bos.util.StringUtils.isEmpty((String)formId)) {
            saveMsg = DynamicFormModelBuilder.createDynamicForm(formConfig);
            log.warn("\u4fee\u6539\u5355\u636e\u3010" + formName + "\u3011\u5143\u6570\u636e\u5f02\u5e38\uff0c \u5355\u636e\u5143\u6570\u636e\u4e0d\u5b58\u5728\u91cd\u65b0\u521b\u5efa\u4e00\u4e2a");
            return saveMsg;
        }
        String formNumber = formConfig.getFormNumber();
        if (!StringUtils.equals((CharSequence)formNumber, (CharSequence)(formNumber_ = MetadataDao.getNumberById((String)formId)))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u5143\u6570\u636e\u6a21\u578b\u6807\u8bc6\u201c%2$s\u201d\u88ab\u7be1\u6539\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u5e73\u53f0\u624b\u52a8\u6539\u56de\uff1a%3$s\u3002", (String)"DynamicFormModelBuilder_6", (String)FI_AI_COMMON, (Object[])new Object[0]), formNumber, formNumber_, formNumber));
        }
        String lang = RequestContext.get().getLang().name();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        Map oldMetaDataMap = formMeta.buildDesignMeta(lang);
        formMeta.setName(formConfig.getFormName());
        entityMeta.setName(formConfig.getFormName());
        if (null != dataModelDiff) {
            DynamicFormModelBuilder.deleteControl(formConfig, formMeta, entityMeta, dataModelDiff);
            DynamicFormModelBuilder.updateTable(formConfig, dataModelDiff);
        }
        DynamicFormModelBuilder.updateControl(formMeta, entityMeta, formConfig.getContainerCfgs().values());
        formMeta.bindEntityMetadata(entityMeta);
        Map metaDataMap = formMeta.buildDesignMeta(lang);
        try (TXHandle h = TX.requiresNew();){
            try {
                saveMsg = new DesignerData().save(metaDataMap, oldMetaDataMap);
            }
            catch (Exception e) {
                h.markRollback();
                log.error("\u3010" + formName + "\u3011\u4fdd\u5b58\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
        if (saveMsg.get(SUCCESS) != null && !((Boolean)saveMsg.get(SUCCESS)).booleanValue() && saveMsg.get(ERRORS) != null) {
            saveMsg.put(SUCCESS, Boolean.FALSE);
            saveMsg.put(MESSAGE, ((ErrorInfo)((ArrayList)saveMsg.get(ERRORS)).get(0)).getError());
            return saveMsg;
        }
        AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"DynamicFormModelBuilder_7", (String)FI_AI_COMMON, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u52a8\u6001\u4fee\u6539\u5355\u636e\u201c%s\u201d\u5143\u6a21\u578b", (String)"DynamicFormModelBuilder_8", (String)FI_AI_COMMON, (Object[])new Object[0]), formName));
        saveMsg.put(FORMID, formId);
        saveMsg.put(FORMNAME, formName);
        return saveMsg;
    }

    private static void updateControl(FormMetadata formMeta, EntityMetadata entityMetadata, Collection<ContainerApCfg> containerCfgLi) throws InvocationTargetException, IllegalAccessException {
        DynamicFormFieldsetPanelBuilder fieldPanelApBuilder = new DynamicFormFieldsetPanelBuilder(formMeta, entityMetadata);
        DynamicAdvContBuilder dynamicAdvContBuilder = new DynamicAdvContBuilder(formMeta, entityMetadata);
        for (ContainerApCfg cfg : containerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.updateControlAp((FieldsetPanelApCfg)cfg);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            dynamicAdvContBuilder.updateControlAp((AdvConApCfg)cfg);
        }
    }

    private static void updateTable(DynamicFormConfig formConfig, DataModelDiff dataModelDiff) {
        if (null == dataModelDiff || null == dataModelDiff.getModifiedCfgs()) {
            return;
        }
        Set<String> lengthUpdateNumbers = dataModelDiff.getMaxLengthUpdateNumber();
        if (null == lengthUpdateNumbers || lengthUpdateNumbers.isEmpty()) {
            return;
        }
        BaseMutableArrayMapStorage modifiedCfgs = (BaseMutableArrayMapStorage)dataModelDiff.getModifiedCfgs().getCollections();
        if (null == modifiedCfgs || modifiedCfgs.isEmpty()) {
            return;
        }
        HashMap<String, List> needUpdateFieldMap = new HashMap<String, List>();
        for (DataModelFieldCollection fieldCfg : modifiedCfgs) {
            BaseMutableArrayMapStorage fields = (BaseMutableArrayMapStorage)fieldCfg.getCollections();
            if (null == fields || fields.isEmpty()) continue;
            DefaultDataFieldGroupEnum groupType = fieldCfg.getGroupType();
            boolean isHeadField = DefaultDataFieldGroupEnum.SYSTEM == groupType || DefaultDataFieldGroupEnum.HEAD == groupType;
            block1: for (DataModelFieldCfg field : fields) {
                if (!lengthUpdateNumbers.contains(field.getNumber()) || DataValueTypeEnum.String != field.getDataType()) continue;
                for (DataModelFieldPropCfg prop : field.getProps()) {
                    if (!FieldPropEnum.MAXLENGTH.getNumber().equals(prop.getName()) || null == prop.getPropValue()) continue;
                    String tableName = isHeadField ? formConfig.getTableName() : fieldCfg.getTableName();
                    if (null == tableName) continue block1;
                    needUpdateFieldMap.computeIfAbsent(tableName, t -> new ArrayList()).add(new PairTuple((Object)field.getNumber(), (Object)Integer.parseInt(String.valueOf(prop.getPropValue()))));
                    continue block1;
                }
            }
        }
        if (!needUpdateFieldMap.isEmpty()) {
            DBRoute dbRoute = DBRoute.of((String)formConfig.getDBRoute());
            for (Map.Entry entry : needUpdateFieldMap.entrySet()) {
                String tableName = (String)entry.getKey();
                List<String> columnNames = DataModelDaoImpl.getColumn(dbRoute, tableName);
                if (null == columnNames || columnNames.isEmpty()) continue;
                HashSet<String> columnNameSet = new HashSet<String>(columnNames);
                for (PairTuple field : (List)entry.getValue()) {
                    String fieldNumber = "f" + (String)field.getKey();
                    if (!columnNameSet.contains(fieldNumber)) continue;
                    DataModelDaoImpl.updateFieldLength(dbRoute, tableName, fieldNumber, (Integer)field.getValue());
                }
            }
        }
    }

    private static void deleteControl(DynamicFormConfig formConfig, FormMetadata formMeta, EntityMetadata entityMetadata, DataModelDiff dataModelDiff) {
        if (null == dataModelDiff || null == dataModelDiff.getDeletedCfgs()) {
            return;
        }
        BaseMutableArrayMapStorage dataModelFieldCollection = (BaseMutableArrayMapStorage)dataModelDiff.getDeletedCfgs().getCollections();
        if (null == dataModelFieldCollection || dataModelFieldCollection.isEmpty()) {
            return;
        }
        HashSet<String> needDelHeadFields = new HashSet<String>(8);
        HashSet<String> needDelEntryTables = new HashSet<String>(8);
        HashMap<String, List> needDelEntryFieldMap = new HashMap<String, List>();
        DynamicFormFieldsetPanelBuilder fieldPanelApBuilder = new DynamicFormFieldsetPanelBuilder(formMeta, entityMetadata);
        DynamicAdvContBuilder advContBuilder = new DynamicAdvContBuilder(formMeta, entityMetadata);
        for (DataModelFieldCollection fieldCfg : dataModelFieldCollection) {
            Object field22;
            String longNumber = fieldCfg.getNumber();
            String number = DataModelUtils.getNumber(longNumber);
            DefaultDataFieldGroupEnum defaultDataFieldGroupEnum = fieldCfg.getGroupType();
            BaseMutableArrayMapStorage fields = (BaseMutableArrayMapStorage)fieldCfg.getCollections();
            if (DefaultDataFieldGroupEnum.HEAD == defaultDataFieldGroupEnum) {
                if (null == fields || fields.isEmpty()) {
                    Set<String> needDelFields = DataModelDaoImpl.getDeletedGroupFields(dataModelDiff.getModelId(), longNumber);
                    needDelHeadFields.addAll(needDelFields);
                    fieldPanelApBuilder.deleteField(number, needDelFields, true);
                    continue;
                }
                HashSet<String> fieldKeys = new HashSet<String>();
                for (Object field22 : fields) {
                    fieldKeys.add(((AbstractBasePropModelCfg)field22).getNumber());
                }
                needDelHeadFields.addAll(fieldKeys);
                fieldPanelApBuilder.deleteField(number, fieldKeys, false);
                continue;
            }
            if (DefaultDataFieldGroupEnum.ENTRY != defaultDataFieldGroupEnum) continue;
            AdvConApCfg advConApCfg = new AdvConApCfg();
            advConApCfg.setKey(number.toLowerCase());
            if (null == fields || fields.isEmpty()) {
                Set<String> needDelFields = DataModelDaoImpl.getDeletedGroupFields(dataModelDiff.getModelId(), longNumber);
                advContBuilder.deleteControlAp(advConApCfg, needDelFields, true);
                needDelEntryTables.add(fieldCfg.getTableName());
                continue;
            }
            HashSet<String> fieldKeys = new HashSet<String>();
            field22 = fields.iterator();
            while (field22.hasNext()) {
                DataModelFieldCfg field3 = (DataModelFieldCfg)field22.next();
                fieldKeys.add(field3.getNumber());
                needDelEntryFieldMap.computeIfAbsent(fieldCfg.getTableName(), t -> new ArrayList()).add(field3.getNumber());
            }
            advContBuilder.deleteControlAp(advConApCfg, fieldKeys, false);
        }
        DBRoute dbRoute = DBRoute.of((String)formConfig.getDBRoute());
        List columns = DB.getColumnNames((DBRoute)dbRoute, (String)formConfig.getTableName());
        HashSet columnSet = new HashSet(columns);
        for (String string : needDelHeadFields) {
            String string2 = "f" + string;
            if (!columnSet.contains(string2)) continue;
            DataModelDaoImpl.dropFields(dbRoute, formConfig.getTableName(), string2);
        }
        if (!needDelEntryTables.isEmpty()) {
            DataModelDaoImpl.dropTable(dbRoute, needDelEntryTables);
        }
        for (Map.Entry entry : needDelEntryFieldMap.entrySet()) {
            String tableName = (String)entry.getKey();
            List<String> columnNames = DataModelDaoImpl.getColumn(dbRoute, tableName);
            if (null == columnNames || columnNames.isEmpty()) continue;
            for (String field : (List)entry.getValue()) {
                field = "f" + field;
                if (!columnNames.contains(field)) continue;
                DataModelDaoImpl.dropFields(dbRoute, tableName, field);
            }
        }
    }

    public static Map<String, Object> deleteBillFormModel(DynamicFormConfig formConfig, boolean formalData) {
        Map<String, Object> delMsg = new HashMap<String, Object>(2);
        String formNumber = formConfig.getFormNumber();
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        if (kd.bos.util.StringUtils.isEmpty((String)formId) || !MetadataDao.checkNumber((String)formNumber)) {
            log.info("\u5355\u636e\u3010" + formNumber + "\u3011\u5143\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
            delMsg.put(SUCCESS, Boolean.TRUE);
            delMsg.put(MESSAGE, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5355\u636e\u5143\u6570\u636e\u6a21\u578b", (String)"DynamicFormModelBuilder_9", (String)FI_AI_COMMON, (Object[])new Object[0]));
            return delMsg;
        }
        if (Boolean.TRUE.equals(formalData)) {
            HashSet<String> tables = new HashSet<String>(8);
            tables.add(formConfig.getTableName());
            for (ContainerApCfg cfg : formConfig.getContainerCfgs().values()) {
                if (!(cfg instanceof AdvConApCfg)) continue;
                tables.add(((AdvConApCfg)cfg).getEntryTableName());
            }
            if (DataModelDaoImpl.existsBizData(tables, DBRoute.of((String)formConfig.getDBRoute()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u7981\u6b62\u5220\u9664\u5143\u6570\u636e\u6a21\u578b\u3002", (String)"DynamicFormModelBuilder_10", (String)FI_AI_COMMON, (Object[])new Object[0]));
            }
        }
        QFilter f1 = new QFilter(BIZUNIT, "=", (Object)FormBuilderConstant.BIZ_UNIT_ID);
        QFilter f2 = new QFilter("form", "=", (Object)formId);
        DynamicObject funcUnitDynObj = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"id", (QFilter[])new QFilter[]{f1, f2});
        DynamicObject recycleDynObj = DevportalUtil.createRecycleBinFormData((String)formId, (String)ResManager.loadKDString((String)"\u5220\u9664\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u8868\u5355\u5143\u6570\u636e", (String)"DynamicFormModelBuilder_11", (String)FI_AI_COMMON, (Object[])new Object[0]));
        try (TXHandle h = TX.requiresNew();){
            try {
                if (funcUnitDynObj != null) {
                    String pkId = funcUnitDynObj.getString("id");
                    Object[] pkIds = new String[]{pkId};
                    MainEntityType met = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_UNITRELFORM);
                    DeleteServiceHelper.delete((IDataEntityType)met, (Object[])pkIds);
                    AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"DynamicFormModelBuilder_12", (String)FI_AI_COMMON, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"DynamicFormModelBuilder_13", (String)FI_AI_COMMON, (Object[])new Object[0]));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recycleDynObj});
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"DynamicFormModelBuilder_12", (String)FI_AI_COMMON, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5c06\u5220\u9664\u7684\u8868\u5355\u5b58\u5165\u56de\u6536\u7ad9\u3002", (String)"DynamicFormModelBuilder_14", (String)FI_AI_COMMON, (Object[])new Object[0]));
                delMsg = MetadataDao.delFormMetadata((String)formId);
            }
            catch (Exception e) {
                h.markRollback();
                log.error("\u5220\u9664\u5355\u636e\u3010" + formNumber + "\u3011\u5143\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
                log.error("\u5220\u9664\u5355\u636e\u3010" + formNumber + "\u3011\u5143\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
        return delMsg;
    }
}

