/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.fieldcfg;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.bos.entity.property.RefProp;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.fi.v2.fah.constant.enums.formbuilder.FeatureFormFieldsEnum;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseFieldApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.prop.CustomFormFieldPropCfg;

public class ListContainerFieldApCfg<T>
extends BaseFieldApCfg {
    protected String containerPropName;
    protected List<T> items;

    public ListContainerFieldApCfg(FeatureFormFieldsEnum fieldType, CustomFormFieldPropCfg ... features) {
        super(fieldType, features);
        this.containerPropName = fieldType.getContainerPropName();
    }

    @Override
    public boolean isContainerField() {
        return true;
    }

    public List<T> getItems() {
        return this.items;
    }

    public String getContainerPropName() {
        return this.containerPropName;
    }

    protected List<T> createListContainer() {
        return new LinkedList();
    }

    public static ListContainerFieldApCfg<ComboItem> getComboFieldCfg(CustomFormFieldPropCfg ... features) {
        return new ListContainerFieldApCfg<ComboItem>(FeatureFormFieldsEnum.ComboFieldApCfg, new CustomFormFieldPropCfg[0]);
    }

    public static ListContainerFieldApCfg<RefProp> getBaseDataFieldCfg(CustomFormFieldPropCfg ... features) {
        return new ListContainerFieldApCfg<RefProp>(FeatureFormFieldsEnum.BasedataFieldApCfg, new CustomFormFieldPropCfg[0]);
    }

    public ListContainerFieldApCfg addItems(T ... srcItems) {
        int length;
        if (srcItems != null && (length = srcItems.length) > 0) {
            if (this.items == null) {
                this.items = this.createListContainer();
            }
            if (length == 1) {
                this.items.add(srcItems[0]);
            } else {
                this.items.addAll(Arrays.asList(srcItems));
            }
        }
        return this;
    }

    public void clearItems() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public void setContainerPropName(String containerPropName) {
        this.containerPropName = containerPropName;
    }
}

