/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.iterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.fi.v2.fah.iterator.IntArraySequenceIterator;

public class IntArraySequenceIteratorBuilder {
    private List<MemberStep> _stepItems;
    public static final IntArraySequenceIterator EMPTY_Iterator = new EmptyIntArraySequenceIterator();

    public IntArraySequenceIteratorBuilder() {
        this.clear();
    }

    public IntArraySequenceIteratorBuilder(int itemCnt) {
        this._stepItems = new ArrayList<MemberStep>(itemCnt);
    }

    public final void reset() {
        if (this._stepItems != null) {
            this._stepItems.clear();
        }
    }

    private void clear() {
        this._stepItems = new ArrayList<MemberStep>();
    }

    public IntArraySequenceIteratorBuilder addFixedValue(int index, Object value) {
        this._stepItems.add(new SingleValueStep(index, value));
        return this;
    }

    public IntArraySequenceIteratorBuilder setFixedValue(int index, Object value) {
        this._stepItems.set(index, new SingleValueStep(index, value));
        return this;
    }

    public IntArraySequenceIteratorBuilder setRangeValue(int index, int start, int end, boolean forward) {
        if (end == start) {
            this.setFixedValue(index, start);
        } else if (forward) {
            this._stepItems.set(index, new ForwardRangeStep(index, start, end));
        } else {
            this._stepItems.set(index, new BackwardRangeStep(index, start, end));
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder addRangeValue(int start, int end, boolean forward) {
        if (end == start) {
            this.addFixedValue(this._stepItems.size(), start);
        } else if (forward) {
            this._stepItems.add(new ForwardRangeStep(this._stepItems.size(), start, end));
        } else {
            this._stepItems.add(new BackwardRangeStep(this._stepItems.size(), start, end));
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder setArrayValue(int index, Object[] values) {
        if (values.length == 1) {
            this.setFixedValue(index, values[0]);
        } else {
            this._stepItems.set(index, new ArrayStep(index, values));
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder addArrayValue(Object[] values) {
        if (values.length == 1) {
            this.addFixedValue(this._stepItems.size(), values[0]);
        } else {
            this._stepItems.add(new ArrayStep(this._stepItems.size(), values));
        }
        return this;
    }

    public IntArraySequenceIterator build() {
        if (this._stepItems == null || this._stepItems.isEmpty()) {
            return EMPTY_Iterator;
        }
        int _stepItemCnt = this._stepItems.size();
        ArrayList<MemberStep> bufList = new ArrayList<MemberStep>(_stepItemCnt);
        Object[] resultArray = new Object[_stepItemCnt];
        int lastValidStep = -1;
        for (int i = 0; i < _stepItemCnt; ++i) {
            MemberStep step = this._stepItems.get(i);
            if (step == null) continue;
            if (i < _stepItemCnt - 1) {
                if (step instanceof SingleValueStep) {
                    resultArray[step.writePos] = ((SingleValueStep)step).getSingleValue();
                    continue;
                }
                step = step.copy();
                step.setResultArray(resultArray);
                step.next();
                lastValidStep = i;
                bufList.add(step);
                continue;
            }
            if (step instanceof SingleValueStep) {
                if (lastValidStep >= 0) {
                    ((MemberStep)bufList.get(bufList.size() - 1)).reset();
                }
                resultArray[step.writePos] = ((SingleValueStep)step).getSingleValue();
                continue;
            }
            step = step.copy();
            step.setResultArray(resultArray);
            bufList.add(step);
        }
        if (bufList.isEmpty()) {
            return new SingleStepSequenceIterator(resultArray);
        }
        return new IntArraySequenceIterator(bufList.toArray(new MemberStep[0]), resultArray);
    }

    public class ArrayStep
    extends MemberStep {
        private static final long serialVersionUID = 2159742806875910172L;
        private Object[] values;
        private int end;

        public ArrayStep(int writePos, Object[] values) {
            super(writePos);
            this.values = values;
            if (values.length <= 0) {
                throw new IllegalArgumentException();
            }
            this.end = values.length - 1;
            this.currentIndex = 0;
        }

        @Override
        public String toString() {
            return "ArrayStep [values=" + Arrays.toString(this.values) + ", end=" + this.end + ", currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        @Override
        public void reset() {
            this.setResultValue(this.values[0]);
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex <= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex <= this.end) {
                this.setResultValue(this.values[this.currentIndex]);
                ++this.currentIndex;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        public ArrayStep copy() {
            ArrayStep newCopy = new ArrayStep(this.writePos, this.values);
            newCopy.setResultArray(this.resultArray);
            return newCopy;
        }

        @Override
        public int getMemberCnt() {
            return this.values == null ? 0 : this.values.length;
        }

        public Object[] getValues() {
            return this.values;
        }
    }

    class BackwardRangeStep
    extends ForwardRangeStep {
        private static final long serialVersionUID = 7469249027580339266L;

        public BackwardRangeStep(int writePos, int start, int end, int step) {
            super(writePos, start, end, step);
        }

        public BackwardRangeStep(int writePos, int start, int end) {
            this(writePos, start, end, 1);
        }

        @Override
        protected void validateRange() {
            if (this.start < this.end) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex >= this.end) {
                this.setResultValue(this.currentIndex);
                this.currentIndex -= this.stepSize;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex > this.start ? this.start : this.currentIndex;
        }

        @Override
        public BackwardRangeStep copy() {
            return new BackwardRangeStep(this.writePos, this.start, this.end, this.stepSize);
        }

        @Override
        public int getMemberCnt() {
            return this.start - this.end + 1;
        }
    }

    class ForwardRangeStep
    extends MemberStep {
        private static final long serialVersionUID = 6451176381642209621L;
        protected int start;
        protected int end;
        protected int stepSize;

        protected ForwardRangeStep(int writePos, int start, int end, int step) {
            super(writePos);
            this.start = start;
            this.end = end;
            this.stepSize = step;
            if (start > end) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String toString() {
            return "ForwardRangeStep [start=" + this.start + ", end=" + this.end + ", stepSize=" + this.stepSize + ", currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        @Override
        public final void reset() {
            this.setResultValue(this.start);
            this.currentIndex = this.start;
        }

        public ForwardRangeStep(int writePos, int start, int end) {
            this(writePos, start, end, 1);
        }

        protected void validateRange() {
            if (this.start > this.end) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex <= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex <= this.end) {
                this.setResultValue(this.currentIndex);
                this.currentIndex += this.stepSize;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex < this.start ? this.start : this.currentIndex;
        }

        public ForwardRangeStep copy() {
            ForwardRangeStep newCopy = new ForwardRangeStep(this.writePos, this.start, this.end, this.stepSize);
            newCopy.setResultArray(this.resultArray);
            return newCopy;
        }

        @Override
        public int getMemberCnt() {
            return this.end - this.start + 1;
        }
    }

    class SingleValueStep
    extends MemberStep {
        private Object singleValue;

        public SingleValueStep(int writePos, Object value) {
            super(writePos);
            this.singleValue = value;
        }

        @Override
        public void reset() {
        }

        public SingleValueStep copy() {
            return new SingleValueStep(this.writePos, this.singleValue);
        }

        @Override
        public int getMemberCnt() {
            return 1;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Integer next() {
            return 0;
        }

        public Object getSingleValue() {
            return this.singleValue;
        }
    }

    public static abstract class MemberStep
    implements Iterator<Integer>,
    Serializable {
        private static final long serialVersionUID = 3352113408812046890L;
        protected int currentIndex;
        protected int writePos;
        Object[] resultArray;

        public String toString() {
            return "MemberStep [currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        public MemberStep(int writePos) {
            this.writePos = writePos;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        protected void setResultValue(Object value) {
            this.resultArray[this.writePos] = value;
        }

        protected String outOfBoundsMsg(int index, int end) {
            return "Index: " + index + ", Size: " + end;
        }

        public abstract void reset();

        public abstract <T extends MemberStep> T copy();

        public abstract int getMemberCnt();

        public void setResultArray(Object[] resultArray) {
            this.resultArray = resultArray;
        }
    }

    protected static class SingleStepSequenceIterator
    extends IntArraySequenceIterator {
        private static final long serialVersionUID = 7050734892999987259L;

        public SingleStepSequenceIterator(Object[] outputRowValues) {
            super(null, outputRowValues);
            this.lastStepPos = 1;
        }

        @Override
        public long getTotalStepCnt() {
            return 1L;
        }

        @Override
        public boolean hasNext() {
            return this.lastStepPos > 0;
        }

        @Override
        public Object[] next() {
            if (this.lastStepPos-- >= 0) {
                return this.currentRowValues;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    protected static class EmptyIntArraySequenceIterator
    extends IntArraySequenceIterator {
        private static final long serialVersionUID = 2693549751283165957L;

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object[] next() {
            throw new IndexOutOfBoundsException();
        }
    }
}

