/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.log;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.orm.sequence.SequenceReader;
import kd.fi.ai.util.DateUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.dao.log.BgTaskLogDao;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.task.status.ResultCountTypeEnum;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class FahBgTaskLogger {
    private static final int ENTRY_SIZE_TO_SAVE = 100;
    private static final int TIME_INTERVAL_TO_SAVE = 2000;
    private static final int MB = 0x100000;
    private final long taskId;
    private final BackgroundTaskTypeEnum taskTypeEnum;
    private TaskStatusEnum taskStatusEnum;
    private final AtomicInteger detailSeq;
    private final Collection<Object[]> detailEntries;
    private final boolean isRecordMemUseInfo;
    private long lastSaveTime;

    public FahBgTaskLogger(long taskId, BackgroundTaskTypeEnum taskTypeEnum) {
        this.taskId = taskId;
        this.taskTypeEnum = taskTypeEnum;
        this.detailSeq = new AtomicInteger(0);
        this.taskStatusEnum = TaskStatusEnum.NEW;
        this.detailEntries = new ArrayBlockingQueue<Object[]>(64);
        this.isRecordMemUseInfo = FahOptimizeControlPanel.isRecordMemUseInfo();
    }

    public static FahBgTaskLogger create(BackgroundTaskTypeEnum taskTypeEnum) {
        return new FahBgTaskLogger(FahBgTaskLogger.__genTaskId(), taskTypeEnum);
    }

    private static long __genTaskId() {
        SequenceReader sReader = new SequenceReader(FAHCommonConstant.AI);
        return ((Long[])sReader.getSequences((Object[])new Long[1], "t_fah_bgtask_log", 1))[0];
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void addDetailEntry(String msg) {
        this.addDetailEntry(msg, LogLevelEnum.Info, TaskStatusEnum.COMPLETED);
        if (this.isRecordMemUseInfo) {
            this.addDetailEntry(this.genMemUseInfo(), LogLevelEnum.Debug, TaskStatusEnum.COMPLETED);
        }
    }

    public void addDetailEntryErr(String msg) {
        this.addDetailEntry(msg, LogLevelEnum.Error, TaskStatusEnum.FAILURE);
        if (this.isRecordMemUseInfo) {
            this.addDetailEntry(this.genMemUseInfo(), LogLevelEnum.Debug, TaskStatusEnum.COMPLETED);
        }
    }

    public void addDetailEntryWarning(String msg) {
        this.addDetailEntry(msg, LogLevelEnum.Warning, TaskStatusEnum.COMPLETED);
        if (this.isRecordMemUseInfo) {
            this.addDetailEntry(this.genMemUseInfo(), LogLevelEnum.Debug, TaskStatusEnum.COMPLETED);
        }
    }

    public void addDetailEntry(String msg, LogLevelEnum logLevel, TaskStatusEnum taskStatusEnum) {
        if (taskStatusEnum == TaskStatusEnum.FAILURE) {
            this.taskStatusEnum = TaskStatusEnum.FAILURE;
        }
        if (taskStatusEnum == TaskStatusEnum.COMPLETED && this.taskStatusEnum != TaskStatusEnum.FAILURE) {
            this.taskStatusEnum = TaskStatusEnum.COMPLETED;
        }
        String threadTimeMsg = this.appendMsgPrefix(msg);
        this.detailEntries.add(new Object[]{null, null, this.detailSeq.incrementAndGet(), logLevel.getStringValue(), taskStatusEnum.getStringValue(), null, threadTimeMsg});
        this.checkAndSave();
    }

    private String genMemUseInfo() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        String memSummary = String.format("[Total: %d MB, Free: %d MB, Used: %d MB]", totalMemory / 0x100000L, freeMemory / 0x100000L, usedMemory / 0x100000L);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        String heapMemSummary = this.printMemoryUsage("Heap", heapMemoryUsage);
        String nonHeapMemSummary = this.printMemoryUsage("Non-Heap", nonHeapMemoryUsage);
        return String.format("%s, %s, %s", memSummary, heapMemSummary, nonHeapMemSummary);
    }

    private String printMemoryUsage(String memoryType, MemoryUsage memoryUsage) {
        long init = memoryUsage.getInit();
        long used = memoryUsage.getUsed();
        long committed = memoryUsage.getCommitted();
        long max = memoryUsage.getMax();
        return String.format("[%s, Init: %d MB, Used: %d MB, Committed: %d MB, Max: %d MB]", memoryType, init / 0x100000L, used / 0x100000L, committed / 0x100000L, max / 0x100000L);
    }

    private String appendMsgPrefix(String msg) {
        String threadTimeMsg = DebugTrace.enable() ? DateUtil.getMillisFormat().format(new Date()) + "#" + Thread.currentThread().getName() + ":" + RequestContext.get().getTraceId() + ":" + msg : DateUtil.getMillisFormat().format(new Date()) + "#" + RequestContext.get().getTraceId() + ":" + msg;
        return threadTimeMsg;
    }

    private void checkAndSave() {
        long now = System.currentTimeMillis();
        if (this.detailEntries.size() >= 100 || now - this.lastSaveTime >= 2000L) {
            this.lastSaveTime = now;
            BgTaskLogDao.appendDetails(this.taskId, this.detailEntries);
        }
    }

    public void createNewTask() {
        BaseBackgroundTaskContext<Object> backgroundTaskContext = new BaseBackgroundTaskContext<Object>(this.taskId, this.taskTypeEnum);
        backgroundTaskContext.setTaskPoints(ResultCountTypeEnum.Success_Cnt, 0);
        backgroundTaskContext.setTaskPoints(ResultCountTypeEnum.Total_Expect_Cnt, 0);
        BgTaskLogDao.saveTaskLog(this.taskTypeEnum, TaskStatusEnum.NEW, null, backgroundTaskContext);
        BgTaskLogDao.appendDetails(this.taskId, this.detailEntries);
        this.lastSaveTime = System.currentTimeMillis();
    }

    public void updateTaskToEnd() {
        if (this.taskStatusEnum != TaskStatusEnum.FAILURE) {
            this.taskStatusEnum = TaskStatusEnum.COMPLETED;
        }
        BgTaskLogDao.appendDetails(this.taskId, this.detailEntries);
        BgTaskLogDao.updateTaskToEnd(this.taskId, this.taskStatusEnum);
    }

    public static String logSizeOrDetail(Collection<?> collection) {
        if (null == collection) {
            return "";
        }
        if (DebugTrace.enable()) {
            return collection.toString();
        }
        return String.valueOf(collection.size());
    }

    public static String logSizeOrDetail2(Map<?, ?> map) {
        if (null == map) {
            return "";
        }
        if (DebugTrace.enable()) {
            return map.toString();
        }
        if (map.size() > 20) {
            return String.valueOf(map.size());
        }
        StringBuilder stringBuilder = new StringBuilder();
        int mapSize = map.size();
        stringBuilder.append("[mapSize:").append(mapSize).append(";");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            if (entry.getValue() instanceof Collection) {
                stringBuilder.append(":").append(((Collection)entry.getValue()).size());
            } else if (entry.getValue() instanceof Map) {
                stringBuilder.append(":").append(((Map)entry.getValue()).size());
            }
            stringBuilder.append(";");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String appendPrefixInfo(String msg) {
        return String.format("traceId: %s\nThread: %s\nInstance: %s\n%s", RequestContext.get().getTraceId(), Thread.currentThread().getName(), Instance.getInstanceId(), msg);
    }
}

