/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.meta;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.meta.enums.FieldPathIndexEnum;
import kd.fi.v2.fah.meta.enums.FieldPathTypeEnum;

public class FieldMetaPos
implements Serializable {
    public static final char Default_FieldPath_Delimer = '.';
    private int[][] pathPosInfo = new int[FieldPathIndexEnum.ValueField.getPos() + 1][2];
    private int[][] pathTypePosInfo = new int[FieldPathTypeEnum.ValueField_Type.getCode() + 1][2];
    private short pathFlags;

    public FieldMetaPos() {
    }

    public FieldMetaPos(Collection<PairTuple<FieldPathTypeEnum, int[]>> pathPosInfo) {
        this();
        this.setPathPosInfo(pathPosInfo);
    }

    public String toString() {
        return "FieldMetaPos{pathPosInfo=" + Arrays.deepToString((Object[])this.pathPosInfo) + ", pathTypePosInfo=" + Arrays.deepToString((Object[])this.pathTypePosInfo) + ", pathFlags=" + this.pathFlags + '}';
    }

    public int[] getPathPos(FieldPathIndexEnum index) {
        if (index == null) {
            return null;
        }
        return index == null ? null : this.getPathPos(index.getPos());
    }

    protected int[] getPathPos(int posIndex) {
        return posIndex < 0 || posIndex >= this.pathPosInfo.length ? null : this.pathPosInfo[posIndex];
    }

    public boolean containPathType(FieldPathIndexEnum pathType) {
        return this.getPathPos(pathType) != null;
    }

    public boolean containPathType(FieldPathTypeEnum pathType) {
        if (pathType == null) {
            return false;
        }
        int startPos = FieldPathTypeEnum.Entry_Type.getStartPos();
        switch (pathType) {
            case Root_Entity_Type: {
                return this.containPathType(FieldPathIndexEnum.Root_Entity);
            }
            case Entry_Type: {
                for (int i = 0; i < FieldPathTypeEnum.Entry_Type.getSupportCnt(); ++i) {
                    if (this.pathPosInfo[startPos + i] == null) continue;
                    return true;
                }
                return false;
            }
            case BaseProp_Type: {
                for (int i = 0; i < FieldPathTypeEnum.BaseProp_Type.getSupportCnt(); ++i) {
                    if (this.pathPosInfo[startPos + i] == null) continue;
                    return true;
                }
                return false;
            }
            case ValueField_Type: {
                return this.containPathType(FieldPathIndexEnum.ValueField);
            }
        }
        return false;
    }

    protected String parsePathSegment(String srcPath, int index) {
        if (this.pathPosInfo == null || srcPath == null) {
            return null;
        }
        int[] pos = this.getPathPos(index);
        int length = srcPath.length();
        return pos == null || pos[0] < 0 || pos[0] >= length || pos[1] >= length ? null : srcPath.substring(pos[0], pos[1]);
    }

    public String parseRootEntityNumber(String srcPath) {
        return this.parsePathSegment(srcPath, FieldPathIndexEnum.Root_Entity.getPos());
    }

    public String parseValueFieldNumber(String srcPath) {
        return this.parsePathSegment(srcPath, FieldPathIndexEnum.ValueField.getPos());
    }

    public String[] parsePathSegments(String srcPath, FieldPathTypeEnum pathType) {
        if (srcPath == null || pathType == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(pathType.getSupportCnt());
        int startPos = pathType.getStartPos();
        int length = srcPath.length();
        for (int i = 0; i < pathType.getSupportCnt(); ++i) {
            int[] pos = this.pathPosInfo[startPos + i];
            if (pos == null || pos[0] < 0 || pos[0] >= length || pos[1] >= length) continue;
            result.add(srcPath.substring(pos[0], pos[1]));
        }
        return result.toArray(new String[0]);
    }

    public String[] parseEntryNumber(String srcPath) {
        return this.parsePathSegments(srcPath, FieldPathTypeEnum.Entry_Type);
    }

    public String[] parseBasePropNumber(String srcPath) {
        return this.parsePathSegments(srcPath, FieldPathTypeEnum.BaseProp_Type);
    }

    public String getEntityQueryPath(String srcPath, FieldPathTypeEnum ... containPathTypes) {
        return this.getEntityQueryPath(srcPath, '.', containPathTypes);
    }

    protected int[] getPathSegmentRange(int cutModeCode, int requirePathFlag) {
        int[] posBuf = new int[2];
        int startCode = -1;
        int endCode = -1;
        switch (cutModeCode) {
            case 0: 
            case 15: {
                return null;
            }
            case 1: {
                posBuf = this.pathTypePosInfo[FieldPathTypeEnum.ValueField_Type.getCode()];
                break;
            }
            case 2: {
                posBuf = this.pathTypePosInfo[FieldPathTypeEnum.BaseProp_Type.getCode()];
                break;
            }
            case 3: {
                posBuf[0] = this.pathTypePosInfo[FieldPathTypeEnum.BaseProp_Type.getCode()][0];
                posBuf[1] = this.pathTypePosInfo[FieldPathTypeEnum.ValueField_Type.getCode()][1];
                break;
            }
            case 4: {
                posBuf = this.pathTypePosInfo[FieldPathTypeEnum.Entry_Type.getCode()];
                break;
            }
            case 6: {
                posBuf[0] = this.pathTypePosInfo[FieldPathTypeEnum.Entry_Type.getCode()][0];
                posBuf[1] = this.pathTypePosInfo[FieldPathTypeEnum.BaseProp_Type.getCode()][1];
                break;
            }
            case 7: {
                posBuf[0] = this.pathTypePosInfo[FieldPathTypeEnum.Entry_Type.getCode()][0];
                posBuf[1] = this.pathTypePosInfo[FieldPathTypeEnum.ValueField_Type.getCode()][1];
                break;
            }
            case 8: {
                posBuf = this.pathTypePosInfo[FieldPathTypeEnum.Root_Entity_Type.getCode()];
                break;
            }
            case 12: {
                posBuf[0] = this.pathTypePosInfo[FieldPathTypeEnum.Root_Entity_Type.getCode()][0];
                posBuf[1] = this.pathTypePosInfo[FieldPathTypeEnum.Entry_Type.getCode()][1];
                break;
            }
            case 14: {
                posBuf[0] = this.pathTypePosInfo[FieldPathTypeEnum.Root_Entity_Type.getCode()][0];
                posBuf[1] = this.pathTypePosInfo[FieldPathTypeEnum.BaseProp_Type.getCode()][1];
                break;
            }
            case 5: {
                startCode = FieldPathTypeEnum.Entry_Type.getCode();
                endCode = FieldPathTypeEnum.ValueField_Type.getCode();
                break;
            }
            case 10: {
                startCode = FieldPathTypeEnum.Root_Entity_Type.getCode();
                endCode = FieldPathTypeEnum.BaseProp_Type.getCode();
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                startCode = FieldPathTypeEnum.Root_Entity_Type.getCode();
                endCode = FieldPathTypeEnum.ValueField_Type.getCode();
                break;
            }
            default: {
                return null;
            }
        }
        if (startCode > -1) {
            int[] validPos = this.getValidPosRange(startCode, endCode, true);
            if (validPos == null) {
                return null;
            }
            posBuf[0] = validPos[0];
            validPos = this.getValidPosRange(endCode, startCode, false);
            if (validPos == null) {
                return null;
            }
            posBuf[1] = validPos[1];
        }
        return posBuf;
    }

    protected int[] getValidPosRange(int startCode, int endCode, boolean forward) {
        while (forward ? startCode <= endCode : startCode >= endCode) {
            int[] resultPos = this.pathTypePosInfo[startCode];
            if (resultPos != null && resultPos[0] + resultPos[1] > 0) {
                return resultPos;
            }
            if (forward) {
                ++startCode;
                continue;
            }
            --startCode;
        }
        return null;
    }

    public String getEntityQueryPath(String srcPath, char delimiter, FieldPathTypeEnum ... containPathTypes) {
        if (srcPath == null || containPathTypes == null || containPathTypes.length == 0) {
            return srcPath;
        }
        int requirePathFlag = 0;
        block10: for (FieldPathTypeEnum pathType : containPathTypes) {
            if (pathType == null) continue;
            switch (pathType) {
                case Root_Entity_Type: {
                    requirePathFlag |= 8;
                    continue block10;
                }
                case Entry_Type: {
                    requirePathFlag |= 4;
                    continue block10;
                }
                case BaseProp_Type: {
                    requirePathFlag |= 2;
                    continue block10;
                }
                case ValueField_Type: {
                    requirePathFlag |= 1;
                    continue block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        int cutMode = requirePathFlag & this.pathFlags;
        if (cutMode == this.pathFlags || cutMode == 15) {
            return srcPath;
        }
        if (cutMode == 0) {
            return null;
        }
        int[] posBuf = this.getPathSegmentRange(cutMode, requirePathFlag);
        if (posBuf != null) {
            return srcPath.substring(posBuf[0], posBuf[1]);
        }
        StringBuilder result = new StringBuilder();
        block11: for (FieldPathTypeEnum pathType : containPathTypes) {
            if (pathType == null) continue;
            int startPos = pathType.getStartPos();
            switch (pathType) {
                case Root_Entity_Type: 
                case ValueField_Type: {
                    posBuf = this.pathPosInfo[startPos];
                    if (posBuf == null) continue block11;
                    result.append(srcPath.substring(posBuf[0], posBuf[1])).append(delimiter);
                    continue block11;
                }
                case Entry_Type: 
                case BaseProp_Type: {
                    posBuf = this.pathTypePosInfo[pathType.getCode()];
                    if (posBuf == null) continue block11;
                    result.append(srcPath.substring(posBuf[0], posBuf[1])).append(delimiter);
                    continue block11;
                }
                default: {
                    continue block11;
                }
            }
        }
        int lastPos = result.length() - 1;
        if (result.charAt(lastPos) == delimiter) {
            result.deleteCharAt(lastPos);
        }
        return result.toString();
    }

    public String getFullPathWithEntries(String srcPath) {
        return this.getEntityQueryPath(srcPath, new FieldPathTypeEnum[0]);
    }

    public String getFullPathWithoutEntries(String srcPath) {
        return this.getEntityQueryPath(srcPath, FieldPathTypeEnum.BaseProp_Type, FieldPathTypeEnum.ValueField_Type);
    }

    public void setPathPosInfo(Collection<PairTuple<FieldPathTypeEnum, int[]>> pathPosInfo) {
        if (pathPosInfo != null) {
            int rootEntityCnt = 0;
            int entryCnt = 0;
            int basePropCnt = 0;
            int valueFieldCnt = 0;
            block6: for (PairTuple<FieldPathTypeEnum, int[]> path : pathPosInfo) {
                if (path == null) continue;
                int offset = 0;
                FieldPathTypeEnum pathTypeEnum = (FieldPathTypeEnum)((Object)path.getKey());
                switch (pathTypeEnum) {
                    case Root_Entity_Type: {
                        if (++rootEntityCnt > 1) {
                            throw new IllegalArgumentException("Only Support Single Root Entity!");
                        }
                        this.pathFlags = (short)(this.pathFlags | 8);
                        System.arraycopy(path.getValue(), 0, this.pathTypePosInfo[pathTypeEnum.getCode()], 0, 2);
                        break;
                    }
                    case Entry_Type: {
                        offset = entryCnt++;
                        if (entryCnt > 3) {
                            throw new IllegalArgumentException("Only Support 3 Level Entries!");
                        }
                        if (entryCnt == 1) {
                            System.arraycopy(path.getValue(), 0, this.pathTypePosInfo[pathTypeEnum.getCode()], 0, 2);
                            this.pathFlags = (short)(this.pathFlags | 4);
                            break;
                        }
                        this.pathTypePosInfo[pathTypeEnum.getCode()][1] = ((int[])path.getValue())[1];
                        break;
                    }
                    case BaseProp_Type: {
                        offset = basePropCnt++;
                        if (basePropCnt > 6) {
                            throw new IllegalArgumentException("Only Support 6 Level BaseProp!");
                        }
                        if (basePropCnt == 1) {
                            System.arraycopy(path.getValue(), 0, this.pathTypePosInfo[pathTypeEnum.getCode()], 0, 2);
                            this.pathFlags = (short)(this.pathFlags | 2);
                            break;
                        }
                        this.pathTypePosInfo[pathTypeEnum.getCode()][1] = ((int[])path.getValue())[1];
                        break;
                    }
                    case ValueField_Type: {
                        if (++valueFieldCnt > 1) {
                            throw new IllegalArgumentException("Only Support Single Value Field!");
                        }
                        this.pathFlags = (short)(this.pathFlags | 1);
                        System.arraycopy(path.getValue(), 0, this.pathTypePosInfo[pathTypeEnum.getCode()], 0, 2);
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                System.arraycopy(path.getValue(), 0, this.pathPosInfo[((FieldPathTypeEnum)((Object)path.getKey())).getStartPos() + offset], 0, 2);
            }
        }
    }

    public static FieldPathTypeEnum[] sort(FieldPathTypeEnum[] pathTypes) {
        Arrays.sort(pathTypes, (left, right) -> FieldMetaPos.compareFieldPathTypeEnum(left, right));
        return pathTypes;
    }

    public static int compareFieldPathTypeEnum(FieldPathTypeEnum left, FieldPathTypeEnum right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.getStartPos() == right.getStartPos()) {
            return 0;
        }
        return left.getStartPos() > right.getStartPos() ? 1 : -1;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<PairTuple<FieldPathIndexEnum, int[]>> getValidPathPosIterator() {
        return new Iterator<PairTuple<FieldPathIndexEnum, int[]>>(){
            int currentPos = -1;
            int nextValidPos = -1;
            PairTuple<FieldPathIndexEnum, int[]> buf = new PairTuple(null, null);

            @Override
            public boolean hasNext() {
                if (this.currentPos >= FieldMetaPos.this.pathPosInfo.length - 1) {
                    return false;
                }
                this.nextValidPos = -1;
                for (int i = this.currentPos + 1; i < FieldMetaPos.this.pathPosInfo.length; ++i) {
                    if (FieldMetaPos.this.pathPosInfo == null || FieldMetaPos.this.pathPosInfo[i][0] + FieldMetaPos.this.pathPosInfo[i][1] <= 0) continue;
                    this.nextValidPos = i;
                    return true;
                }
                return false;
            }

            @Override
            public PairTuple<FieldPathIndexEnum, int[]> next() {
                if (this.hasNext()) {
                    this.currentPos = this.nextValidPos;
                    return this.buf.reset((Object)FieldPathIndexEnum.getByPos(this.currentPos), (Object)FieldMetaPos.this.pathPosInfo[this.currentPos]);
                }
                return null;
            }
        };
    }

    public int[][] getPathPosInfo() {
        return this.pathPosInfo;
    }

    public void setPathPosInfo(int[][] pathPosInfo) {
        this.pathPosInfo = pathPosInfo;
    }

    public int[][] getPathTypePosInfo() {
        return this.pathTypePosInfo;
    }

    public void setPathTypePosInfo(int[][] pathTypePosInfo) {
        this.pathTypePosInfo = pathTypePosInfo;
    }

    public short getPathFlags() {
        return this.pathFlags;
    }

    public void setPathFlags(short pathFlags) {
        this.pathFlags = pathFlags;
    }
}

