/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.migration.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kd.bos.zip.ZipFile;
import kd.fi.v2.fah.migration.common.IDataMigrationLogHandler;
import kd.fi.v2.fah.migration.common.IMigrationDataProcessor;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataParser;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataProvider;

public interface IDataMigrationHandler<FILE, MODEL> {
    public FILE createMigrationFile(IMigrationZipDataProvider<MODEL> var1, File var2, Map<String, String> var3, String var4, Collection<?> var5) throws IOException;

    default public FILE createMigrationFile(IMigrationZipDataProvider<MODEL> dataProvider, File outputFile, Map<String, String> fileComments, String creator, Object ... pks) throws IOException {
        return this.createMigrationFile(dataProvider, outputFile, fileComments, creator, pks == null || pks.length == 0 ? Collections.emptyList() : Arrays.asList(pks));
    }

    default public FILE createMigrationFile(IMigrationZipDataProvider<MODEL> dataProvider, File outputFile, String creator, Collection<?> pks) throws IOException {
        return this.createMigrationFile(dataProvider, outputFile, null, creator, pks);
    }

    default public FILE createMigrationFile(IMigrationZipDataProvider<MODEL> dataProvider, File outputFile, String creator, Object ... pks) throws IOException {
        return this.createMigrationFile(dataProvider, outputFile, null, creator, pks == null || pks.length == 0 ? Collections.emptyList() : Arrays.asList(pks));
    }

    public void parseMigrationFile(FILE var1, IMigrationZipDataParser<MODEL> var2, IMigrationDataProcessor<ZipFile, MODEL> var3) throws IOException;

    public FILE inputStreamToMigrationFile(InputStream var1, File var2) throws IOException;

    default public FILE inputStreamToMigrationFile(InputStream srcInputStream) {
        try {
            return this.inputStreamToMigrationFile(srcInputStream, File.createTempFile("_tmp_fah_migrate_", ".zip"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setErrorHandler(IDataMigrationLogHandler var1);

    public IDataMigrationLogHandler getErrorHandler();
}

