/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.migration.zip;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import kd.bos.orm.query.QFilter;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.ZipParameters;
import kd.fi.ai.util.IOUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.migration.common.IMigrationDataProcessor;
import kd.fi.v2.fah.migration.enums.MigrateDataTypeEnum;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataParser;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataProvider;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public abstract class AbstractZipMigrationHandler<MODEL>
implements IMigrationZipDataProvider<MODEL>,
IMigrationZipDataParser<MODEL>,
IMigrationDataProcessor<ZipFile, MODEL> {
    private static final String Default_Version_Number = "1.0";
    protected String dataVersion = "1.0";
    protected String migrateDataCategory;
    protected final Iterator<PairTuple<MODEL, ZipParameters>> emptyIterator = new LinkedList().iterator();

    protected AbstractZipMigrationHandler() {
    }

    @Override
    public MigrateDataTypeEnum parseDataType(FileHeader fileHeader) {
        if (fileHeader == null) {
            return null;
        }
        String filePath = fileHeader.getFileName().toLowerCase(Locale.ROOT);
        if (filePath.startsWith(MigrateDataTypeEnum.Migrate_Data.getPathPrefix())) {
            return MigrateDataTypeEnum.Migrate_Data;
        }
        if (filePath.startsWith(MigrateDataTypeEnum.Index_Data.getPathPrefix())) {
            return MigrateDataTypeEnum.Index_Data;
        }
        return MigrateDataTypeEnum.Custom_Data;
    }

    @Override
    public InputStream getDataInputStream(MODEL sourceData, ZipParameters zipParameters) {
        return FahSerializeHelper.getInstance().getJsonInputStream(sourceData);
    }

    @Override
    public <PK> Iterator<PairTuple<MODEL, ZipParameters>> getOutputDataEx(MigrateDataTypeEnum dataType, Collection<PK> pks) {
        if (dataType != null) {
            switch (dataType) {
                case Migrate_Data: {
                    return this.getMirgationData(pks);
                }
                case Index_Data: {
                    return this.getIndexData();
                }
                case Custom_Data: {
                    return this.getCustomData();
                }
            }
        }
        return this.emptyIterator;
    }

    @Override
    public boolean onCompletedOutputMigrationFile(ZipFile migrationFile) {
        return true;
    }

    protected Iterator<PairTuple<MODEL, ZipParameters>> getMirgationData(QFilter filter, String[] orderBys) {
        throw new UnsupportedOperationException();
    }

    protected abstract <PK> Iterator<PairTuple<MODEL, ZipParameters>> getMirgationData(Collection<PK> var1);

    protected Iterator<PairTuple<MODEL, ZipParameters>> getIndexData() {
        return this.emptyIterator;
    }

    protected Iterator<PairTuple<MODEL, ZipParameters>> getCustomData() {
        return this.emptyIterator;
    }

    @Override
    public Collection<String> initFromMigrationFile(ZipFile srcMigrationFile) {
        return Collections.emptyList();
    }

    @Override
    public MODEL parseFromMigrateFile(Integer dataVersion, FileHeader fileHeader, InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        String fileBuffer = IOUtils.readFully(inputStream);
        if (StringUtils.isEmpty((String)fileBuffer)) {
            return null;
        }
        return FahSerializeHelper.getInstance().parse(fileBuffer, this.getSerializeClass());
    }

    protected abstract Class<MODEL> getSerializeClass();

    @Override
    public String getDataVersion() {
        return this.dataVersion;
    }
}

