/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.migration.zip;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.ZipParameters;
import kd.fi.ai.util.IOUtils;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.dao.log.BgTaskLogDao;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.migration.common.IDataMigrationHandler;
import kd.fi.v2.fah.migration.common.IDataMigrationLogHandler;
import kd.fi.v2.fah.migration.common.IMigrationDataProcessor;
import kd.fi.v2.fah.migration.enums.MigrateDataTypeEnum;
import kd.fi.v2.fah.migration.enums.MigrationProcessStageEnum;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataParser;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataProvider;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.task.status.ResultCountTypeEnum;
import kd.fi.v2.fah.task.status.TaskStatusEnum;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class ZipFormatMigrationHelper<MODEL>
implements IDataMigrationHandler<ZipFile, MODEL> {
    protected BaseBackgroundTaskContext<Object> taskContext;
    protected int[][] processResult = ResultCountTypeEnum.getResultCountArray(MigrateDataTypeEnum.values().length);
    protected CDCStageEnum stageCode;
    protected IDataMigrationLogHandler errorHandler;

    public BaseBackgroundTaskContext getTaskContext() {
        return this.taskContext;
    }

    public void setTaskContext(BaseBackgroundTaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public ZipFormatMigrationHelper(BaseBackgroundTaskContext taskContext, IDataMigrationLogHandler errorHandler) {
        this();
        this.taskContext = taskContext;
        this.errorHandler = errorHandler;
    }

    public ZipFormatMigrationHelper(IDataMigrationLogHandler errorHandler) {
        this();
        this.errorHandler = errorHandler;
    }

    protected ZipFormatMigrationHelper() {
        this.resetCount();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void resetCount() {
        for (int[] grp : this.processResult) {
            for (int i = 0; i < grp.length; ++i) {
                grp[i] = 0;
            }
        }
        this.stageCode = CDCStageEnum.Waiting_Start;
    }

    protected void updateStage(CDCStageEnum newStage) {
        this.stageCode = newStage;
    }

    protected int updateResultCount(int grpType, int resultCntType, int addCnt) {
        int[] nArray = this.processResult[grpType];
        int n = resultCntType;
        int n2 = nArray[n] + addCnt;
        nArray[n] = n2;
        return n2;
    }

    protected int updateResultCount(int grpType, int resultCntType) {
        return this.updateResultCount(grpType, resultCntType, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZipFile createMigrationFile(IMigrationZipDataProvider<MODEL> dataProvider, File outputFile, Map<String, String> fileComments, String creator, Collection<?> pks) throws IOException {
        if (outputFile == null || dataProvider == null) {
            throw new IllegalArgumentException("Output Zip File or Data Provider cannot be null!");
        }
        boolean hasErrorHandler = this.errorHandler != null;
        this.updateStage(CDCStageEnum.Started);
        String outputFileName = outputFile.getName();
        MigrationProcessStageEnum stageEnum = MigrationProcessStageEnum.Create_File;
        String errorMsgBuf = String.format("Error on Create Zip [%s]", outputFileName);
        Object model = null;
        ZipFile zipFile = new ZipFile(outputFile);
        LinkedHashMap<String, String> zipFileComments = new LinkedHashMap<String, String>(4);
        if (fileComments != null && !fileComments.isEmpty()) {
            zipFileComments.putAll(fileComments);
        }
        zipFileComments.put("Data-Category", dataProvider.getMigrateDataCategory());
        zipFileComments.put("Data-Version", dataProvider.getDataVersion());
        zipFileComments.put("File-Create-Time", DateValueUtils.dateToString(new Date(System.currentTimeMillis()), "yyyy.MM.dd HH:mm:ss"));
        zipFileComments.put("Creator", creator);
        this.updateStage(CDCStageEnum.Processing);
        block13: for (MigrateDataTypeEnum fileType : MigrateDataTypeEnum.values()) {
            Iterator iterator;
            int dataGrpCode = fileType.getCode();
            switch (fileType) {
                case Migrate_Data: {
                    iterator = dataProvider.getOutputDataEx(fileType, pks);
                    stageEnum = MigrationProcessStageEnum.Append_Migrate_Data;
                    break;
                }
                case Index_Data: {
                    stageEnum = MigrationProcessStageEnum.Append_Index_Data;
                    iterator = dataProvider.getOutputDataEx(fileType, null);
                    break;
                }
                case Custom_Data: {
                    stageEnum = MigrationProcessStageEnum.Append_Customized_Data;
                    iterator = dataProvider.getOutputDataEx(fileType, null);
                    break;
                }
                default: {
                    continue block13;
                }
            }
            int idx = 0;
            InputStream inputStream = null;
            while (iterator.hasNext()) {
                try {
                    ZipParameters zipParameters;
                    PairTuple buf = iterator.next();
                    if (buf == null || (model = buf.getKey()) == null || (zipParameters = (ZipParameters)buf.getValue()) == null) {
                        this.updateResultCount(dataGrpCode, ResultCountTypeEnum.Skip_Cnt.getCode());
                        continue;
                    }
                    errorMsgBuf = String.format("%d).Error on append [%s] data into Zip [%s]: [%s]", idx, fileType.name(), outputFileName, zipParameters.getFileNameInZip());
                    inputStream = dataProvider.getDataInputStream(model, zipParameters);
                    zipFile.addStream(inputStream, zipParameters);
                    ++idx;
                    this.updateResultCount(dataGrpCode, ResultCountTypeEnum.Success_Cnt.getCode());
                }
                catch (Exception ex) {
                    this.updateResultCount(dataGrpCode, ResultCountTypeEnum.Failed_Cnt.getCode());
                    if (hasErrorHandler && this.errorHandler.onError(stageEnum, model, errorMsgBuf, this.taskContext)) continue;
                    this.stageCode = CDCStageEnum.Canceled;
                    throw new IOException(ex.getLocalizedMessage(), ex);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        try {
            stageEnum = MigrationProcessStageEnum.Finalize_Customized_Output_File;
            errorMsgBuf = String.format("Error on Finalize Customized Zip File[%s]", outputFile);
            dataProvider.onCompletedOutputMigrationFile(zipFile);
            this.updateStage(CDCStageEnum.Completed);
            zipFile.setComment(FahSerializeHelper.getInstance().toJSONString(zipFileComments, true));
            return zipFile;
        }
        catch (Exception ex) {
            if (hasErrorHandler) {
                this.errorHandler.onFatal(stageEnum, model, errorMsgBuf, this.taskContext);
            }
            this.updateStage(CDCStageEnum.Canceled);
            throw new IOException(ex.getLocalizedMessage(), ex);
        }
    }

    protected Map<String, String> parserZipFileComment(ZipFile sourceFile) {
        if (sourceFile != null) {
            try {
                String zipFileComments = sourceFile.getComment();
                if (StringUtils.isNotEmpty((String)zipFileComments)) {
                    return FahSerializeHelper.getInstance().parse(zipFileComments, Map.class);
                }
            }
            catch (ZipException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void parseMigrationFile(ZipFile sourceFile, IMigrationZipDataParser<MODEL> dataParser, IMigrationDataProcessor<ZipFile, MODEL> migrateProcessor) throws IOException {
        if (sourceFile == null || dataParser == null || migrateProcessor == null) {
            return;
        }
        Map<String, String> zipFileComments = this.parserZipFileComment(sourceFile);
        String dataVersionBuf = zipFileComments.get("Data-Version");
        int dataVersion = dataVersionBuf != null ? Integer.parseInt(dataVersionBuf) : -1;
        this.taskContext.setTaskStatus(TaskStatusEnum.PROCESSING);
        this.taskContext.setTaskPoints(ResultCountTypeEnum.Total_Expect_Cnt, sourceFile.getFileHeaders().size());
        BgTaskLogDao.saveTaskLog(BackgroundTaskTypeEnum.Ext_DataModel_Migration_Import, this.taskContext.getTaskStatus(), null, this.taskContext);
        this.updateStage(CDCStageEnum.Started);
        boolean hasErrorHandler = this.errorHandler != null;
        MigrationProcessStageEnum stageEnum = MigrationProcessStageEnum.Init_Parse_File;
        Collection<String> errorMsg = dataParser.initFromMigrationFile(sourceFile);
        if (hasErrorHandler && errorMsg != null && !errorMsg.isEmpty()) {
            this.errorHandler.onFatal(stageEnum, null, errorMsg, this.taskContext);
            this.updateStage(CDCStageEnum.Canceled);
            return;
        }
        this.updateStage(CDCStageEnum.Processing);
        int idx = 1;
        int resultCntGrp = MigrateDataTypeEnum.Migrate_Data.getCode();
        TaskStatusEnum totalTaskStatus = null;
        for (FileHeader fileHeader : sourceFile.getFileHeaders()) {
            if (fileHeader.isDirectory() || MigrateDataTypeEnum.Migrate_Data != dataParser.parseDataType(fileHeader)) continue;
            stageEnum = MigrationProcessStageEnum.Parse_Migrate_Data;
            String errorMsgBuf = String.format("Error on Parse (%d) File: [%s]", idx, fileHeader.getFileName());
            Object model = dataParser.parseFromMigrateFile(dataVersion, fileHeader, (InputStream)sourceFile.getInputStream(fileHeader));
            if (model == null) {
                this.updateResultCount(resultCntGrp, ResultCountTypeEnum.Failed_Cnt.getCode());
                if (!hasErrorHandler) continue;
                this.errorHandler.onError(stageEnum, (Object)fileHeader, errorMsgBuf, this.taskContext);
                continue;
            }
            stageEnum = MigrationProcessStageEnum.Process_Migrate_Data;
            this.taskContext.setErrorMsg(null);
            PairTuple<LogLevelEnum, List<String>> result = migrateProcessor.processMigrationData(model, this.taskContext, new Object[0]);
            if (hasErrorHandler && result != null && !((List)result.getValue()).isEmpty()) {
                this.updateResultCount(resultCntGrp, ResultCountTypeEnum.Failed_Cnt.getCode());
                LogLevelEnum logLevelEnum = (LogLevelEnum)((Object)result.getKey());
                this.errorHandler.outputLog(logLevelEnum, stageEnum, model, (Collection)result.getValue(), null, this.taskContext);
                if (totalTaskStatus == TaskStatusEnum.FAILURE) continue;
                if (LogLevelEnum.Warning == logLevelEnum) {
                    totalTaskStatus = TaskStatusEnum.WAIN;
                    continue;
                }
                if (LogLevelEnum.Error != logLevelEnum) continue;
                totalTaskStatus = TaskStatusEnum.FAILURE;
                continue;
            }
            int successCnt = this.taskContext.getTaskPoints(ResultCountTypeEnum.Success_Cnt);
            this.taskContext.setTaskPoints(ResultCountTypeEnum.Success_Cnt, ++successCnt);
            this.errorHandler.onInfo(stageEnum, model, this.taskContext);
            ++idx;
        }
        this.updateResultCount(resultCntGrp, ResultCountTypeEnum.Success_Cnt.getCode());
        if (null != totalTaskStatus) {
            this.taskContext.setTaskStatus(totalTaskStatus);
            this.errorHandler.onError(stageEnum, null, errorMsg, this.taskContext);
            this.updateStage(CDCStageEnum.Canceled);
        } else {
            this.taskContext.setTaskStatus(TaskStatusEnum.COMPLETED);
            this.errorHandler.onInfo(stageEnum, null, this.taskContext);
            this.updateStage(CDCStageEnum.Completed);
        }
    }

    @Override
    public ZipFile inputStreamToMigrationFile(InputStream srcInputStream, File outputFile) throws IOException {
        IOUtils.inputStreamToFile(srcInputStream, outputFile);
        return new ZipFile(outputFile);
    }

    @Override
    public IDataMigrationLogHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(IDataMigrationLogHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getProcessResult(int grp, ResultCountTypeEnum resultCntType) {
        return resultCntType == null ? 0 : this.processResult[grp][resultCntType.getCode()];
    }
}

