/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import kd.fi.v2.fah.models.common.tree.IBaseTreeNode;
import kd.fi.v2.fah.models.common.tree.ICommonTreeModel;

public abstract class AbstractCommonTreeModel<NODE_KEY, V, NODE_TYPE extends IBaseTreeNode<NODE_KEY, V>>
implements ICommonTreeModel<NODE_KEY> {
    protected NODE_KEY key;
    protected Map<Object, NODE_TYPE> childNodes;

    public AbstractCommonTreeModel() {
    }

    public AbstractCommonTreeModel(NODE_KEY key) {
        this.key = key;
    }

    @Override
    public boolean containNodeKey(NODE_KEY nodeKey, boolean childOrParent) {
        return this.hasChild() ? this.childNodes.containsKey(nodeKey) : false;
    }

    @Override
    public int getDefaultNodePathType() {
        return 0;
    }

    protected Object parseNodeKey(IBaseTreeNode<NODE_KEY, V> srcNode) {
        return srcNode == null ? null : srcNode.getItemKey();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasChild() {
        return this.childNodes != null && !this.childNodes.isEmpty();
    }

    protected boolean doCustomeMerge(IBaseTreeNode<NODE_KEY, V> target) {
        return true;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Collection<IBaseTreeNode<NODE_KEY, V>> getChildCopy() {
        return this.getNodeCopy(this.childNodes);
    }

    protected abstract Map<Object, NODE_TYPE> getNodeMap(boolean var1);

    public int getDependencyLevel(boolean reverseMode) {
        int myLevel = 0;
        Map<Object, NODE_TYPE> travelMap = this.getNodeMap(!reverseMode);
        if (travelMap != null && !travelMap.isEmpty()) {
            for (IBaseTreeNode node : travelMap.values()) {
                int parentLevel;
                if (node == null || myLevel >= (parentLevel = node.getDependencyLevel(reverseMode) + 1)) continue;
                myLevel = parentLevel;
            }
        }
        return myLevel;
    }

    protected Collection<NODE_TYPE> getNodeCopy(Map<Object, NODE_TYPE> srcNodeMap) {
        if (srcNodeMap == null || srcNodeMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(srcNodeMap.size());
        srcNodeMap.values().forEach(v -> result.add(v));
        return result;
    }

    protected boolean checkDependencyCycle(NODE_TYPE child) {
        return true;
    }

    public void dumpNode(int nodeStartLevel, StringBuilder output, String levelPrefix, Integer seqNo, boolean reverseMode, BiFunction<int[], V, String> dumpNodeValueFunc) {
        if (output == null) {
            return;
        }
        output.append("\n");
        for (int i = 0; i < nodeStartLevel; ++i) {
            output.append(levelPrefix);
        }
        this.dumpNodeValue(output, nodeStartLevel, seqNo, reverseMode, dumpNodeValueFunc);
        int childIdx = -1;
        for (IBaseTreeNode child : this.getNodeMap(reverseMode).values()) {
            ++childIdx;
            if (child == null) continue;
            child.dumpNode(nodeStartLevel + 1, output, levelPrefix, childIdx, reverseMode, dumpNodeValueFunc);
        }
    }

    protected void dumpNodeValue(StringBuilder output, int level, Integer seqNo, boolean reverseMode, BiFunction<int[], V, String> dumpNodeValueFunc) {
        output.append(this.key).append(" (Level=").append(level).append(")");
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public NODE_KEY getItemKey() {
        return this.key;
    }

    public Map<Object, NODE_TYPE> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public NODE_KEY getKey() {
        return this.key;
    }

    public void setNodeKey(NODE_KEY nodeKey) {
        this.key = nodeKey;
    }
}

