/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.fi.v2.fah.models.common.tree.IBaseTreeNode;
import kd.fi.v2.fah.models.common.tree.impl.SimpleTreeModel;
import kd.fi.v2.fah.models.common.tree.impl.SimpleTreeNode;

public class DependencyTreeModel<NODE_KEY, V>
extends SimpleTreeModel<NODE_KEY, V> {
    public DependencyTreeModel() {
    }

    public DependencyTreeModel(NODE_KEY treeKey) {
        super(treeKey);
    }

    public SimpleTreeNode<NODE_KEY, V> addDependencyNode(NODE_KEY srcNodeKey, List<NODE_KEY> dependedNodeKeys) {
        if (srcNodeKey == null) {
            return null;
        }
        List<NODE_KEY> nodeKey = Collections.singletonList(srcNodeKey);
        IBaseTreeNode field = (SimpleTreeNode)this.childNodes.get(nodeKey);
        if (field == null) {
            field = this.createEmptyNode((Object)srcNodeKey);
            this.childNodes.put(nodeKey, field);
        }
        if (dependedNodeKeys != null && !dependedNodeKeys.isEmpty()) {
            for (NODE_KEY p : dependedNodeKeys) {
                nodeKey = Collections.singletonList(p);
                IBaseTreeNode parent = (SimpleTreeNode)this.childNodes.get(nodeKey);
                if (parent == null) {
                    parent = this.createEmptyNode((Object)p);
                    this.childNodes.put(nodeKey, parent);
                }
                parent.addChildNode(field);
            }
        }
        return field;
    }

    public boolean addNodeDependencyLink(NODE_KEY srcNodeKey, List<NODE_KEY> dependedNodeKeys) {
        if (srcNodeKey == null || dependedNodeKeys == null || dependedNodeKeys.isEmpty()) {
            return false;
        }
        List<NODE_KEY> nodeKey = Collections.singletonList(srcNodeKey);
        SimpleTreeNode field = (SimpleTreeNode)this.childNodes.get(nodeKey);
        if (field == null) {
            return false;
        }
        for (NODE_KEY p : dependedNodeKeys) {
            SimpleTreeNode parent = (SimpleTreeNode)this.childNodes.get(Collections.singletonList(p));
            if (parent == null) {
                return false;
            }
            parent.addChildNode(field);
        }
        return true;
    }

    public SimpleTreeNode<NODE_KEY, V> addDependencyNode(NODE_KEY srcNodeKey, List<NODE_KEY> dependedNodeKeys, V nodeValue) {
        SimpleTreeNode<NODE_KEY, V> newNode = this.addDependencyNode(srcNodeKey, dependedNodeKeys);
        if (newNode != null) {
            newNode.setNodeValues(nodeValue);
        }
        return newNode;
    }

    public SimpleTreeNode<NODE_KEY, V> addDependencyNode(NODE_KEY srcNodeKey, NODE_KEY[] dependedNodeKeys) {
        return this.addDependencyNode(srcNodeKey, dependedNodeKeys != null ? Arrays.asList(dependedNodeKeys) : null);
    }
}

