/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.v2.fah.models.context.ValueSetDuplicateCheckResult;
import kd.fi.v2.fah.models.valueset.IDataValueSet;

public class DuplicateMappingCheckerContext {
    protected Map<Object, List<Integer>>[] _columnCheckMaps;
    protected int _columnCnt;
    protected static final Object EmptyObjectRef = new Object();
    protected List<IDataValueSet> registeredRows;

    public DuplicateMappingCheckerContext(int columnCnt) {
        if (columnCnt <= 0) {
            throw new IllegalArgumentException("Column Count cannot less than zero!");
        }
        this._columnCnt = columnCnt;
        this._columnCheckMaps = new Map[this._columnCnt];
        for (int i = 0; i < this._columnCnt; ++i) {
            this._columnCheckMaps[i] = new HashMap<Object, List<Integer>>(16);
        }
        this.registeredRows = new ArrayList<IDataValueSet>(64);
    }

    public List<Set<Object>> buildQueryDBParams() {
        LinkedList<Set<Object>> result = new LinkedList<Set<Object>>();
        for (Map<Object, List<Integer>> colMap : this._columnCheckMaps) {
            result.add(colMap.keySet());
        }
        return result;
    }

    public int getRegisteredRowCnt() {
        return this.registeredRows.size();
    }

    public int getTotalRegisteredColumnDataCnt() {
        int totalCnt = 0;
        for (Map<Object, List<Integer>> colMap : this._columnCheckMaps) {
            totalCnt += colMap.size();
        }
        return totalCnt;
    }

    public int getRegisteredColumnDataCnt(int columnIndex) {
        return this._columnCheckMaps[columnIndex].size();
    }

    public void clear(int columnCnt) {
        if (columnCnt == this._columnCnt) {
            for (Map<Object, List<Integer>> m : this._columnCheckMaps) {
                m.clear();
            }
        } else {
            this._columnCnt = columnCnt;
            this._columnCheckMaps = new Map[this._columnCnt];
            for (int i = 0; i < this._columnCnt; ++i) {
                this._columnCheckMaps[i] = new HashMap<Object, List<Integer>>(16);
            }
        }
        this.registeredRows.clear();
    }

    public void clear() {
        this.clear(this._columnCnt);
    }

    public static boolean isOverlapDateRange(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        long end2;
        long start1 = startDate1 == null ? 0L : startDate1.getTime();
        long end1 = endDate1 == null ? Long.MAX_VALUE : endDate1.getTime();
        long start2 = startDate2 == null ? 0L : startDate2.getTime();
        long l = end2 = endDate2 == null ? Long.MAX_VALUE : endDate2.getTime();
        if (start1 >= end1 || start2 >= end2) {
            throw new IllegalArgumentException(String.format("Invalid Date Range: [%s ~ %s] vs [%s ~ %s]", startDate1, endDate1, startDate2, endDate2));
        }
        return start1 < end2 && start2 < end1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int registerCheckValue(IDataValueSet checkTargetValueSet) {
        List<IDataValueSet> list = this.registeredRows;
        synchronized (list) {
            this.registeredRows.add(checkTargetValueSet);
            return this.registeredRows.size() - 1;
        }
    }

    protected boolean checkValue(int innerRowIndex, IDataValueSet checkTargetValueSet, ValueSetDuplicateCheckResult outputResultBuffer, boolean keepDuplicateValue) {
        boolean needCheckDateRange = checkTargetValueSet.hasValidDateRange();
        Date startDate = checkTargetValueSet.getEffectDate();
        Date endDate = checkTargetValueSet.getExpireDate();
        boolean hasMultiValue = checkTargetValueSet.hasHasMulValue();
        boolean needRegisterCheckValue = innerRowIndex >= 0;
        BitSet columnCheckBitSet = outputResultBuffer.getColumnCheckBitSetBuffer();
        BitSet duplicateRowBitSetBuffer = outputResultBuffer.getDuplicateRowBitSetBuffer();
        for (int colIndex = 0; colIndex < this._columnCnt; ++colIndex) {
            Map<Object, List<Integer>> columnMap = this._columnCheckMaps[colIndex];
            Object columnValueBuf = checkTargetValueSet.get(colIndex);
            if (columnValueBuf == null) {
                columnValueBuf = EmptyObjectRef;
            }
            int currentCheckColumnIndex = colIndex;
            columnCheckBitSet.clear();
            for (Object v : hasMultiValue ? (List)columnValueBuf : Collections.singletonList(columnValueBuf)) {
                List refRowIndexes = needRegisterCheckValue ? columnMap.computeIfAbsent(v, k -> new LinkedList()) : columnMap.get(v);
                if (refRowIndexes == null) continue;
                refRowIndexes.forEach(duplicateRowIndexId -> {
                    if (needCheckDateRange) {
                        IDataValueSet cmpValueSet = this.registeredRows.get((int)duplicateRowIndexId);
                        if (DuplicateMappingCheckerContext.isOverlapDateRange(startDate, endDate, cmpValueSet.getEffectDate(), cmpValueSet.getExpireDate())) {
                            columnCheckBitSet.set((int)duplicateRowIndexId);
                        }
                    } else {
                        columnCheckBitSet.set((int)duplicateRowIndexId);
                    }
                    if (keepDuplicateValue) {
                        outputResultBuffer.addDuplicateTarget((Serializable)duplicateRowIndexId, !needRegisterCheckValue, currentCheckColumnIndex, v);
                    } else {
                        outputResultBuffer.addDuplicateTarget((Serializable)duplicateRowIndexId, !needRegisterCheckValue);
                    }
                });
                if (!needRegisterCheckValue) continue;
                refRowIndexes.add(innerRowIndex);
            }
            if (colIndex == 0) {
                duplicateRowBitSetBuffer.or(columnCheckBitSet);
                continue;
            }
            duplicateRowBitSetBuffer.and(columnCheckBitSet);
        }
        return !outputResultBuffer.clearNotDuplicateRows();
    }

    public boolean addAndCheckValue(IDataValueSet checkTargetValueSet, ValueSetDuplicateCheckResult outputResultBuffer, boolean keepDuplicateValue) {
        return this.checkValue(this.registerCheckValue(checkTargetValueSet), checkTargetValueSet, outputResultBuffer, keepDuplicateValue);
    }

    public ValueSetDuplicateCheckResult addAndCheckSingleValue(IDataValueSet checkTargetValueSet, boolean keepDuplicateValue) {
        int rowId = this.registerCheckValue(checkTargetValueSet);
        ValueSetDuplicateCheckResult outputResultBuffer = new ValueSetDuplicateCheckResult(rowId, checkTargetValueSet, this._columnCnt);
        this.checkValue(rowId, checkTargetValueSet, outputResultBuffer, keepDuplicateValue);
        return outputResultBuffer;
    }

    public boolean checkFromDBValue(IDataValueSet checkTargetValueSet, ValueSetDuplicateCheckResult outputResultBuffer, boolean keepDuplicateValue) {
        return this.checkValue(-1, checkTargetValueSet, outputResultBuffer, keepDuplicateValue);
    }

    public ValueSetDuplicateCheckResult checkSingleFromDBValue(IDataValueSet checkTargetValueSet, boolean keepDuplicateValue) {
        ValueSetDuplicateCheckResult outputResultBuffer = new ValueSetDuplicateCheckResult(checkTargetValueSet.getItemKey(), checkTargetValueSet, this._columnCnt);
        this.checkValue(-1, checkTargetValueSet, outputResultBuffer, keepDuplicateValue);
        return outputResultBuffer;
    }
}

