/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import kd.fi.v2.fah.models.valueset.IDataValueSet;
import kd.fi.v2.fah.storage.IDataItemKey;

public class DuplicateTarget
implements IDataItemKey<Serializable> {
    Serializable rowID;
    boolean fromDB;
    IDataValueSet<Serializable> duplicateTarget;
    List<Object>[] duplicateValues;

    public DuplicateTarget(Serializable rowID, boolean fromDB, IDataValueSet duplicateTarget, int checkColumnCnt) {
        this.reset(rowID, fromDB, duplicateTarget, checkColumnCnt);
    }

    public DuplicateTarget(Serializable rowID, boolean fromDB, int checkColumnCnt) {
        this.reset(rowID, fromDB, null, checkColumnCnt);
    }

    public String toString() {
        return "DuplicateTarget{rowID=" + this.rowID + ", fromDB=" + this.fromDB + ", duplicateValues=" + Arrays.toString(this.duplicateValues) + '}';
    }

    public void addDuplicateColumn(int columnIndex, Object duplicateValue) {
        List<Object> valList = this.duplicateValues[columnIndex];
        if (valList == null) {
            this.duplicateValues[columnIndex] = new LinkedList<Object>();
            this.duplicateValues[columnIndex].add(duplicateValue);
        } else {
            valList.add(duplicateValue);
        }
    }

    public void forEachDuplicateColumn(BiConsumer<Integer, List<Object>> consumer) {
        for (int columnIndex = 0; columnIndex < this.duplicateValues.length; ++columnIndex) {
            consumer.accept(columnIndex, this.duplicateValues[columnIndex]);
        }
    }

    public IDataValueSet getDuplicateTarget() {
        return this.duplicateTarget;
    }

    public List<Object>[] getDuplicateValues() {
        return this.duplicateValues;
    }

    public void reset(Serializable rowID, boolean fromDB, IDataValueSet duplicateTarget, int checkColumnCnt) {
        this.rowID = rowID;
        this.fromDB = fromDB;
        this.duplicateTarget = duplicateTarget;
        if (this.duplicateValues != null && checkColumnCnt == this.duplicateValues.length) {
            for (int i = 0; i < checkColumnCnt; ++i) {
                this.duplicateValues[i].clear();
            }
        } else {
            this.duplicateValues = new List[checkColumnCnt];
        }
    }

    public void reset(Serializable rowID, boolean fromDB, int checkColumnCnt) {
        this.reset(rowID, fromDB, null, checkColumnCnt);
    }

    @Override
    public Serializable getItemKey() {
        return this.rowID;
    }
}

