/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicMetadata;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObjectType;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicProperty;

public class SdoDBInsertParams {
    private transient SimpleDynamicObjectType parentDT;
    private Boolean isRoot;
    private int level;
    private transient List<SimpleDynamicProperty> colnums;
    private transient SimpleDynamicProperty parentPk;
    private String dbRoute;
    private String tableName;
    private String sql;
    private List<String> colnumNames;
    private List<Object[]> paramsList = new ArrayList<Object[]>(8);

    public SimpleDynamicObjectType getParentDT() {
        return this.parentDT;
    }

    public void setParentDT(SimpleDynamicObjectType parentDT) {
        this.parentDT = parentDT;
        this.isRoot = null == parentDT;
        this.level = this.calLevel(parentDT);
    }

    private int calLevel(SimpleDynamicObjectType parentDT) {
        if (null == parentDT) {
            return 1;
        }
        return this.calLevel(parentDT.getParent()) + 1;
    }

    public List<SimpleDynamicProperty> getColnums() {
        return this.colnums;
    }

    public void setColnums(List<SimpleDynamicProperty> colnums) {
        this.colnums = colnums;
        this.colnumNames = colnums.stream().map(SimpleDynamicMetadata::getAlias).collect(Collectors.toList());
        if (!this.isRoot.booleanValue()) {
            this.parentPk = this.parentDT.getPK();
            this.colnumNames.add(this.parentPk.getAlias());
        }
        this.sql = this.genSql();
    }

    private String genSql() {
        int i;
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" ( ");
        for (i = 0; i < this.colnumNames.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.colnumNames.get(i));
        }
        stringBuilder.append(" ) values ( ");
        for (i = 0; i < this.colnumNames.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(" ) ");
        return stringBuilder.toString();
    }

    public Boolean getRoot() {
        return this.isRoot;
    }

    public void setRoot(Boolean root) {
        this.isRoot = root;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public SimpleDynamicProperty getParentPk() {
        return this.parentPk;
    }

    public void setParentPk(SimpleDynamicProperty parentPk) {
        this.parentPk = parentPk;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public List<String> getColnumNames() {
        return this.colnumNames;
    }

    public void setColnumNames(List<String> colnumNames) {
        this.colnumNames = colnumNames;
    }

    public List<Object[]> getParamsList() {
        return this.paramsList;
    }

    public void setParamsList(List<Object[]> paramsList) {
        this.paramsList = paramsList;
    }

    public String toString() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }
}

