/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.dynamic;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.IObjectWithParent;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicCollectionProperty;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObjectType;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicProperty;
import kd.fi.v2.fah.storage.IOpenDataStorage;
import kd.fi.v2.fah.storage.OpenDataStorageFactory;
import kd.fi.v2.fah.utils.StringUtils;

public class SimpleDynamicObject
implements IDataEntityBase,
IObjectWithParent,
Serializable {
    private static final long serialVersionUID = 4259350041532815099L;
    private static final String STRING = "??????";
    private static final String MSG_Resource_Type = "fi-ai-common";
    protected SimpleDynamicObjectType dt;
    protected IOpenDataStorage dataStorage;
    private transient BitSet lastDirty;
    private SimpleDynamicObject _parent;
    private boolean isQueryObj;

    protected SimpleDynamicObject() {
    }

    public SimpleDynamicObject(SimpleDynamicObjectType dt, Object id) {
        this.dt = dt;
        if (this.dt == null) {
            throw new IllegalArgumentException("DynamicObjectType cannot be null!");
        }
        this.dataStorage = this.createDataStorage(dt.getProps().size());
        if (id != null) {
            dt.getPK().setValue(this, id);
        }
    }

    public SimpleDynamicObject(SimpleDynamicObjectType dt) {
        this(dt, null);
    }

    public SimpleDynamicObject(SimpleDynamicObjectType dt, boolean isQueryObj) {
        this(dt, null);
        this.isQueryObj = isQueryObj;
    }

    public final SimpleDynamicObjectType getDynamicObjectType() {
        return this.dt;
    }

    public final IOpenDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public final void setDataStorage(IOpenDataStorage value) {
        this.dataStorage = value;
    }

    protected IOpenDataStorage createDataStorage(int initSize) {
        return OpenDataStorageFactory.createDefaultMemoryDataStorage(initSize);
    }

    public final void set(String propertyName, Object value) {
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException("Property Name cannot be null! Value=" + value);
        }
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(propertyName);
        if (dp == null) {
            throw new ORMDesignException(STRING, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7c7b\u578b\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a\u201c%2$s\u201d\u7684\u5c5e\u6027\u3002", (String)"SimpleDynamicObject_0", (String)MSG_Resource_Type, (Object[])new Object[0]), this.dt.getName(), propertyName));
        }
        dp.setValueFast((Object)this, value);
    }

    public final void set(int index, Object value) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(index);
        dp.setValue((Object)this, value);
    }

    public final void set(IDataEntityProperty dp, Object value) {
        if (dp == null) {
            throw new IllegalArgumentException("property");
        }
        dp.setValue((Object)this, value);
    }

    public Object get(String propertyName) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(propertyName);
        if (dp != null) {
            return ObjectConverter.convert((Object)dp.getValueFast((Object)this), (Class)dp.getPropertyType(), (boolean)dp.isEnableNull());
        }
        if (dp == null) {
            throw new ORMDesignException(STRING, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7c7b\u578b\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a\u201c%2$s\u201d\u7684\u5c5e\u6027\u3002", (String)"SimpleDynamicObject_0", (String)MSG_Resource_Type, (Object[])new Object[0]), this.dt.getName(), propertyName));
        }
        return ObjectConverter.convert((Object)dp.getValueFast((Object)this), (Class)dp.getPropertyType(), (boolean)dp.isEnableNull());
    }

    public final Object get(int index) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(index);
        return ObjectConverter.convert((Object)dp.getValueFast((Object)this), (Class)dp.getPropertyType(), (boolean)dp.isEnableNull());
    }

    public final boolean containsProperty(String propertyName) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(propertyName);
        return dp != null;
    }

    public final Object get(IDataEntityProperty dp) {
        if (dp == null) {
            throw new IllegalArgumentException("property");
        }
        return ObjectConverter.convert((Object)dp.getValueFast((Object)this), (Class)dp.getPropertyType(), (boolean)dp.isEnableNull());
    }

    public BitSet getLastDirty() {
        if (this.lastDirty == null) {
            this.lastDirty = new BitSet();
        }
        return this.lastDirty;
    }

    public IDataEntityType getDataEntityType() {
        return this.dt;
    }

    public Object getPkValue() {
        if (this.dt.getPK() == null) {
            return null;
        }
        SimpleDynamicProperty pkProp = this.dt.getPK();
        return pkProp.getValueFast(this);
    }

    public SimpleDynamicObject getParent() {
        return this._parent;
    }

    public void setParent(Object value) {
        this._parent = (SimpleDynamicObject)value;
    }

    private <T> T get(String propertyName, Class<T> cls) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(propertyName);
        return (T)ObjectConverter.convert((Object)this.get(propertyName), cls, (dp != null && dp.isEnableNull() ? 1 : 0) != 0);
    }

    private <T> T get(int index, Class<T> cls) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProps().get(index);
        return (T)ObjectConverter.convert((Object)this.get(index), cls, (dp != null && dp.isEnableNull() ? 1 : 0) != 0);
    }

    private <T> T get(IDataEntityProperty dp, Class<T> cls) {
        Object value = this.get(dp);
        if (value == null) {
            return null;
        }
        return (T)(cls.isAssignableFrom(value.getClass()) ? value : ObjectConverter.convert((Object)value, cls, (dp != null && dp.isEnableNull() ? 1 : 0) != 0));
    }

    public String getString(String propertyName) {
        return this.get(propertyName, String.class);
    }

    public String getString(int index) {
        return this.get(index, String.class);
    }

    public String getString(IDataEntityProperty dp) {
        return this.get(dp, String.class);
    }

    public ILocaleString getLocaleString(String propertyName) {
        return this.get(propertyName, ILocaleString.class);
    }

    public ILocaleString getLocaleString(int index) {
        return this.get(index, ILocaleString.class);
    }

    public ILocaleString getLocaleString(IDataEntityProperty dp) {
        return this.get(dp, ILocaleString.class);
    }

    public int getInt(String propertyName) {
        return this.get(propertyName, Integer.class);
    }

    public int getInt(int index) {
        return this.get(index, Integer.class);
    }

    public int getInt(IDataEntityProperty dp) {
        return this.get(dp, Integer.class);
    }

    public long getLong(String propertyName) {
        return this.get(propertyName, Long.class);
    }

    public long getLong(int index) {
        return this.get(index, Long.class);
    }

    public long getLong(IDataEntityProperty dp) {
        return this.get(dp, Long.class);
    }

    public boolean getBoolean(String propertyName) {
        return this.get(propertyName, Boolean.class);
    }

    public boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    public boolean getBoolean(IDataEntityProperty dp) {
        return this.get(dp, Boolean.class);
    }

    public BigDecimal getBigDecimal(String propertyName) {
        return this.get(propertyName, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(String propertyName, boolean enableNull) {
        if (enableNull && ((SimpleDynamicProperty)this.dt.getProps().get(propertyName)).getValueFast(this) == null) {
            return null;
        }
        return this.get(propertyName, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(int index) {
        return this.get(index, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(IDataEntityProperty dp) {
        return this.get(dp, BigDecimal.class);
    }

    public Date getDate(String propertyName) {
        return this.get(propertyName, Date.class);
    }

    public Date getDate(int index) {
        return this.get(index, Date.class);
    }

    public Date getDate(IDataEntityProperty dp) {
        return this.get(dp, Date.class);
    }

    public DynamicObject getDynamicObject(String propertyName) {
        return this.get(propertyName, DynamicObject.class);
    }

    public DynamicObject getDynamicObject(int index) {
        return this.get(index, DynamicObject.class);
    }

    public DynamicObject getDynamicObject(IDataEntityProperty dp) {
        return this.get(dp, DynamicObject.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(String propertyName) {
        return this.get(propertyName, DynamicObjectCollection.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(int index) {
        return this.get(index, DynamicObjectCollection.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(IDataEntityProperty dp) {
        return this.get(dp, DynamicObjectCollection.class);
    }

    public String toString() {
        return this.dt.toString() + this.dataStorage.toString();
    }

    public boolean isQueryObj() {
        return this.isQueryObj;
    }

    public SimpleDynamicObject[] getEntries(SimpleDynamicCollectionProperty collectionProperty) {
        Object valueFast = collectionProperty.getValueFast(this);
        if (valueFast == null) {
            return new SimpleDynamicObject[0];
        }
        return (SimpleDynamicObject[])valueFast;
    }

    public SimpleDynamicObject getRoot() {
        if (null == this._parent) {
            return this;
        }
        return this._parent.getRoot();
    }
}

