/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.flex;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.IFlexGrpMeta;
import kd.fi.v2.fah.models.modeling.base.BaseModelCollection;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.serializer.LongJsonDeserializer;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class FlexFieldGrpCfg
extends BaseModelCollection<String, FlexFieldCfg>
implements IFlexGrpMeta<FlexFieldCfg> {
    @JSONField(ordinal=111)
    protected boolean enabled;
    @JSONField(ordinal=112)
    protected String ownerEntityNum;
    @JSONField(ordinal=113)
    protected String ownerTableName;
    @JSONField(ordinal=114, deserializeUsing=LongJsonDeserializer.class)
    protected Long typeId;
    protected transient Map<String, FlexFieldCfg> dbFieldNumLookupIndex;

    public FlexFieldGrpCfg() {
    }

    public FlexFieldGrpCfg(Long id, String number, String name) {
        super(id, number, name);
    }

    @Override
    public String toString() {
        return "FlexFieldGrpCfg{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", enabled=" + this.enabled + ", ownerTableName='" + this.ownerTableName + '\'' + ", ownerEntityNum='" + this.ownerEntityNum + '\'' + ", typeId=" + this.typeId + ", collections=" + this.collections + ", dbFieldNumLookupIndex=" + this.dbFieldNumLookupIndex + ", description='" + this.description + '\'' + '}';
    }

    public void dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        if (output == null) {
            return;
        }
        output.append(StringUtils.buildPrefix(levelPrefix, level));
        output.append(String.format("[id=%s, number=%s, name=%s, TableName=%s, EntityNum=%s, typeId=%s]", this.id, this.number, this.name, this.ownerTableName, this.ownerEntityNum, this.typeId));
        String childPrefix = StringUtils.buildPrefix(levelPrefix, level + 1) + "\n";
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            for (FlexFieldCfg field : (BaseMutableArrayMapStorage)this.collections) {
                output.append(childPrefix).append(field.toString());
            }
        }
    }

    public void dumpCfgModel(StringBuilder output, int level) {
        this.dumpCfgModel(output, "   ", level);
    }

    public void dumpCfgModel(StringBuilder output) {
        this.dumpCfgModel(output, "   ", 0);
    }

    public List<String> getColumnNames(IValueSetMeta.ColumnNameType nameType) {
        LinkedList<String> result = new LinkedList<String>();
        for (FlexFieldCfg field : (BaseMutableArrayMapStorage)this.collections) {
            String buf;
            switch (nameType) {
                case Defined_Number: {
                    buf = field.getNumber();
                    break;
                }
                case Alias_Name: {
                    buf = field.getAlias();
                    break;
                }
                case Display_Name: {
                    buf = field.getName();
                    break;
                }
                case DB_Column_Number: {
                    buf = field.getDbFieldNum();
                    break;
                }
                case Description: {
                    buf = field.getDescription();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Column Name Type:" + (Object)((Object)nameType));
                }
            }
            result.add(buf);
        }
        return result;
    }

    @Override
    public FlexFieldCfg getFlexFieldCfgByFlexFieldNum(Object flexFieldNumber) {
        if (flexFieldNumber == null) {
            return null;
        }
        return (FlexFieldCfg)((BaseMutableArrayMapStorage)this.collections).get(flexFieldNumber.toString());
    }

    @Override
    public FlexFieldCfg getFlexFieldCfgByTableFieldNum(String tableFieldNum, int flexGrpCode) {
        if (StringUtils.isNotEmpty((String)tableFieldNum) && this.dbFieldNumLookupIndex != null) {
            return this.dbFieldNumLookupIndex.get(tableFieldNum);
        }
        return null;
    }

    protected boolean updateFlexFieldParent(Collection<FlexFieldCfg> newValues) {
        if (newValues == null || newValues.isEmpty()) {
            return false;
        }
        for (FlexFieldCfg cfg : newValues) {
            if (cfg == null) continue;
            cfg.set__parent(this);
        }
        return true;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        super.clear();
        if (this.dbFieldNumLookupIndex != null) {
            this.dbFieldNumLookupIndex.clear();
        }
    }

    @Override
    public void reset(int newSize, Class<FlexFieldCfg> clazzType) {
        if (this.dbFieldNumLookupIndex != null) {
            this.dbFieldNumLookupIndex.clear();
        }
        if (this.collections == null) {
            this.collections = this.__createStorage(newSize, clazzType);
        } else {
            ((BaseMutableArrayMapStorage)this.collections).reset(newSize, clazzType);
        }
    }

    protected boolean updateFlexFieldSeqNo(Collection<FlexFieldCfg> newValues) {
        return true;
    }

    @Override
    public int batchAdd(Collection<FlexFieldCfg> newValues) {
        int result;
        if (this.updateFlexFieldSeqNo(newValues) && (result = super.batchAdd(newValues)) >= 0) {
            if (this.dbFieldNumLookupIndex == null) {
                this.dbFieldNumLookupIndex = new HashMap<String, FlexFieldCfg>(newValues.size());
            }
            for (FlexFieldCfg fieldCfg : newValues) {
                this.dbFieldNumLookupIndex.put(fieldCfg.getDbFieldNum(), fieldCfg);
            }
        }
        return -1;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        if (this.collections != null) {
            if (((BaseMutableArrayMapStorage)this.collections).getValues() == null) {
                this.updateFlexFieldParent(((BaseMutableArrayMapStorage)this.collections).getCacheList());
            }
            return ((BaseMutableArrayMapStorage)this.collections).flush();
        }
        return false;
    }

    @Override
    public List<FlexFieldCfg> getAllSortedFlexFieldCfgs() {
        return this.getSortedFlexFieldCfgs(-1);
    }

    @Override
    public List<FlexFieldCfg> getSortedFlexFieldCfgs(int flexGrpCode) {
        List<FlexFieldCfg> result = Arrays.asList(((BaseMutableArrayMapStorage)this.collections).getValues());
        FlexFieldCfg cfg = new FlexFieldCfg();
        result.sort((o, n) -> cfg.compare(o, n));
        return result;
    }

    @Override
    public void forEach(BiConsumer<Integer, FlexFieldCfg> consumer) {
        if (consumer == null || this.collections == null || ((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            return;
        }
        int i = 0;
        for (FlexFieldCfg fieldCfg : (BaseMutableArrayMapStorage)this.collections) {
            consumer.accept(i++, fieldCfg);
        }
    }

    @Override
    public int totalFieldCnt() {
        return this.size();
    }

    @Override
    public String getFlexStructNumber() {
        return this.ownerEntityNum;
    }

    @Override
    public DataValueTypeEnum getColumnDataType(int index) {
        return ((FlexFieldCfg)((BaseMutableArrayMapStorage)this.collections).get(index)).getDataType();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getOwnerEntityNum() {
        return this.ownerEntityNum;
    }

    public void setOwnerEntityNum(String ownerEntityNum) {
        this.ownerEntityNum = ownerEntityNum;
    }

    @Override
    public String getOwnerTableName() {
        return this.ownerTableName;
    }

    public void setOwnerTableName(String ownerTableName) {
        this.ownerTableName = ownerTableName;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int columnCnt() {
        return this.size();
    }

    @Override
    public FlexFieldCfg getColumnBySeq(int index) {
        return this.collections != null ? (FlexFieldCfg)((BaseMutableArrayMapStorage)this.collections).get(index) : null;
    }

    @Override
    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }
}

