/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.modeling.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.migration.common.ICustomDataMigration;
import kd.fi.v2.fah.models.modeling.IDataModel;
import kd.fi.v2.fah.models.modeling.IHasParentHierarchy;
import kd.fi.v2.fah.models.modeling.base.BaseModelCollection;
import kd.fi.v2.fah.models.modeling.base.BaseModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.serializer.LongJsonDeserializer;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;

public class DataModelCfg
extends BaseModelCollection<String, DataModelFieldCollection>
implements IDataModel,
IHasParentHierarchy<DataModelCollection>,
ICustomDataMigration {
    protected transient DataModelCollection __parent;
    @JSONField(ordinal=110)
    protected BaseModelFieldCfg[] primaryKey;
    @JSONField(ordinal=111)
    protected Object version;
    @JSONField(ordinal=112, deserializeUsing=LongJsonDeserializer.class)
    protected Long group;
    @JSONField(ordinal=117)
    protected String groupNumber;
    @JSONField(ordinal=113)
    protected String templateno;
    @JSONField(ordinal=114)
    protected Map<String, Set<String>> entryHierarchyIndex;
    @JSONField(ordinal=115, deserializeUsing=LongJsonDeserializer.class)
    protected Long masterId;
    @JSONField(ordinal=116, deserializeUsing=LongJsonDeserializer.class)
    protected Long creatorId;
    private transient Map<Long, PairTuple<DataModelFieldCollection, List<Long>>> collectionIdIndex;
    private transient ArrayList<List<Long>> collectionHierarchy;

    public DataModelCfg() {
    }

    public DataModelCfg(Long id, String number, String name) {
        super(id, number, name);
    }

    @Override
    protected DataModelFieldCollection updateValueReference(DataModelFieldCollection value, boolean asDelete) {
        if (super.updateValueReference(value, asDelete) != null) {
            if (this.entryHierarchyIndex == null && !asDelete) {
                this.entryHierarchyIndex = new HashMap<String, Set<String>>(4);
            }
            this.__inner_UpdateValueReference(value.getNumber(), asDelete);
        }
        return value;
    }

    @Override
    protected void batchUpdateValueReference(Iterator<DataModelFieldCollection> values, boolean asDelete) {
        if (values != null && values.hasNext()) {
            if (this.entryHierarchyIndex == null && !asDelete) {
                this.entryHierarchyIndex = new HashMap<String, Set<String>>(4);
            }
            values.forEachRemaining(item -> this.__inner_UpdateValueReference(item.getNumber(), asDelete));
        }
    }

    protected void __inner_UpdateValueReference(String longNumber, boolean asDelete) {
        int lastIndex = longNumber.lastIndexOf(124);
        if (lastIndex >= 0) {
            String parentNumber = longNumber.substring(0, lastIndex);
            if (asDelete) {
                this.entryHierarchyIndex.getOrDefault(parentNumber, Collections.emptySet()).remove(longNumber);
            } else {
                this.entryHierarchyIndex.computeIfAbsent(parentNumber, v -> new LinkedHashSet(4)).add(longNumber);
            }
        }
    }

    public Set<String> getEntryHierarchyIndexList(String entryName) {
        if (this.entryHierarchyIndex == null || this.entryHierarchyIndex.isEmpty()) {
            return Collections.emptySet();
        }
        return this.entryHierarchyIndex.getOrDefault(entryName, Collections.emptySet());
    }

    public boolean isEntryGroupEntry(String entryName) {
        if (this.entryHierarchyIndex == null || this.entryHierarchyIndex.isEmpty()) {
            return false;
        }
        return !this.entryHierarchyIndex.getOrDefault(entryName, Collections.emptySet()).isEmpty();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        super.clear();
        this.entryHierarchyIndex = null;
        this.collectionIdIndex = null;
        this.collectionHierarchy = null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<String, Set<String>> getEntryHierarchyIndex() {
        return Collections.unmodifiableMap(this.entryHierarchyIndex);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getFieldCount(String ... fieldGrps) {
        if (this.collections == null || ((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            return 0;
        }
        Collection<String> fieldGrpKeys = fieldGrps == null || fieldGrps.length <= 0 ? ((BaseMutableArrayMapStorage)this.collections).getIndexMap().keySet() : Arrays.asList(fieldGrps);
        int cnt = 0;
        for (String key : fieldGrpKeys) {
            DataModelFieldCollection fieldCollection = (DataModelFieldCollection)((BaseMutableArrayMapStorage)this.collections).get(key);
            if (fieldCollection == null || fieldCollection.isEmpty()) continue;
            cnt += fieldCollection.size();
        }
        return cnt;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<String, DataModelFieldCfg> allFieldCfgMap() {
        int fieldCount = this.getFieldCount(new String[0]);
        if (fieldCount > 0) {
            HashMap<String, DataModelFieldCfg> fieldCfgMap = new HashMap<String, DataModelFieldCfg>(fieldCount);
            this.forEachField((grpKey, fieldCfg) -> {
                fieldCfgMap.put(fieldCfg.getItemKey().toLowerCase(), (DataModelFieldCfg)fieldCfg);
                return true;
            });
            return fieldCfgMap;
        }
        return Collections.emptyMap();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void forEachField(BiFunction<String, DataModelFieldCfg, Boolean> fieldProcessFunc) {
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty() && fieldProcessFunc != null) {
            for (DataModelFieldCollection fieldCollection : (BaseMutableArrayMapStorage)this.collections) {
                if (fieldCollection.isEmpty()) continue;
                String fieldGrpKey = fieldCollection.getItemKey();
                fieldCollection.forEachField((Integer index, DataModelFieldCfg field) -> (Boolean)fieldProcessFunc.apply(fieldGrpKey, (DataModelFieldCfg)field));
            }
        }
    }

    private void ensureCapacity(List target, int requiredSize) {
        if (requiredSize >= target.size()) {
            for (int i = 0; i < requiredSize - target.size(); ++i) {
                target.add(null);
            }
        }
    }

    private void updateCollectionHierarchyIndex(boolean forceUpdate) {
        if (this.collectionIdIndex != null && !forceUpdate) {
            return;
        }
        if (this.collectionIdIndex != null) {
            this.collectionIdIndex.clear();
            this.collectionHierarchy.clear();
        } else {
            this.collectionIdIndex = new HashMap<Long, PairTuple<DataModelFieldCollection, List<Long>>>(this.size());
            this.collectionHierarchy = new ArrayList(3);
            this.collectionHierarchy.add(new ArrayList(1));
        }
        for (DataModelFieldCollection fieldCfgCollection : (BaseMutableArrayMapStorage)this.collections) {
            if (fieldCfgCollection.getGroupType() == DefaultDataFieldGroupEnum.CUSTOM) continue;
            long _collectionId = fieldCfgCollection.getId();
            this.collectionIdIndex.put(_collectionId, (PairTuple<DataModelFieldCollection, List<Long>>)new PairTuple((Object)fieldCfgCollection, null));
            PairTuple<DataModelFieldCollection, List<Long>> _parentBuf = this.collectionIdIndex.get(fieldCfgCollection.getParentId());
            if (_parentBuf != null) {
                LinkedList<Long> childEntryIds = (LinkedList<Long>)_parentBuf.getValue();
                if (childEntryIds == null) {
                    childEntryIds = new LinkedList<Long>();
                    _parentBuf.setValue(childEntryIds);
                }
                childEntryIds.add(fieldCfgCollection.getId());
            }
            int _groupLevel = fieldCfgCollection.getGroupLevel();
            this.ensureCapacity(this.collectionHierarchy, _groupLevel + 1);
            List<Long> curLevelIds = this.collectionHierarchy.get(_groupLevel);
            if (curLevelIds == null) {
                curLevelIds = new LinkedList<Long>();
                this.collectionHierarchy.set(_groupLevel, curLevelIds);
            }
            curLevelIds.add(_collectionId);
        }
    }

    protected JSONObject buildJson(JSONObject parentJson, int dataCnt, boolean skipNullValue, Function<String, Integer> entryDataCnt, BiFunction<Integer, DataModelFieldCfg, Object> dataGenFunc) {
        if (dataCnt <= 0 || this.isEmpty()) {
            return new JSONObject(new LinkedHashMap(1));
        }
        this.updateCollectionHierarchyIndex(false);
        int sizCnt = this.collectionHierarchy.size() - 1;
        for (Long headId : this.collectionHierarchy.get(0)) {
            sizCnt += ((DataModelFieldCollection)this.collectionIdIndex.get(headId).getKey()).size();
        }
        JSONObject rootJson = parentJson == null ? new JSONObject(new LinkedHashMap(sizCnt)) : parentJson;
        int level = 0;
        for (List<Long> entryIds : this.collectionHierarchy) {
            for (Long id : entryIds) {
                PairTuple<DataModelFieldCollection, List<Long>> en = this.collectionIdIndex.get(id);
                DataModelFieldCollection fieldCollectionBuf = (DataModelFieldCollection)en.getKey();
                if (level != 1) continue;
                if (fieldCollectionBuf.getGroupType() == DefaultDataFieldGroupEnum.HEAD) {
                    fieldCollectionBuf.buildJson(rootJson, 0, skipNullValue, dataGenFunc);
                    continue;
                }
                if (fieldCollectionBuf.getGroupType() != DefaultDataFieldGroupEnum.ENTRY) continue;
                this._buildSubEntryJson(rootJson, en, entryDataCnt.apply(((DataModelFieldCollection)en.getKey()).getNumber()), skipNullValue, entryDataCnt, dataGenFunc);
            }
            if (++level <= 1) continue;
            break;
        }
        return rootJson;
    }

    protected JSONObject buildJson(int dataCnt, boolean skipNullValue, Function<String, Integer> entryDataCnt, BiFunction<Integer, DataModelFieldCfg, Object> dataGenFunc) {
        return this.buildJson(new JSONObject(new LinkedHashMap(8)), dataCnt, skipNullValue, entryDataCnt, dataGenFunc);
    }

    public JSONObject buildJson(int dataCnt) {
        return this.buildJson(dataCnt, false, k -> dataCnt, (idx, field) -> field.getFormattedDefaultValue());
    }

    protected void _buildSubEntryJson(JSONObject parentJson, PairTuple<DataModelFieldCollection, List<Long>> collectionCfg, int dataCnt, boolean skipNullValue, Function<String, Integer> entryDataCnt, BiFunction<Integer, DataModelFieldCfg, Object> dataGenFunc) {
        JSONArray entryJsonArray = new JSONArray(new ArrayList(dataCnt));
        DataModelFieldCollection collectionBuf = (DataModelFieldCollection)collectionCfg.getKey();
        List childEntryIds = (List)collectionCfg.getValue();
        int entryFieldCnt = collectionBuf.size() + (childEntryIds == null ? 0 : childEntryIds.size());
        parentJson.put(DataModelUtils.getNumber(collectionBuf.getNumber()), (Object)entryJsonArray);
        for (int i = 0; i < dataCnt; ++i) {
            JSONObject currentEntryJsonBuf = new JSONObject(new LinkedHashMap(entryFieldCnt));
            entryJsonArray.add((Object)collectionBuf.buildJson(currentEntryJsonBuf, i, skipNullValue, dataGenFunc));
            if (childEntryIds == null || childEntryIds.isEmpty()) continue;
            for (Long childId : childEntryIds) {
                PairTuple<DataModelFieldCollection, List<Long>> en = this.collectionIdIndex.get(childId);
                this._buildSubEntryJson(currentEntryJsonBuf, en, entryDataCnt.apply(((DataModelFieldCollection)en.getKey()).getNumber()), skipNullValue, entryDataCnt, dataGenFunc);
            }
        }
    }

    public BaseModelFieldCfg[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(BaseModelFieldCfg[] primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Object getVersion() {
        return this.version;
    }

    public void setVersion(Object version) {
        this.version = version;
    }

    public Long getGroup() {
        return this.group;
    }

    public void setGroup(Long group) {
        this.group = group;
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    public String getTemplateno() {
        return this.templateno;
    }

    public void setTemplateno(String templateno) {
        this.templateno = templateno;
    }

    public Long getMasterId() {
        return this.masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    @Override
    public DataModelCollection getParent() {
        return this.__parent;
    }

    @Override
    public void setParent(DataModelCollection parent) {
        this.__parent = parent;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        if (this.collections != null && ((BaseMutableArrayMapStorage)this.collections).cachedSize() > 0) {
            ArrayList cacheBackup = new ArrayList(((BaseMutableArrayMapStorage)this.collections).getCacheList());
            if (((BaseMutableArrayMapStorage)this.collections).flush()) {
                this.batchUpdateValueReference(cacheBackup.iterator(), false);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setCollections(BaseMutableArrayMapStorage<String, DataModelFieldCollection> collections) {
        super.setCollections(collections);
        if (collections != null) {
            collections.forEach(c -> {
                if (c != null) {
                    c.setParent(this);
                }
            });
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getMainTableName() {
        return "fah_e_" + this.number;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelCfg that = (DataModelCfg)o;
        return Objects.equals(this.__parent, that.__parent) && Arrays.equals(this.primaryKey, that.primaryKey) && Objects.equals(this.version, that.version) && Objects.equals(this.group, that.group) && Objects.equals(this.templateno, that.templateno) && Objects.equals(this.entryHierarchyIndex, that.entryHierarchyIndex) && Objects.equals(this.masterId, that.masterId) && Objects.equals(this.creatorId, that.creatorId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.__parent, this.version, this.group, this.templateno, this.entryHierarchyIndex, this.masterId, this.creatorId);
        result = 31 * result + Arrays.hashCode(this.primaryKey);
        return result;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void onAfterLoadMigrationDataModel(Object dataVersion) {
        if (this.collections == null) {
            return;
        }
        for (DataModelFieldCollection fields : (BaseMutableArrayMapStorage)this.collections) {
            if (fields == null) continue;
            fields.onAfterLoadMigrationDataModel(dataVersion);
        }
    }
}

