/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.serialize;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.fi.v2.fah.serializer.ICustomJsonSerialize;
import kd.fi.v2.fah.serializer.ICustomJsonSerializeOutputClassName;

public class JsonSerializeNodeWrapper {
    @JSONField(ordinal=0, name="_class")
    protected Class sourceClass;
    @JSONField(ordinal=1, name="_ver")
    protected int version = 0;
    @JSONField(ordinal=2, name="_flags")
    protected int controlFlag = 0;
    @JSONField(ordinal=3, name="_customClass")
    protected Class customSerializeClass;
    @JSONField(ordinal=4, name="datas")
    protected Object data;
    private static final String[] Check_JSON_FieldName = new String[]{"_class", "_ver", "_flags", "_customClass"};

    protected JsonSerializeNodeWrapper() {
    }

    public static boolean isJsonSerializeNodeWrapper(JSONObject source) {
        if (source == null) {
            return false;
        }
        for (String checkStr : Check_JSON_FieldName) {
            if (source.containsKey((Object)checkStr)) continue;
            return false;
        }
        return true;
    }

    protected JsonSerializeNodeWrapper(Object data, boolean requiredRebuild) {
        this();
        if (requiredRebuild) {
            this.controlFlag |= 2;
        }
        if ((this.data = data) == null) {
            throw new IllegalArgumentException("Source Object is null!");
        }
        this.sourceClass = this.data.getClass();
        if (!(data instanceof ICustomJsonSerialize)) {
            return;
        }
        ICustomJsonSerialize customJson = (ICustomJsonSerialize)data;
        if (!customJson.needToSerialize()) {
            return;
        }
        this.customSerializeClass = customJson.getCustomSerializeClass();
        if (this.customSerializeClass == null) {
            throw new IllegalArgumentException("Custom Serialize Class is null!");
        }
        if (this.customSerializeClass.isInterface() && !ICustomJsonSerializeOutputClassName.class.isAssignableFrom(this.customSerializeClass)) {
            throw new IllegalArgumentException(String.format("CustomSerialize Class Cannot be Interface! (Try to extends [%s] from ICustomJsonSerializeOutputClassName.class)", this.customSerializeClass));
        }
        this.version = customJson.getVersion();
        this.setFlag(JsonSerializeControlFlagEnum.Use_Custom_Serialize_Class.bitPos);
        if (customJson.isCaseSensitive()) {
            this.setFlag(JsonSerializeControlFlagEnum.CaseSensitive.bitPos);
        }
        if (customJson.isNeedRebuildAfterDeSerialize()) {
            this.setFlag(JsonSerializeControlFlagEnum.Rebuild_After_DeSerialize.bitPos);
        }
    }

    public JsonSerializeNodeWrapper(Object data) {
        this(data, false);
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected boolean getFlag(int bitPos) {
        return (this.controlFlag >> bitPos & 1) > 0;
    }

    private void setFlag(int bitPos) {
        this.controlFlag |= 1 << bitPos;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isRequiredRebuild() {
        return this.getFlag(JsonSerializeControlFlagEnum.Rebuild_After_DeSerialize.bitPos);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isUseCustomSerializeClass() {
        return this.getFlag(JsonSerializeControlFlagEnum.Use_Custom_Serialize_Class.bitPos);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isCaseSensitive() {
        return this.getFlag(JsonSerializeControlFlagEnum.CaseSensitive.bitPos);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int getControlFlag() {
        return this.controlFlag;
    }

    public void setControlFlag(int controlFlag) {
        this.controlFlag = controlFlag;
    }

    public Class getCustomSerializeClass() {
        return this.customSerializeClass;
    }

    public void setCustomSerializeClass(Class customSerializeClass) {
        this.customSerializeClass = customSerializeClass;
    }

    public static enum JsonSerializeControlFlagEnum {
        Use_Custom_Serialize_Class(0),
        Rebuild_After_DeSerialize(1),
        CaseSensitive(2);

        int bitPos;

        private JsonSerializeControlFlagEnum(int bitPos) {
            this.bitPos = bitPos;
        }

        public int getBitPos() {
            return this.bitPos;
        }
    }
}

