/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.table.meta.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.fi.bd.model.common.PairTuple;

public class SimpleTableRelationshipMeta
implements Serializable {
    protected String leftTableNum;
    protected String rightTableNum;
    protected List<PairTuple<String, String>> joinFields;

    public SimpleTableRelationshipMeta() {
    }

    public SimpleTableRelationshipMeta(String leftTableNum, String rightTableNum) {
        this.leftTableNum = leftTableNum;
        this.rightTableNum = rightTableNum;
        this.joinFields = new LinkedList<PairTuple<String, String>>();
    }

    public SimpleTableRelationshipMeta(String leftTable, String rightTable, String leftField, String rightField) {
        this(leftTable, rightTable, Collections.singletonList(new PairTuple((Object)leftField, (Object)rightField)));
    }

    public SimpleTableRelationshipMeta(String leftTable, String rightTable, List<PairTuple<String, String>> joinFields) {
        this(leftTable, rightTable);
        if (joinFields == null || joinFields.isEmpty()) {
            throw new IllegalArgumentException("Table Join Field cannot be null!");
        }
        this.joinFields = joinFields;
    }

    public String toString() {
        return "SimpleTableRelationshipMeta{leftTableNum='" + this.leftTableNum + '\'' + ", rightTableNum='" + this.rightTableNum + '\'' + ", joinFields=" + this.joinFields + '}';
    }

    public String getLinkTargetTable(String sourceTable) {
        if (sourceTable == null) {
            return null;
        }
        return sourceTable.equals(this.leftTableNum) ? this.rightTableNum : this.leftTableNum;
    }

    public void addTableJoinFields(String leftTableField, String rightTableField) {
        this.joinFields.add((PairTuple<String, String>)new PairTuple((Object)leftTableField, (Object)rightTableField));
    }

    public String getLeftTableNum() {
        return this.leftTableNum;
    }

    public void setLeftTableNum(String leftTableNum) {
        this.leftTableNum = leftTableNum;
    }

    public String getRightTableNum() {
        return this.rightTableNum;
    }

    public void setRightTableNum(String rightTableNum) {
        this.rightTableNum = rightTableNum;
    }

    public List<PairTuple<String, String>> getJoinFields() {
        return this.joinFields;
    }

    public void setJoinFields(List<PairTuple<String, String>> joinFields) {
        this.joinFields = joinFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleTableRelationshipMeta)) {
            return false;
        }
        SimpleTableRelationshipMeta that = (SimpleTableRelationshipMeta)o;
        return Objects.equals(this.leftTableNum, that.leftTableNum) && Objects.equals(this.rightTableNum, that.rightTableNum) && Objects.equals(this.joinFields, that.joinFields);
    }

    public int hashCode() {
        return Objects.hash(this.leftTableNum, this.rightTableNum, this.joinFields);
    }
}

