/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;

public interface IBaseBatchValueSet<T extends IBaseSimpleValueSet> {
    public long getTotalRowCnt();

    public Iterator<T> getBatchIterator(int var1);

    default public void forEach(int batchSize, BiFunction<Integer, ? super T, Boolean> action) {
        Objects.requireNonNull(action);
        int batchCnt = 0;
        Iterator<T> it = this.getBatchIterator(batchSize);
        while (it.hasNext()) {
            if (action.apply(batchCnt++, (Integer)it.next()).booleanValue()) continue;
            return;
        }
    }

    default public int getBatchCnt(int batchSize) {
        long totalCnt = this.getTotalRowCnt();
        if (totalCnt <= 0L) {
            return 0;
        }
        if (batchSize <= 0) {
            return 1;
        }
        return (int)(totalCnt / (long)batchSize + (long)(totalCnt % (long)batchSize > 0L ? 1 : 0));
    }
}

