/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Iterator;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;
import kd.fi.v2.fah.models.valueset.IGroupSimpleBaseValueSetCollection;
import kd.fi.v2.fah.storage.ICacheableOpenDataStorage;
import kd.fi.v2.fah.storage.IOpenDataStorage;

public abstract class AbstractBaseValueSetCollection<T extends IBaseSimpleValueSet, STORAGE extends IOpenDataStorage<T>>
implements IGroupSimpleBaseValueSetCollection<T>,
ICacheableOpenDataStorage<T> {
    protected int currentUsedDataGroupIndex;
    protected transient int columnCnt;
    protected STORAGE[] _storageDatas;
    protected boolean reserveColumnPosition;
    protected Object[] reserveColumnDataBuffer;

    protected AbstractBaseValueSetCollection() {
        this(0);
    }

    public AbstractBaseValueSetCollection(int columnCnt) {
        this.currentUsedDataGroupIndex = 0;
        this.columnCnt = columnCnt;
    }

    protected AbstractBaseValueSetCollection(int columnCnt, STORAGE _storageDatas, boolean reserveColumnPosition, Object[] reserveColumnDataBuffer) {
        this._storageDatas = this.createStorage(this.getTotalDataGroupCnt());
        this.columnCnt = columnCnt;
        this.reserveColumnPosition = reserveColumnPosition;
        this.reserveColumnDataBuffer = reserveColumnDataBuffer;
    }

    protected abstract STORAGE[] createStorage(int var1);

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int getTotalDataGroupCnt() {
        return 1;
    }

    protected PairTuple<Boolean, Object[]> getReserveColumnData() {
        return new PairTuple((Object)this.reserveColumnPosition, (Object)this.reserveColumnDataBuffer);
    }

    protected abstract void updateItemReference(int var1);

    protected abstract STORAGE getValueSetCollection(int var1);

    protected abstract T getValueSetCollection(int var1, int var2);

    protected abstract T[] getValues(int var1);

    protected int size(int rowDataGrpIdx) {
        return this.getValueSetCollection(rowDataGrpIdx).size();
    }

    protected boolean isEmpty(int rowDataGrpIdx) {
        return this.getValueSetCollection(rowDataGrpIdx).isEmpty();
    }

    protected abstract T get(int var1, int var2);

    protected Iterator<T> iterator(int rowDataGrpIdx) {
        return this.getValueSetCollection(rowDataGrpIdx).iterator();
    }

    protected T[] toArray(int rowDataGrpIdx) {
        return (IBaseSimpleValueSet[])this._storageDatas[rowDataGrpIdx].getValues();
    }

    protected abstract int cache(int var1, T var2);

    protected abstract int cachedSize(int var1);

    protected abstract boolean flush(int var1);

    protected abstract boolean clearCache(int var1);

    protected long getTotalRowCnt(int rowDataGrpIdx) {
        return this.getValueSetCollection(rowDataGrpIdx).size();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this.size(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this.isEmpty(this.currentUsedDataGroupIndex);
    }

    @Override
    public T get(int index) {
        return this.get(this.currentUsedDataGroupIndex, index);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.currentUsedDataGroupIndex);
    }

    public T[] getValues() {
        return this.getValues(this.currentUsedDataGroupIndex);
    }

    @Override
    public int moveToNextDataGroup() {
        if (this.currentUsedDataGroupIndex >= this.getTotalDataGroupCnt() - 1) {
            return -1;
        }
        return ++this.currentUsedDataGroupIndex;
    }

    @Override
    public int cache(T value) {
        return this.cache(this.currentUsedDataGroupIndex, value);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int cachedSize() {
        return this.cachedSize(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        return this.flush(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean clearCache() {
        return this.clearCache(this.currentUsedDataGroupIndex);
    }

    @Override
    public int getCurrentUsedDataGroupIndex() {
        return this.currentUsedDataGroupIndex;
    }

    @Override
    public void setCurrentUsedDataGroupIndex(int currentUsedDataGroupIndex) {
        this.currentUsedDataGroupIndex = currentUsedDataGroupIndex;
    }

    public void setColumnCnt(int columnCnt) {
        this.columnCnt = columnCnt;
    }

    public int getColumnCnt() {
        return this.columnCnt;
    }

    public STORAGE[] get_storageDatas() {
        return this._storageDatas;
    }

    public void set_storageDatas(STORAGE[] _storageDatas) {
        this._storageDatas = _storageDatas;
    }

    public boolean isReserveColumnPosition() {
        return this.reserveColumnPosition;
    }

    public void setReserveColumnPosition(boolean reserveColumnPosition) {
        this.reserveColumnPosition = reserveColumnPosition;
    }

    public Object[] getReserveColumnDataBuffer() {
        return this.reserveColumnDataBuffer;
    }

    public void setReserveColumnDataBuffer(Object[] reserveColumnDataBuffer) {
        this.reserveColumnDataBuffer = reserveColumnDataBuffer;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        this.clearCache(this.currentUsedDataGroupIndex);
        this.getValueSetCollection(this.currentUsedDataGroupIndex).clear();
    }
}

