/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.valueset.IBaseSimpleWritableValueSet;
import kd.fi.v2.fah.storage.impl.MutableArrayStorage;
import kd.fi.v2.fah.utils.ArrayUtils;
import kd.fi.v2.fah.utils.FastHashHelper;

public class SimpleBaseValueSet<V>
implements IBaseSimpleWritableValueSet<V>,
Serializable {
    protected transient Long hashCode;
    protected transient Supplier<PairTuple<Boolean, V[]>> reserveDataSupplier;
    protected MutableArrayStorage<V> _storageData;

    public SimpleBaseValueSet() {
    }

    public SimpleBaseValueSet(int colCount, Class<V> clazzType) {
        this();
        this._storageData = new MutableArrayStorage(colCount, clazzType);
    }

    public String toString() {
        return "SimpleBaseValueSet{hashCode=" + this.hashCode + ", reserveDataSupplier=" + this.reserveDataSupplier + ", _storageData=" + this._storageData + '}';
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this._storageData != null ? this._storageData.size() : 0;
    }

    @Override
    public int setColumnValue(int colIdx, V newValue, boolean addOrUpdate) {
        this._storageData.set(colIdx, newValue);
        return colIdx;
    }

    @Override
    public int addColumnValue(int colIdx, V newValue) {
        this._storageData.set(colIdx, newValue);
        return colIdx;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this._storageData == null || this._storageData.isEmpty();
    }

    @Override
    public V get(int colIndex) {
        return this._storageData.get(colIndex);
    }

    protected <T> T __getValueByIndex(int colIndex) {
        return (T)this._storageData.get(colIndex);
    }

    protected void __setValueByIndex(int index, V value) {
        this._storageData.set(index, value);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public V[] getValues() {
        return this._storageData.getValues();
    }

    @Override
    public V[] getCombineValues() {
        Object[] reserveData;
        PairTuple<Boolean, V[]> reserve;
        if (this.reserveDataSupplier != null && (reserve = this.reserveDataSupplier.get()).getValue() != null && (reserveData = (Object[])reserve.getValue()) != null && reserveData.length > 0) {
            return ArrayUtils.combineArray(reserveData, this.getValues(), (Boolean)reserve.getKey());
        }
        return this.getValues();
    }

    @Override
    public void setReserveDataSupplier(Supplier<PairTuple<Boolean, V[]>> reserveDataSupplier) {
        this.reserveDataSupplier = reserveDataSupplier;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Supplier<PairTuple<Boolean, V[]>> getReserveDataSupplier() {
        return this.reserveDataSupplier;
    }

    @Override
    public void _updateStorageValues(V[] newValues, boolean skipColumnCntCheck) {
        if (newValues == null) {
            this._storageData.clear();
        } else {
            if (!skipColumnCntCheck && this._storageData.size() != newValues.length) {
                throw new IllegalArgumentException(String.format("New Data Column Count[%d] is not equal to required Column Count[%d]!", newValues.length, this._storageData.size()));
            }
            this._storageData.setValues(newValues);
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<V> getValueIterator() {
        return this._storageData.iterator();
    }

    @Override
    public int forEach(BiFunction<Integer, V, Boolean> valueConsumer) {
        if (valueConsumer == null) {
            return 0;
        }
        int colIdx = 0;
        for (V v : this._storageData) {
            valueConsumer.apply(colIdx++, v);
        }
        return colIdx;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public long getHashCode() {
        if (this.hashCode == null) {
            this.hashCode = FastHashHelper.getHashCode(this._storageData.getValues());
        }
        return this.hashCode;
    }

    public void setHashCode(Long hashCode) {
        this.hashCode = hashCode;
    }

    public MutableArrayStorage<V> get_storageData() {
        return this._storageData;
    }

    public void set_storageData(MutableArrayStorage<V> _storageData) {
        this._storageData = _storageData;
    }
}

